/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.query;

import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import org.apache.openjpa.persistence.Extent;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.jdbc.FetchMode;
import org.apache.openjpa.persistence.jdbc.JDBCFetchPlan;
import org.apache.openjpa.persistence.query.BaseQueryTest;
import org.apache.openjpa.persistence.query.common.apps.RuntimeTest1;
import org.apache.openjpa.persistence.query.common.apps.RuntimeTest2;
import org.apache.openjpa.persistence.query.common.apps.RuntimeTest3;

public class TestQueryResults
extends BaseQueryTest {
    public TestQueryResults(String test) {
        super(test);
    }

    public void setUp() {
        this.deleteAll(RuntimeTest1.class);
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        em.persist((Object)new RuntimeTest1("TestQueryResults1", 10));
        em.persist((Object)new RuntimeTest1("TestQueryResults3", 10));
        em.persist((Object)new RuntimeTest1("TestQueryResults5", 10));
        em.persist((Object)new RuntimeTest3("TestQueryResults2", 10));
        em.persist((Object)new RuntimeTest3("TestQueryResults4", 10));
        em.persist((Object)new RuntimeTest3("TestQueryResults6", 10));
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testQueryIteratorsReturnFalseForClosedQuery() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        OpenJPAQuery q = em.createQuery("SELECT o FROM RuntimeTest1 o");
        List c = q.getResultList();
        Iterator i = c.iterator();
        if (!i.hasNext()) {
            TestQueryResults.fail((String)"Iterator should have had next()");
        }
        q.closeAll();
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
        if (i.hasNext()) {
            TestQueryResults.fail((String)"Iterator obtained from Query should return false for hasNext() after Query has been closed");
        }
    }

    public void testQueryIteratorsThrowExceptionForClosedQuery() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        OpenJPAQuery q = em.createQuery("SELECT o FROM RuntimeTest1 o");
        List c = q.getResultList();
        Iterator i = c.iterator();
        if (!i.hasNext()) {
            TestQueryResults.fail((String)"Iterator should have had next()");
        }
        q.closeAll();
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
        try {
            i.next();
            TestQueryResults.fail((String)"Iterator.next() should have thrown Exception after query.closeAll() was called");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testLazyQueryIteratorsReturnFalseForClosedem() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        String query = "SELECT o FROM RuntimeTest1 o";
        OpenJPAQuery q = em.createQuery(query);
        q.getFetchPlan().setFetchBatchSize(5);
        List c = q.getResultList();
        Iterator i = c.iterator();
        if (!i.hasNext()) {
            TestQueryResults.fail((String)"Iterator should have had next()");
        }
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
        if (i.hasNext()) {
            TestQueryResults.fail((String)"Lazy result iterator obtained from Query should return false for hasNext() after em has been closed");
        }
    }

    public void testEagerQueryIteratorsWorkForClosedem() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        String query = "SELECT o FROM RuntimeTest1 o";
        OpenJPAQuery q = em.createQuery(query);
        q.getFetchPlan().setFetchBatchSize(-1);
        List c = q.getResultList();
        Iterator i = c.iterator();
        if (!i.hasNext()) {
            TestQueryResults.fail((String)"Iterator should have had next()");
        }
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
        if (!i.hasNext()) {
            TestQueryResults.fail((String)"Eager result iterator obtained from Query should return true for hasNext() after em has been closed");
        }
    }

    public void testQueryResultIsList() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        String query = "SELECT o FROM RuntimeTest1 o";
        List c = em.createQuery(query).getResultList();
        if (!(c instanceof List)) {
            TestQueryResults.fail((String)("Collection (" + c.getClass() + ") should have been a List instance"));
        }
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testQueryResultSizeIsCorrect() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        em.persist((Object)new RuntimeTest2("TestQueryResults1", 10));
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        String query = "SELECT r FROM RuntimeTest2 r WHERE r.stringField = 'TestQueryResults1'";
        List c = em.createQuery(query).getResultList();
        TestQueryResults.assertEquals((int)1, (int)c.size());
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testExtentIteratorsReturnFalseForClosedExtent() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        Extent extent = em.createExtent(RuntimeTest1.class, true);
        Iterator i = extent.iterator();
        if (!i.hasNext()) {
            TestQueryResults.fail((String)"Iterator should have had next()");
        }
        extent.closeAll();
        if (i.hasNext()) {
            TestQueryResults.fail((String)"Iterator obtained from Extent should return false for hasNext() after Extent has been closed");
        }
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testExtentIteratorsThrowExceptionForClosedExtent() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        Extent extent = em.createExtent(RuntimeTest1.class, true);
        Iterator i = extent.iterator();
        if (!i.hasNext()) {
            TestQueryResults.fail((String)"Iterator should have had next()");
        }
        extent.closeAll();
        try {
            i.next();
            TestQueryResults.fail((String)"Iterator.next() should have thrown Exception after Extent.closeAll() was called");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testExtentIteratorsReturnFalseForClosedem() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        Extent extent = em.createExtent(RuntimeTest1.class, true);
        Iterator i = extent.iterator();
        if (!i.hasNext()) {
            TestQueryResults.fail((String)"Iterator should have had next()");
        }
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
        if (i.hasNext()) {
            TestQueryResults.fail((String)"Iterator obtained from Extent should return false for hasNext() after em has been closed");
        }
    }

    public void testUniqueReturnsSingleResult() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        String query = "SELECT DISTINCT r FROM RuntimeTest1 r WHERE r.stringField = 'TestQueryResults1'";
        Object obj = em.createQuery(query).getSingleResult();
        TestQueryResults.assertTrue((boolean)(obj instanceof RuntimeTest1));
        query = "SELECT DISTINCT r FROM RuntimeTest1 r WHERE r.stringField = 'xxxx'";
        OpenJPAQuery q = em.createQuery(query);
        try {
            Object l = q.getSingleResult();
            TestQueryResults.fail((String)"Expected NoResultException since there is no RuntimeTest1 instance with stringfield=xxxx");
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
        q.closeAll();
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testUniqueThrowsExceptionIfMultipleResults() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        String query = "SELECT DISTINCT r FROM RuntimeTest1 r";
        OpenJPAQuery q = em.createQuery(query);
        try {
            Object l = q.getSingleResult();
            TestQueryResults.fail((String)"Unique query matched multiple results.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        q.closeAll();
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testImpossibleRangeReturnsEmptyList() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        String query = "SELECT r FROM RuntimeTest1 r";
        OpenJPAQuery q = em.createQuery(query);
        q.setFirstResult(2);
        q.setMaxResults(0);
        List results = q.getResultList();
        TestQueryResults.assertEquals((int)0, (int)results.size());
        TestQueryResults.assertFalse((boolean)results.iterator().hasNext());
        q.closeAll();
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testImpossibleUniqueRangeReturnsNull() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        OpenJPAQuery q = em.createQuery("SELECT DISTINCT r FROM RuntimeTest1 r WHERE r.stringField = 'TestQueryResults1'");
        q.setFirstResult(2);
        q.setMaxResults(0);
        TestQueryResults.assertTrue((String)("resultlist is not null its size is: " + q.getResultList().size()), (boolean)q.getResultList().isEmpty());
        q.closeAll();
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testSingleResultUniqueRange() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        OpenJPAQuery q = em.createQuery("SELECT DISTINCT r FROM RuntimeTest1 r WHERE r.stringField = 'TestQueryResults1'");
        q.setFirstResult(1);
        q.setMaxResults(1000000);
        TestQueryResults.assertTrue((String)"resultlist is not empty", (boolean)q.getResultList().isEmpty());
        q.closeAll();
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testMultiResultUniqueRange() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        OpenJPAQuery q = em.createQuery("SELECT DISTINCT r FROM RuntimeTest1 r ORDER BY r.stringField ASC");
        q.setFirstResult(1);
        q.setMaxResults(2);
        TestQueryResults.assertEquals((String)"TestQueryResults2", (String)((RuntimeTest1)q.getResultList().get(0)).getStringField());
        q.closeAll();
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testFullRange() {
        try {
            OpenJPAEntityManager em = this.currentEntityManager();
            this.startTx((EntityManager)em);
            OpenJPAQuery q = em.createQuery("SELECT r FROM RuntimeTest1 ORDER BY r.stringField ASC");
            q.setSubclasses(false);
            q.setFirstResult(0);
            Long l = Long.MAX_VALUE;
            q.setMaxResults(l.intValue());
            List res = q.getResultList();
            TestQueryResults.assertEquals((int)3, (int)res.size());
            for (int i = 0; i < res.size(); ++i) {
                TestQueryResults.assertEquals((String)("TestQueryResults" + (i * 2 + 1)), (String)((RuntimeTest1)res.get(i)).getStringField());
            }
            q.closeAll();
            this.endTx((EntityManager)em);
            this.endEm((EntityManager)em);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testFullRangeSubs() {
        try {
            OpenJPAEntityManager em = this.currentEntityManager();
            this.startTx((EntityManager)em);
            OpenJPAQuery q = em.createQuery("SELECT r FROM RuntimeTest1 ORDER BY r.stringField ASC");
            q.setFirstResult(0);
            Long l = Long.MAX_VALUE;
            q.setMaxResults(l.intValue());
            List res = q.getResultList();
            TestQueryResults.assertEquals((int)6, (int)res.size());
            for (int i = 0; i < res.size(); ++i) {
                TestQueryResults.assertEquals((String)("TestQueryResults" + (i + 1)), (String)((RuntimeTest1)res.get(i)).getStringField());
            }
            q.closeAll();
            this.endTx((EntityManager)em);
            this.endEm((EntityManager)em);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testBeginRange() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        OpenJPAQuery q = em.createQuery("SELECT r FROM RuntimeTest1 r ORDER BY r.stringField ASC");
        q.setSubclasses(false);
        for (int i = 0; i < 4; ++i) {
            q.setFirstResult(i);
            q.setMaxResults(100000);
            List res = q.getResultList();
            TestQueryResults.assertEquals((String)"they are not equal", (int)(3 - i), (int)res.size());
            int idx = 0;
            for (int j = 0; j < res.size(); ++j) {
                TestQueryResults.assertEquals((String)("TestQueryResults" + (j * 2 + 1 + i * 2)), (String)((RuntimeTest1)res.get(j)).getStringField());
            }
            Iterator itr = res.iterator();
            while (itr.hasNext()) {
                TestQueryResults.assertEquals((String)("TestQueryResults" + (idx * 2 + 1 + i * 2)), (String)((RuntimeTest1)itr.next()).getStringField());
                ++idx;
            }
        }
        q.closeAll();
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testBeginRangeSubs() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        OpenJPAQuery q = em.createQuery("SELECT r FROM RuntimeTest1 r ORDER BY r.stringField ASC");
        for (int i = 0; i < 7; ++i) {
            q.setFirstResult(i);
            Long l = Long.MAX_VALUE;
            q.setMaxResults(100000);
            List res = q.getResultList();
            TestQueryResults.assertEquals((int)(6 - i), (int)res.size());
            int idx = 0;
            for (int j = 0; j < res.size(); ++j) {
                TestQueryResults.assertEquals((String)("TestQueryResults" + (j + 1 + i)), (String)((RuntimeTest1)res.get(j)).getStringField());
            }
            Iterator itr = res.iterator();
            while (itr.hasNext()) {
                TestQueryResults.assertEquals((String)("TestQueryResults" + (idx + 1 + i)), (String)((RuntimeTest1)itr.next()).getStringField());
                ++idx;
            }
        }
        q.closeAll();
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testEndRange() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        OpenJPAQuery q = em.createQuery("SELECT r FROM RuntimeTest1 r ORDER BY r.stringField ASC");
        q.setSubclasses(false);
        for (int i = 0; i < 4; ++i) {
            q.setFirstResult(0);
            q.setMaxResults(i);
            List res = q.getResultList();
            TestQueryResults.assertEquals((int)i, (int)res.size());
            int idx = 0;
            for (int j = 0; j < res.size(); ++j) {
                TestQueryResults.assertEquals((String)("TestQueryResults" + (j * 2 + 1)), (String)((RuntimeTest1)res.get(j)).getStringField());
            }
            Iterator itr = res.iterator();
            while (itr.hasNext()) {
                TestQueryResults.assertEquals((String)("TestQueryResults" + (idx * 2 + 1)), (String)((RuntimeTest1)itr.next()).getStringField());
                ++idx;
            }
        }
        q.closeAll();
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testEndRangeSubs() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        OpenJPAQuery q = em.createQuery("SELECT r FROM RuntimeTest1 r ORDER BY r.stringField ASC");
        for (int i = 0; i < 7; ++i) {
            q.setFirstResult(0);
            q.setMaxResults(i);
            List res = q.getResultList();
            TestQueryResults.assertEquals((int)i, (int)res.size());
            int idx = 0;
            for (int j = 0; j < res.size(); ++j) {
                TestQueryResults.assertEquals((String)("TestQueryResults" + (j + 1)), (String)((RuntimeTest1)res.get(j)).getStringField());
            }
            Iterator itr = res.iterator();
            while (itr.hasNext()) {
                TestQueryResults.assertEquals((String)("TestQueryResults" + (idx + 1)), (String)((RuntimeTest1)itr.next()).getStringField());
                ++idx;
            }
        }
        q.closeAll();
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testMidRange() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        OpenJPAQuery q = em.createQuery("SELECT r FROM RuntimeTest1 r ORDER BY r.stringField ASC");
        q.setSubclasses(false);
        q.setFirstResult(1);
        q.setMaxResults(3);
        List res = q.getResultList();
        TestQueryResults.assertEquals((int)2, (int)res.size());
        for (int i = 0; i < res.size(); ++i) {
            TestQueryResults.assertEquals((String)("TestQueryResults" + (i * 2 + 1 + 2)), (String)((RuntimeTest1)res.get(i)).getStringField());
        }
        int idx = 0;
        Iterator itr = res.iterator();
        while (itr.hasNext()) {
            TestQueryResults.assertEquals((String)("TestQueryResults" + (idx * 2 + 1 + 2)), (String)((RuntimeTest1)itr.next()).getStringField());
            ++idx;
        }
        q.closeAll();
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testMidRangeSubs() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        OpenJPAQuery q = em.createQuery("SELECT r FROM RuntimeTest1 r ORDER BY r.stringField ASC");
        q.setFirstResult(1);
        q.setMaxResults(3);
        List res = q.getResultList();
        TestQueryResults.assertEquals((int)3, (int)res.size());
        for (int i = 0; i < res.size(); ++i) {
            TestQueryResults.assertEquals((String)("TestQueryResults" + (i + 1 + 1)), (String)((RuntimeTest1)res.get(i)).getStringField());
        }
        int idx = 0;
        Iterator itr = res.iterator();
        while (itr.hasNext()) {
            TestQueryResults.assertEquals((String)("TestQueryResults" + (idx + 1 + 1)), (String)((RuntimeTest1)itr.next()).getStringField());
            ++idx;
        }
        q.closeAll();
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testPessimisticOrderedRange() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        OpenJPAQuery q = em.createQuery("SELECT r FROM RuntimeTest1 r ORDER BY r.stringField ASC");
        q.setSubclasses(false);
        q.setFirstResult(0);
        q.setMaxResults(2);
        ((JDBCFetchPlan)q.getFetchPlan()).setEagerFetchMode(FetchMode.NONE);
        List res = q.getResultList();
        TestQueryResults.assertEquals((int)2, (int)res.size());
        TestQueryResults.assertEquals((String)"TestQueryResults1", (String)((RuntimeTest1)res.get(0)).getStringField());
        TestQueryResults.assertEquals((String)"TestQueryResults3", (String)((RuntimeTest1)res.get(1)).getStringField());
        q.closeAll();
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }
}

