/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.query;

import java.util.Arrays;
import java.util.List;
import org.apache.openjpa.kernel.Filters;
import org.apache.openjpa.persistence.query.BaseQueryTest;

public class TestQueryExpressionSplit
extends BaseQueryTest {
    public TestQueryExpressionSplit(String test) {
        super(test);
    }

    public void testSimple() {
        this.assertEquals(new String[]{"foo() bar(boo)"}, Filters.splitExpressions((String)"foo() bar(boo)", (char)',', (int)3));
        this.assertEquals(new String[]{"foo() bar(boo)", "biz()", "baz(boo)"}, Filters.splitExpressions((String)"foo() bar(boo), biz(), baz(boo)", (char)',', (int)3));
    }

    public void testCommaInString() {
        this.assertEquals(new String[]{"foo \"bar(),biz)\""}, Filters.splitExpressions((String)"foo \"bar(),biz)\"", (char)',', (int)3));
        this.assertEquals(new String[]{"foo 'bar(),\"biz)'", "boo"}, Filters.splitExpressions((String)"foo 'bar(),\"biz)', boo", (char)',', (int)3));
    }

    public void testCommaInFunction() {
        this.assertEquals(new String[]{"(foo(bar, biz))", "boo(biz, baz('xxx,yyy'))"}, Filters.splitExpressions((String)"(foo(bar, biz)), boo(biz, baz('xxx,yyy'))", (char)',', (int)3));
    }

    public void testEscapedString() {
        this.assertEquals(new String[]{"foo \"bar\\\", biz(\"", "\"baz\\\", boo\""}, Filters.splitExpressions((String)"foo \"bar\\\", biz(\", \"baz\\\", boo\"", (char)',', (int)3));
    }

    private void assertEquals(String[] ans, List test) {
        List<String> l = Arrays.asList(ans);
        TestQueryExpressionSplit.assertEquals((String)(l + " != " + test), l, (Object)test);
    }
}

