/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.query;

import java.util.List;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.jdbc.common.apps.UnidirectionalOneToOneOwned;
import org.apache.openjpa.persistence.jdbc.common.apps.UnidirectionalOneToOneOwner;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestProjectionQueryWithIdenticalResult
extends SingleEMFTestCase {
    private static boolean USE_TXN = true;

    @Override
    public void setUp() {
        this.setUp(CLEAR_TABLES, UnidirectionalOneToOneOwned.class, UnidirectionalOneToOneOwner.class);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        UnidirectionalOneToOneOwner owner = new UnidirectionalOneToOneOwner();
        owner.setMarker("Owner");
        UnidirectionalOneToOneOwned owned = new UnidirectionalOneToOneOwned();
        owned.setMarker("Owned");
        owner.setOwned(owned);
        em.persist((Object)owner);
        em.getTransaction().commit();
        em.close();
    }

    public void testDuplicateResultInProjection1() {
        String jpql = "SELECT p.owned, p FROM UnidirectionalOneToOneOwner p";
        List result = this.executeQuery(jpql, USE_TXN);
        for (Object[] row : result) {
            TestProjectionQueryWithIdenticalResult.assertTrue((boolean)(row[0] instanceof UnidirectionalOneToOneOwned));
            TestProjectionQueryWithIdenticalResult.assertTrue((boolean)(row[1] instanceof UnidirectionalOneToOneOwner));
            TestProjectionQueryWithIdenticalResult.assertTrue((((UnidirectionalOneToOneOwner)row[1]).getOwned() == row[0] ? 1 : 0) != 0);
        }
    }

    public void testDuplicateResultInProjection2() {
        String jpql = "SELECT p, p.owned FROM UnidirectionalOneToOneOwner p";
        List result = this.executeQuery(jpql, USE_TXN);
        for (Object[] row : result) {
            TestProjectionQueryWithIdenticalResult.assertTrue((boolean)(row[1] instanceof UnidirectionalOneToOneOwned));
            TestProjectionQueryWithIdenticalResult.assertTrue((boolean)(row[0] instanceof UnidirectionalOneToOneOwner));
            TestProjectionQueryWithIdenticalResult.assertTrue((((UnidirectionalOneToOneOwner)row[0]).getOwned() == row[1] ? 1 : 0) != 0);
        }
    }

    public void testDuplicateResultInProjection3() {
        String jpql = "SELECT p, q FROM UnidirectionalOneToOneOwner p, UnidirectionalOneToOneOwned q WHERE p.owned = q";
        List result = this.executeQuery(jpql, USE_TXN);
        for (Object[] row : result) {
            TestProjectionQueryWithIdenticalResult.assertTrue((boolean)(row[0] instanceof UnidirectionalOneToOneOwner));
            TestProjectionQueryWithIdenticalResult.assertTrue((boolean)(row[1] instanceof UnidirectionalOneToOneOwned));
            TestProjectionQueryWithIdenticalResult.assertTrue((((UnidirectionalOneToOneOwner)row[0]).getOwned() == row[1] ? 1 : 0) != 0);
        }
    }

    public void testDuplicateResultInProjection4() {
        String jpql = "SELECT q, p FROM UnidirectionalOneToOneOwner p, UnidirectionalOneToOneOwned q WHERE p.owned = q";
        List result = this.executeQuery(jpql, USE_TXN);
        for (Object[] row : result) {
            TestProjectionQueryWithIdenticalResult.assertTrue((boolean)(row[0] instanceof UnidirectionalOneToOneOwned));
            TestProjectionQueryWithIdenticalResult.assertTrue((boolean)(row[1] instanceof UnidirectionalOneToOneOwner));
            TestProjectionQueryWithIdenticalResult.assertTrue((((UnidirectionalOneToOneOwner)row[1]).getOwned() == row[0] ? 1 : 0) != 0);
        }
    }

    private List executeQuery(String jpql, boolean useTxn) {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        List result = em.createQuery(jpql).getResultList();
        em.getTransaction().rollback();
        return result;
    }
}

