/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.query;

import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.apache.openjpa.meta.QueryMetaData;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.query.BaseQueryTest;
import org.apache.openjpa.persistence.query.common.apps.EntityInterface;
import org.apache.openjpa.persistence.query.common.apps.QueryTest1;

public class TestNamedQueries
extends BaseQueryTest {
    public TestNamedQueries(String test) {
        super(test);
    }

    public void setUp() {
        this.deleteAll(QueryTest1.class);
        OpenJPAEntityManager pm = this.getEM();
        this.startTx((EntityManager)pm);
        QueryTest1 pc = null;
        for (int i = 0; i < 10; ++i) {
            pc = new QueryTest1();
            if (i < 5) {
                pc.setNum(4L);
            } else {
                pc.setNum(i + 10);
            }
            pm.persist((Object)pc);
        }
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }

    public void testNamedClassQuery() {
        OpenJPAEntityManager pm = this.getEM();
        OpenJPAQuery query = pm.createQuery("SELECT o FROM QueryTest1 o");
        query.setResultClass(QueryTest1.class);
        TestNamedQueries.assertEquals(QueryTest1.class, (Object)query.getResultClass());
        TestNamedQueries.assertEquals((String)"SELECT o FROM QueryTest1 o", (String)query.getQueryString());
        TestNamedQueries.assertEquals(QueryTest1.class, (Object)query.getResultClass());
        QueryMetaData meta = ((OpenJPAEntityManagerSPI)pm).getConfiguration().getMetaDataRepositoryInstance().getQueryMetaData(null, "named", pm.getClassLoader(), true);
        TestNamedQueries.assertNotNull((Object)meta);
        TestNamedQueries.assertEquals((String)"SELECT o FROM QueryTest1 o", (String)meta.getQueryString());
        TestNamedQueries.assertEquals(null, (Object)meta.getResultType());
        this.endEm((EntityManager)pm);
    }

    public void testNamespace() {
        OpenJPAEntityManager pm = this.getEM();
        OpenJPAQuery query = pm.createNamedQuery("named");
        TestNamedQueries.assertEquals((String)"SELECT o FROM QueryTest1 o", (String)query.getQueryString());
        query.closeAll();
        this.endEm((EntityManager)pm);
    }

    public void testSystemJDOQL() {
        OpenJPAEntityManager pm = this.getEM();
        OpenJPAQuery query = pm.createNamedQuery("named");
        TestNamedQueries.assertEquals((String)"SELECT o FROM QueryTest1 o", (String)query.getQueryString());
        TestNamedQueries.assertEquals(QueryTest1.class, (Object)query.getResultClass());
        TestNamedQueries.assertEquals((int)10, (int)query.getResultList().size());
        query.closeAll();
        this.endEm((EntityManager)pm);
    }

    public void testInterfaceResultClass() {
        OpenJPAEntityManager pm = this.getEM();
        TypedQuery query = pm.createNamedQuery("named", EntityInterface.class);
        TestNamedQueries.assertEquals((int)10, (int)query.getResultList().size());
    }
}

