/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.query;

import java.util.Collection;
import java.util.List;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.query.SimpleEntity;
import org.apache.openjpa.persistence.test.SingleEMTestCase;

public class TestLocate
extends SingleEMTestCase {
    @Override
    public void setUp() {
        super.setUp(SimpleEntity.class, CLEAR_TABLES);
        OpenJPAEntityManagerSPI em1 = this.emf.createEntityManager();
        em1.getTransaction().begin();
        em1.persist((Object)new SimpleEntity("foo", "bar"));
        em1.getTransaction().commit();
        em1.close();
    }

    public void testLocate() {
        TestLocate.assertEquals((Object)1L, (Object)this.em.createQuery("select count(o) from simple o where LOCATE('bar', o.value) = 1").getSingleResult());
        TestLocate.assertEquals((Object)1L, (Object)this.em.createQuery("select count(o) from simple o where LOCATE('ar', o.value) = 2").getSingleResult());
        TestLocate.assertEquals((Object)1L, (Object)this.em.createQuery("select count(o) from simple o where LOCATE('zzz', o.value) = 0").getSingleResult());
        TestLocate.assertEquals((Object)1L, (Object)this.em.createQuery("select count(o) from simple o where LOCATE('ar', o.value, 1) = 2").getSingleResult());
        TestLocate.assertEquals((Object)1L, (Object)this.em.createQuery("select count(o) from simple o where LOCATE('ar', o.value, 2) = 2").getSingleResult());
    }

    public void testLocateInMemory() {
        List allEntities = this.em.createQuery("select o from simple o", SimpleEntity.class).getResultList();
        Object inMemoryResult = this.em.createQuery("select LOCATE('bar', o.value) from simple o").setCandidateCollection((Collection)allEntities).getSingleResult();
        TestLocate.assertEquals((Object)1, (Object)inMemoryResult);
        inMemoryResult = this.em.createQuery("select LOCATE('ar', o.value, 2) from simple o").setCandidateCollection((Collection)allEntities).getSingleResult();
        TestLocate.assertEquals((Object)2, (Object)inMemoryResult);
    }
}

