/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.query;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.query.BaseQueryTest;
import org.apache.openjpa.persistence.query.common.apps.RuntimeTest1;
import org.apache.openjpa.persistence.query.common.apps.RuntimeTest3;

public class TestJPAQuerySubclassFunc
extends BaseQueryTest {
    public TestJPAQuerySubclassFunc(String name) {
        super(name);
    }

    public void setUp() {
        this.deleteAll(RuntimeTest1.class);
        OpenJPAEntityManager pm = this.getEM();
        this.startTx((EntityManager)pm);
        pm.persist((Object)new RuntimeTest1("TestQueryResults1", 10));
        pm.persist((Object)new RuntimeTest1("TestQueryResults3", 10));
        pm.persist((Object)new RuntimeTest1("TestQueryResults5", 10));
        pm.persist((Object)new RuntimeTest3("TestQueryResults2", 10));
        pm.persist((Object)new RuntimeTest3("TestQueryResults4", 10));
        pm.persist((Object)new RuntimeTest3("TestQueryResults6", 10));
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }

    public void testSubClassIsTrueFunction() {
        OpenJPAEntityManager pm = this.getEM();
        this.startTx((EntityManager)pm);
        OpenJPAQuery query = pm.createQuery("SELECT r.stringField FROM RuntimeTest1 r");
        query.setSubclasses(true);
        List list = query.getResultList();
        TestJPAQuerySubclassFunc.assertEquals((String)"I expect size to be 6 since subclasses are included", (int)6, (int)list.size());
        TestJPAQuerySubclassFunc.assertTrue((boolean)list.contains("TestQueryResults1"));
        TestJPAQuerySubclassFunc.assertTrue((boolean)list.contains("TestQueryResults2"));
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }

    public void testSubClassIsFalseFunction() {
        OpenJPAEntityManager pm = this.getEM();
        this.startTx((EntityManager)pm);
        OpenJPAQuery query = pm.createQuery("SELECT r.stringField FROM RuntimeTest1 r");
        query.setSubclasses(false);
        List list = query.getResultList();
        TestJPAQuerySubclassFunc.assertEquals((String)"I expect size to be 3 since subclasses are not included", (int)3, (int)list.size());
        TestJPAQuerySubclassFunc.assertTrue((boolean)list.contains("TestQueryResults1"));
        TestJPAQuerySubclassFunc.assertTrue((boolean)list.contains("TestQueryResults3"));
        TestJPAQuerySubclassFunc.assertTrue((boolean)list.contains("TestQueryResults5"));
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }
}

