/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.query;

import java.util.Date;
import java.util.List;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.H2Dictionary;
import org.apache.openjpa.jdbc.sql.HSQLDictionary;
import org.apache.openjpa.jdbc.sql.PostgresDictionary;
import org.apache.openjpa.jdbc.sql.SQLServerDictionary;
import org.apache.openjpa.jdbc.sql.SybaseDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.query.Employee;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;
import org.junit.Assert;

public class TestJDBCEscapeDate
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        this.setUp(Employee.class, DROP_TABLES);
    }

    public void populate() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        Employee e = new Employee();
        e.setEmpId(1L);
        e.setName("name1");
        e.setHireDate(new Date());
        e.setHireTime(new Date());
        e.setHireTimestamp(new Date());
        em.persist((Object)e);
        tran.begin();
        tran.commit();
        em.close();
    }

    public void testJDBCEscape() {
        Query q;
        this.populate();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        DBDictionary dict = ((JDBCConfiguration)this.emf.getConfiguration()).getDBDictionaryInstance();
        String[] jpql = dict instanceof SQLServerDictionary || dict instanceof HSQLDictionary ? new String[]{"select a from Employee a where a.hireDate >= {d '2009-08-25'}", "select a from Employee a where a.hireDate >= {d '2009-08-05'}", "select a from Employee a where a.hireTimestamp >= {ts '2009-08-25 00:00:00'}", "select a from Employee a where a.hireTimestamp >= {ts '2009-08-25 00:00:00.'}", "select a from Employee a where a.hireTimestamp >= {ts '2009-08-25 00:00:00.1'}", "select a from Employee a where a.hireTimestamp >= {ts '2009-08-25 00:00:00.12'}", "select a from Employee a where a.hireTimestamp >= {ts '2009-08-25 00:00:00.123'}", "select {t '00:00:00'}, a.empId from Employee a"} : (dict instanceof SybaseDictionary ? new String[]{"select a from Employee a where a.hireDate >= {d '2009-08-25'}", "select a from Employee a where a.hireDate >= {d '2009-8-5'}", "select a from Employee a where a.hireTime >= {t '00:00:00'}", "select a from Employee a where a.hireTimestamp >= {ts '2009-08-25 00:00:00'}", "select a from Employee a where a.hireTimestamp >= {ts '2009-08-25 00:00:00.0'}", "select a from Employee a where a.hireTimestamp >= {ts '2009-08-25 00:00:00.1'}", "select a from Employee a where a.hireTimestamp >= {ts '2009-08-25 00:00:00.12'}", "select a from Employee a where a.hireTimestamp >= {ts '2009-08-25 00:00:00.123'}", "select a from Employee a where a.hireTimestamp >= {ts '2009-08-25 00:00:00.1234'}", "select a from Employee a where a.hireTimestamp >= {ts '2009-08-25 00:00:00.12345'}", "select a from Employee a where a.hireTimestamp >= {ts '2009-08-25 00:00:00.123456'}", "select {t '00:00:00'}, a.empId from Employee a"} : (dict instanceof PostgresDictionary || dict instanceof H2Dictionary ? new String[]{"select a from Employee a where a.hireDate >= {d '2009-08-25'}", "select a from Employee a where a.hireDate >= {d '2009-8-5'}", "select a from Employee a where a.hireTime >= {t '00:00:00'}", "select a from Employee a where a.hireTimestamp >= {ts '2009-08-25 00:00:00'}", "select a from Employee a where a.hireTimestamp >= {ts '2009-08-25 00:00:00.1'}", "select a from Employee a where a.hireTimestamp >= {ts '2009-08-25 00:00:00.12'}", "select a from Employee a where a.hireTimestamp >= {ts '2009-08-25 00:00:00.123'}", "select a from Employee a where a.hireTimestamp >= {ts '2009-08-25 00:00:00.1234'}", "select a from Employee a where a.hireTimestamp >= {ts '2009-08-25 00:00:00.12345'}", "select a from Employee a where a.hireTimestamp >= {ts '2009-08-25 00:00:00.123456'}", "select {t '00:00:00'}, a.empId from Employee a"} : new String[]{"select a from Employee a where a.hireDate >= {d '2009-08-25'}", "select a from Employee a where a.hireDate >= {d '2009-8-5'}", "select a from Employee a where a.hireTime >= {t '00:00:00'}", "select a from Employee a where a.hireTimestamp >= {ts '2009-08-25 00:00:00'}", "select a from Employee a where a.hireTimestamp >= {ts '2009-08-25 00:00:00.'}", "select a from Employee a where a.hireTimestamp >= {ts '2009-08-25 00:00:00.1'}", "select a from Employee a where a.hireTimestamp >= {ts '2009-08-25 00:00:00.12'}", "select a from Employee a where a.hireTimestamp >= {ts '2009-08-25 00:00:00.123'}", "select a from Employee a where a.hireTimestamp >= {ts '2009-08-25 00:00:00.1234'}", "select a from Employee a where a.hireTimestamp >= {ts '2009-08-25 00:00:00.12345'}", "select a from Employee a where a.hireTimestamp >= {ts '2009-08-25 00:00:00.123456'}", "select {t '00:00:00'}, a.empId from Employee a"}));
        for (int i = 0; i < jpql.length; ++i) {
            Query q2 = em.createQuery(jpql[i]);
            List results = q2.getResultList();
            Assert.assertEquals((String)("For jpql[" + i + "]"), (long)1L, (long)results.size());
        }
        String[] havingJpql = new String[]{"select a from Employee a group by a.hireTime having a.hireTime >= {t '00:00:00'}", "select a from Employee a group by a.hireDate having a.hireDate >= {d '2009-08-25'}", "select a from Employee a group by a.hireTimestamp having a.hireTimestamp >= {d '2009-08-25'}"};
        for (int j = 0; j < havingJpql.length; ++j) {
            q = em.createQuery(havingJpql[j]);
            List results = q.getResultList();
            Assert.assertEquals((String)("For havingJpql[" + j + "]"), (long)1L, (long)results.size());
        }
        em.getTransaction().begin();
        String update = dict instanceof SQLServerDictionary || dict instanceof HSQLDictionary ? "update Employee a set a.hireTimestamp = {ts '2009-08-25 00:00:00.123'} where a.empId = 1" : "update Employee a set a.hireTimestamp = {ts '2009-08-25 00:00:00.123456'} where a.empId = 1";
        q = em.createQuery(update);
        int updateCnt = q.executeUpdate();
        em.getTransaction().commit();
        Assert.assertEquals((long)1L, (long)updateCnt);
        em.close();
    }

    public void testMultipleQueryExecutionWithDateLiteral() {
        this.populate();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Query q = em.createQuery("SELECT e FROM Employee e WHERE e.hireTimestamp > {ts '2001-01-01 00:00:00'}");
        Assert.assertEquals((String)"First assertion", (long)1L, (long)q.getResultList().size());
        Assert.assertEquals((String)"Second assertion", (long)1L, (long)q.getResultList().size());
        Assert.assertEquals((String)"Third assertion", (long)1L, (long)q.getResultList().size());
        Assert.assertEquals((String)"Fourth assertion", (long)1L, (long)q.getResultList().size());
    }
}

