/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.query;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.query.BaseQueryTest;
import org.apache.openjpa.persistence.query.Order;
import org.apache.openjpa.persistence.query.OrderItem;
import org.apache.openjpa.persistence.query.common.apps.Entity1;
import org.apache.openjpa.persistence.query.common.apps.Entity2;

public class TestEJBQueryInterface
extends BaseQueryTest {
    public TestEJBQueryInterface(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp(Entity1.class, Entity2.class, Order.class, OrderItem.class);
        int instNum = 10;
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        this.deleteAll(Entity1.class, (EntityManager)em);
        this.deleteAll(Entity2.class, (EntityManager)em);
        this.endTx((EntityManager)em);
        this.startTx((EntityManager)em);
        for (int i = 0; i < instNum; ++i) {
            Entity1 ent = new Entity1(i, "string" + i, i + 2);
            Entity2 ent2 = new Entity2(i * 2, "ent2" + i, i);
            ent.setEntity2Field(ent2);
            em.persist((Object)ent);
        }
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testResultList() {
        OpenJPAEntityManager em = this.currentEntityManager();
        List list = em.createQuery("Select object(o) from Entity1 o").getResultList();
        TestEJBQueryInterface.assertEquals((int)10, (int)list.size());
        this.endEm((EntityManager)em);
    }

    public void testGetSingleList() {
        OpenJPAEntityManager em = this.currentEntityManager();
        Entity1 ret = (Entity1)em.createQuery("SELECT o FROM Entity1 o WHERE o.pk = 2").getSingleResult();
        TestEJBQueryInterface.assertNotNull((Object)ret);
        TestEJBQueryInterface.assertEquals((String)"string2", (String)ret.getStringField());
        TestEJBQueryInterface.assertEquals((int)4, (int)ret.getIntField());
        this.endEm((EntityManager)em);
    }

    public void testExecuteUpdate() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        int ret = em.createQuery("DELETE FROM Entity1 o WHERE o.pk = 2").executeUpdate();
        TestEJBQueryInterface.assertEquals((int)ret, (int)1);
        int ret2 = em.createQuery("DELETE FROM Entity1 o WHERE o.pk = 22").executeUpdate();
        TestEJBQueryInterface.assertEquals((int)ret2, (int)0);
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testSetMaxResults() {
        OpenJPAEntityManager em = this.currentEntityManager();
        List l = em.createQuery("Select object(o) from Entity1 o").setMaxResults(5).getResultList();
        TestEJBQueryInterface.assertNotNull((Object)l);
        TestEJBQueryInterface.assertEquals((int)5, (int)l.size());
        this.endEm((EntityManager)em);
    }

    public void testSetFirstResults() {
        OpenJPAEntityManager em = this.currentEntityManager();
        List l = em.createQuery("Select object(o) from Entity1 o order by o.pk").setFirstResult(3).getResultList();
        Entity1 ent = (Entity1)l.get(0);
        TestEJBQueryInterface.assertNotNull((Object)ent);
        TestEJBQueryInterface.assertEquals((String)"string3", (String)ent.getStringField());
        TestEJBQueryInterface.assertEquals((int)5, (int)ent.getIntField());
        this.endEm((EntityManager)em);
    }

    public void testSetParameter1() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        List ret = em.createQuery("SELECT o FROM Entity1 o WHERE o.stringField = :fld").setParameter("fld", (Object)"string1").getResultList();
        TestEJBQueryInterface.assertNotNull((Object)ret);
        TestEJBQueryInterface.assertEquals((int)1, (int)ret.size());
        ret = em.createNamedQuery("setParam1").setParameter("fld", (Object)"string1").getResultList();
        TestEJBQueryInterface.assertNotNull((Object)ret);
        TestEJBQueryInterface.assertEquals((int)1, (int)ret.size());
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testOrderBy() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        String jpql = "SELECT o.oid FROM OrderItem l LEFT JOIN l.order o GROUP BY o.oid ORDER BY o.oid ";
        try {
            List list = em.createQuery(jpql).getResultList();
        }
        catch (Exception e) {
            e.printStackTrace();
            TestEJBQueryInterface.fail((String)e.getMessage());
        }
    }
}

