/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.query;

import java.util.List;
import junit.textui.TestRunner;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.query.SimpleEntity;
import org.apache.openjpa.persistence.query.SimpleEntity2;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestDupNamedQuery
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        this.setUp(SimpleEntity.class, SimpleEntity2.class, CLEAR_TABLES);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)new SimpleEntity("Name One", "Value One"));
        em.persist((Object)new SimpleEntity("Name Two", "Value Two"));
        em.persist((Object)new SimpleEntity2("Name2 One", "Value2 One"));
        em.persist((Object)new SimpleEntity2("Name2 Two", "Value2 Two"));
        em.getTransaction().commit();
        em.close();
    }

    public void testSimpleQuery() {
        this.simpleQuery(false, "FindOne", "FindAll", "Name One", "Value One", "Name Two", "Value Two");
        this.simpleQuery(true, "Find2One", "Find2All", "Name2 One", "Value2 One", "Name2 Two", "Value2 Two");
        this.simpleQuery(false, "FindXTwo", null, "Name Two", "Value Two", null, null);
    }

    private void simpleQuery(boolean simple2, String findOneQName, String findAllQName, String nameOne, String ValueOne, String nameTwo, String ValueTwo) {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        List list = em.createNamedQuery(findOneQName).setParameter(1, (Object)nameOne).getResultList();
        TestDupNamedQuery.assertNotNull((Object)list);
        TestDupNamedQuery.assertEquals((int)list.size(), (int)1);
        Object o = list.get(0);
        TestDupNamedQuery.assertTrue((boolean)(simple2 ? o instanceof SimpleEntity2 : o instanceof SimpleEntity));
        TestDupNamedQuery.assertEquals((String)(simple2 ? ((SimpleEntity2)o).getValue() : ((SimpleEntity)o).getValue()), (String)ValueOne);
        if (findAllQName != null) {
            list = em.createNamedQuery(findAllQName).getResultList();
            TestDupNamedQuery.assertNotNull((Object)list);
            TestDupNamedQuery.assertEquals((int)list.size(), (int)2);
            for (Object value : list) {
                o = value;
                TestDupNamedQuery.assertTrue((boolean)(simple2 ? o instanceof SimpleEntity2 : o instanceof SimpleEntity));
                String n = null;
                String v = null;
                if (simple2) {
                    n = ((SimpleEntity2)o).getName();
                    v = ((SimpleEntity2)o).getValue();
                } else {
                    n = ((SimpleEntity)o).getName();
                    v = ((SimpleEntity)o).getValue();
                }
                if (n.equals(nameOne)) {
                    TestDupNamedQuery.assertTrue((boolean)v.equals(ValueOne));
                    continue;
                }
                if (n.equals(nameTwo)) {
                    TestDupNamedQuery.assertTrue((boolean)v.equals(ValueTwo));
                    continue;
                }
                TestDupNamedQuery.assertTrue((boolean)false);
            }
        }
        em.close();
    }

    public static void main(String[] args) {
        TestRunner.run(TestDupNamedQuery.class);
    }
}

