/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.query;

import javax.persistence.Query;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.simple.AllFieldTypes;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestDoubleQuotedStringLiteralInJPQL
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        this.setUp(AllFieldTypes.class, CLEAR_TABLES);
        AllFieldTypes aft = new AllFieldTypes();
        aft.setStringField("foo'bar");
        AllFieldTypes aft2 = new AllFieldTypes();
        aft2.setStringField("foo-bar");
        AllFieldTypes aft3 = new AllFieldTypes();
        aft3.setStringField("foo\"bar");
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)aft);
        em.persist((Object)aft2);
        em.persist((Object)aft3);
        em.getTransaction().commit();
        em.close();
    }

    public void testdDoubleQuotedStringLiteralInJPQL() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Query q = em.createQuery("select count(o) from AllFieldTypes o where o.stringField = \"foo'bar\"");
        TestDoubleQuotedStringLiteralInJPQL.assertEquals((long)1L, (long)((Number)q.getSingleResult()).longValue());
        Query q2 = em.createQuery("select count(o) from AllFieldTypes o where o.stringField = \"foo-bar\"");
        TestDoubleQuotedStringLiteralInJPQL.assertEquals((long)1L, (long)((Number)q2.getSingleResult()).longValue());
        Query q3 = em.createQuery("select count(o) from AllFieldTypes o where o.stringField = 'foo\"bar'");
        TestDoubleQuotedStringLiteralInJPQL.assertEquals((long)1L, (long)((Number)q3.getSingleResult()).longValue());
        Query q4 = em.createQuery("select count(o) from AllFieldTypes o where o.stringField like \"%bar\"");
        TestDoubleQuotedStringLiteralInJPQL.assertEquals((long)3L, (long)((Number)q4.getSingleResult()).longValue());
    }
}

