/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.query;

import java.util.List;
import org.apache.openjpa.persistence.models.company.fetchlazy.Address;
import org.apache.openjpa.persistence.models.company.fetchlazy.Company;
import org.apache.openjpa.persistence.models.company.fetchlazy.Customer;
import org.apache.openjpa.persistence.models.company.fetchlazy.Employee;
import org.apache.openjpa.persistence.models.company.fetchlazy.FullTimeEmployee;
import org.apache.openjpa.persistence.models.company.fetchlazy.LineItem;
import org.apache.openjpa.persistence.models.company.fetchlazy.PartTimeEmployee;
import org.apache.openjpa.persistence.models.company.fetchlazy.Person;
import org.apache.openjpa.persistence.models.company.fetchlazy.Product;
import org.apache.openjpa.persistence.models.company.fetchlazy.ProductOrder;
import org.apache.openjpa.persistence.test.SingleEMTestCase;

public class TestDistinctQueries
extends SingleEMTestCase {
    @Override
    public void setUp() {
        this.setUp(Address.class, Company.class, Customer.class, Employee.class, FullTimeEmployee.class, LineItem.class, PartTimeEmployee.class, Person.class, Product.class, ProductOrder.class, CLEAR_TABLES);
        ProductOrder order = new ProductOrder();
        LineItem item0 = new LineItem();
        LineItem item1 = new LineItem();
        LineItem item2 = new LineItem();
        order.getItems().add(item0);
        order.getItems().add(item1);
        order.getItems().add(item2);
        this.em.getTransaction().begin();
        this.em.persist((Object)order);
        this.em.persist((Object)item0);
        this.em.persist((Object)item1);
        this.em.persist((Object)item2);
        this.em.getTransaction().commit();
    }

    public void testDuplicateResultsInNonDistinctJoinFetchQuery() {
        List l = this.em.createQuery("select o from LAZ_ProductOrder o left join fetch o.items").getResultList();
        TestDistinctQueries.assertEquals((int)3, (int)l.size());
    }

    public void testDuplicateResultsInNonDistinctJoinQuery() {
        List l = this.em.createQuery("select o from LAZ_ProductOrder o left join o.items item").getResultList();
        TestDistinctQueries.assertEquals((int)3, (int)l.size());
    }

    public void testNoDuplicateResultsInDistinctQuery() {
        List l = this.em.createQuery("select distinct o from LAZ_ProductOrder o left join o.items item").getResultList();
        TestDistinctQueries.assertEquals((int)1, (int)l.size());
    }

    public void testDuplicateResultsInNonDistinctConstructorJoinQuery() {
        List l = this.em.createQuery("select new org.apache.openjpa.persistence.query.TestDistinctQueries$Holder(o.id) from LAZ_ProductOrder o left join o.items item").getResultList();
        TestDistinctQueries.assertEquals((int)3, (int)l.size());
    }

    public void testNoDuplicateResultsInDistinctConstructorQuery() throws NoSuchMethodException {
        List l = this.em.createQuery("select distinct new org.apache.openjpa.persistence.query.TestDistinctQueries$Holder(o.id) from LAZ_ProductOrder o left join o.items item").getResultList();
        TestDistinctQueries.assertEquals((int)1, (int)l.size());
    }

    public static class Holder {
        public Holder(long id) {
        }
    }
}

