/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.query;

import java.util.Arrays;
import java.util.List;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.Query;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.persistence.query.BaseQueryTest;
import org.apache.openjpa.persistence.query.common.apps.RuntimeTest1;
import org.apache.openjpa.persistence.query.common.apps.RuntimeTest4;
import org.apache.openjpa.persistence.query.common.apps.RuntimeTest5;

public class TestAccessPathsOfSubqueries
extends BaseQueryTest {
    public TestAccessPathsOfSubqueries(String name) {
        super(name);
    }

    public void testSimpleSubqueryAccessPath() {
        Broker broker = this.getBrokerFactory().newBroker();
        Query q = broker.newQuery("javax.persistence.JPQL", (Object)"SELECT o FROM RuntimeTest1 o WHERE EXISTS (SELECT rt5.name FROM RuntimeTest5 rt5 WHERE rt5.name IS NOT NULL)");
        ClassMetaData[] metas = q.getAccessPathMetaDatas();
        List<ClassMetaData> c = Arrays.asList(metas);
        ClassMetaData rt1 = broker.getConfiguration().getMetaDataRepositoryInstance().getMetaData(RuntimeTest1.class, broker.getClassLoader(), true);
        ClassMetaData rt5 = broker.getConfiguration().getMetaDataRepositoryInstance().getMetaData(RuntimeTest5.class, broker.getClassLoader(), true);
        TestAccessPathsOfSubqueries.assertTrue((boolean)c.contains(rt1));
        TestAccessPathsOfSubqueries.assertTrue((boolean)c.contains(rt5));
        TestAccessPathsOfSubqueries.assertEquals((int)2, (int)c.size());
    }

    public void testRelationTraversalSubqueryAccessPath() {
        Broker broker = this.getBrokerFactory().newBroker();
        Query q = broker.newQuery("javax.persistence.JPQL", (Object)"SELECT o FROM RuntimeTest1 o WHERE EXISTS (SELECT rt5.runtimeTest4.name FROM RuntimeTest5 rt5 WHERE rt5.name IS NOT NULL)");
        ClassMetaData[] metas = q.getAccessPathMetaDatas();
        List<ClassMetaData> c = Arrays.asList(metas);
        ClassMetaData rt1 = broker.getConfiguration().getMetaDataRepositoryInstance().getMetaData(RuntimeTest1.class, broker.getClassLoader(), true);
        ClassMetaData rt4 = broker.getConfiguration().getMetaDataRepositoryInstance().getMetaData(RuntimeTest4.class, broker.getClassLoader(), true);
        ClassMetaData rt5 = broker.getConfiguration().getMetaDataRepositoryInstance().getMetaData(RuntimeTest5.class, broker.getClassLoader(), true);
        TestAccessPathsOfSubqueries.assertTrue((boolean)c.contains(rt1));
        TestAccessPathsOfSubqueries.assertTrue((boolean)c.contains(rt4));
        TestAccessPathsOfSubqueries.assertTrue((boolean)c.contains(rt5));
        TestAccessPathsOfSubqueries.assertEquals((int)3, (int)c.size());
    }
}

