/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.query;

import java.util.ArrayList;
import java.util.List;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.query.Hardware;
import org.apache.openjpa.persistence.query.Person;
import org.apache.openjpa.persistence.test.SingleEMTestCase;

public class Test1x1OrderByResultCollection
extends SingleEMTestCase {
    @Override
    public void setUp() {
        super.setUp(Hardware.class, Person.class, CLEAR_TABLES, "openjpa.jdbc.DBDictionary", "fullResultCollectionInOrderByRelation=true");
        this.populateData();
    }

    public void testCollectionSizeNoOrderBy() {
        OpenJPAQuery query = this.em.createQuery("select h from Hardware h where h.empNo = :empNo");
        query.setParameter("empNo", (Object)"Emp1");
        List results = query.getResultList();
        this.printResults("UnSorted", results);
        Test1x1OrderByResultCollection.assertEquals((int)4, (int)results.size());
    }

    public void testCollectionSizeOrderBy() {
        OpenJPAQuery query = this.em.createQuery("select h from Hardware h where h.empNo = :empNo order by h.techOwner.name");
        query.setParameter("empNo", (Object)"Emp1");
        List results = query.getResultList();
        this.printResults("Sorted asc", results);
        this.assertOrderBy(results, true);
    }

    public void testCollectionSizeOrderByDesc() {
        OpenJPAQuery query = this.em.createQuery("select h from Hardware h where h.empNo = :empNo order by h.techOwner.name desc");
        query.setParameter("empNo", (Object)"Emp1");
        List results = query.getResultList();
        this.printResults("Sorted desc", results);
        this.assertOrderBy(results, false);
    }

    private void assertOrderBy(List<Hardware> results, boolean asc) {
        Test1x1OrderByResultCollection.assertEquals((int)4, (int)results.size());
        ArrayList<Hardware> nonNullResults = new ArrayList<Hardware>(results.size());
        for (Hardware hw : results) {
            if (hw.getTechOwner() == null || hw.getTechOwner().getName() == null) continue;
            nonNullResults.add(hw);
        }
        String curTechOwner = null;
        String lastTechOwner = null;
        for (Hardware hw : nonNullResults) {
            if (lastTechOwner == null) {
                lastTechOwner = hw.getTechOwner().getName();
                continue;
            }
            curTechOwner = hw.getTechOwner().getName();
            if (asc) {
                Test1x1OrderByResultCollection.assertTrue((lastTechOwner.compareTo(curTechOwner) <= 0 ? 1 : 0) != 0);
            } else {
                Test1x1OrderByResultCollection.assertTrue((lastTechOwner.compareTo(curTechOwner) >= 0 ? 1 : 0) != 0);
            }
            lastTechOwner = curTechOwner;
        }
    }

    private void populateData() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Person p1 = new Person("p1", "Person One");
        this.persist(p1);
        Person p2 = new Person("p2", "Person Two");
        this.persist(p2);
        Person p3 = new Person("p3", "Person Three");
        this.persist(p3);
        Person p4 = new Person("p4", "Person Four");
        this.persist(p4);
        Person pn = new Person("pn", null);
        this.persist(pn);
        Hardware hwe1p2 = new Hardware(1, "Emp1");
        hwe1p2.setTechOwner(p2);
        this.persist(hwe1p2);
        Hardware hwe1p1 = new Hardware(2, "Emp1");
        hwe1p1.setTechOwner(p1);
        this.persist(hwe1p1);
        Hardware hwen = new Hardware(3, null);
        hwen.setTechOwner(p4);
        this.persist(hwen);
        Hardware hwe1pn = new Hardware(4, "Emp1");
        hwe1pn.setTechOwner(pn);
        this.persist(hwe1pn);
        Hardware hwe2p3 = new Hardware(5, "Emp2");
        hwe2p3.setTechOwner(p3);
        this.persist(hwe2p3);
        Hardware hwe1np = new Hardware(6, "Emp1");
        this.persist(hwe1np);
        em.getTransaction().commit();
        em.close();
    }

    public void printResults(String heading, List<Hardware> results) {
        System.out.println(heading + ": collection size= " + (results == null ? "0" : Integer.valueOf(results.size())));
        if (results != null) {
            for (Hardware hw : results) {
                Person to = hw.getTechOwner();
                String n = to == null ? "technical-owner-is-null" : to.getName();
                System.out.println("    id=" + hw.getId() + " TechnicalOwner=" + n);
            }
        }
    }
}

