/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.query;

import java.util.Iterator;
import java.util.List;
import javax.persistence.Query;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.DerbyDictionary;
import org.apache.openjpa.jdbc.sql.SolidDBDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.simple.AllFieldTypes;
import org.apache.openjpa.persistence.test.SingleEMTestCase;

public abstract class GroupingTestCase
extends SingleEMTestCase {
    protected abstract void prepareQuery(Query var1);

    @Override
    public void setUp() {
        super.setUp(AllFieldTypes.class, CLEAR_TABLES, "openjpa.Compatibility", "JPQL=warn");
        AllFieldTypes pc1 = new AllFieldTypes();
        AllFieldTypes pc2 = new AllFieldTypes();
        AllFieldTypes pc3 = new AllFieldTypes();
        AllFieldTypes pc4 = new AllFieldTypes();
        pc1.setIntField(1);
        pc1.setShortField((short)-1);
        pc2.setIntField(1);
        pc2.setShortField((short)-1);
        pc3.setIntField(2);
        pc3.setShortField((short)-2);
        pc4.setIntField(2);
        pc4.setShortField((short)-2);
        pc1.setStringField("abc");
        pc2.setStringField("acd");
        pc3.setStringField("def");
        pc4.setStringField("efg");
        pc2.setByteField((byte)1);
        pc3.setByteField((byte)1);
        pc1.setByteField((byte)0);
        pc4.setByteField((byte)2);
        pc1.setLongField(1L);
        pc2.setLongField(2L);
        pc3.setLongField(3L);
        pc4.setLongField(4L);
        pc1.setSelfOneOne(pc4);
        pc2.setSelfOneOne(pc3);
        pc3.setSelfOneOne(pc2);
        pc4.setSelfOneOne(pc1);
        if (this.getName().startsWith("testVariable")) {
            pc1.setSelfOneOne(pc1);
            pc2.setSelfOneOne(pc1);
            pc1.getSelfOneMany().add(pc1);
            pc1.getSelfOneMany().add(pc2);
            pc3.setSelfOneOne(pc3);
            pc4.setSelfOneOne(pc3);
            pc3.getSelfOneMany().add(pc3);
            pc3.getSelfOneMany().add(pc4);
        }
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)pc1);
        em.persist((Object)pc2);
        em.persist((Object)pc3);
        em.persist((Object)pc4);
        em.getTransaction().commit();
        em.close();
    }

    public void testSimpleGroup() {
        OpenJPAQuery q = this.em.createQuery("select o.intField from AllFieldTypes o group by o.intField order by o.intField asc");
        this.prepareQuery((Query)q);
        List res = q.getResultList();
        GroupingTestCase.assertEquals((int)2, (int)res.size());
        Iterator itr = res.iterator();
        GroupingTestCase.assertEquals((Object)1, itr.next());
        GroupingTestCase.assertEquals((Object)2, itr.next());
        GroupingTestCase.assertTrue((!itr.hasNext() ? 1 : 0) != 0);
    }

    public void testOrderByAggregate() {
        OpenJPAQuery q = this.em.createQuery("select sum(o.shortField) from AllFieldTypes o group by o.intField order by sum(o.shortField) asc");
        this.prepareQuery((Query)q);
        List res = q.getResultList();
        GroupingTestCase.assertEquals((int)2, (int)res.size());
        Iterator itr = res.iterator();
        GroupingTestCase.assertEquals((Object)-4L, itr.next());
        GroupingTestCase.assertEquals((Object)-2L, itr.next());
        GroupingTestCase.assertTrue((!itr.hasNext() ? 1 : 0) != 0);
    }

    public void testCompoundGroupSame() {
        OpenJPAQuery q = this.em.createQuery("select o.intField from AllFieldTypes o group by o.intField, o.shortField order by o.shortField asc");
        this.prepareQuery((Query)q);
        List res = q.getResultList();
        GroupingTestCase.assertEquals((int)2, (int)res.size());
        Iterator itr = res.iterator();
        GroupingTestCase.assertEquals((Object)2, itr.next());
        GroupingTestCase.assertEquals((Object)1, itr.next());
        GroupingTestCase.assertTrue((!itr.hasNext() ? 1 : 0) != 0);
    }

    public void testCompoundGroupDifferent() {
        OpenJPAQuery q = this.em.createQuery("select o.intField from AllFieldTypes o group by o.intField, o.byteField order by o.intField asc");
        this.prepareQuery((Query)q);
        List res = q.getResultList();
        GroupingTestCase.assertEquals((int)4, (int)res.size());
        Iterator itr = res.iterator();
        GroupingTestCase.assertEquals((Object)1, itr.next());
        GroupingTestCase.assertEquals((Object)1, itr.next());
        GroupingTestCase.assertEquals((Object)2, itr.next());
        GroupingTestCase.assertEquals((Object)2, itr.next());
        GroupingTestCase.assertTrue((!itr.hasNext() ? 1 : 0) != 0);
    }

    public void testDifferentGroupLengths() {
        OpenJPAQuery q = this.em.createQuery("select o.byteField from AllFieldTypes o group by o.byteField order by o.byteField asc");
        this.prepareQuery((Query)q);
        List res = q.getResultList();
        GroupingTestCase.assertEquals((int)3, (int)res.size());
        Iterator itr = res.iterator();
        GroupingTestCase.assertEquals((Object)0, itr.next());
        GroupingTestCase.assertEquals((Object)1, itr.next());
        GroupingTestCase.assertEquals((Object)2, itr.next());
        GroupingTestCase.assertTrue((!itr.hasNext() ? 1 : 0) != 0);
    }

    public void testGroupRelationField() {
        OpenJPAQuery q = this.em.createQuery("select o.selfOneOne.intField from AllFieldTypes o group by o.selfOneOne.intField order by o.selfOneOne.intField asc");
        this.prepareQuery((Query)q);
        List res = q.getResultList();
        GroupingTestCase.assertEquals((int)2, (int)res.size());
        Iterator itr = res.iterator();
        GroupingTestCase.assertEquals((Object)1, itr.next());
        GroupingTestCase.assertEquals((Object)2, itr.next());
        GroupingTestCase.assertTrue((!itr.hasNext() ? 1 : 0) != 0);
    }

    public void testSubstringInGroupBy() {
        DBDictionary dict = ((JDBCConfiguration)this.emf.getConfiguration()).getDBDictionaryInstance();
        if (dict instanceof SolidDBDictionary) {
            return;
        }
        OpenJPAQuery q = this.em.createQuery("select substring(o.stringField, 1, 1), count(o) from AllFieldTypes o group by substring(o.stringField, 1, 1)");
        this.prepareQuery((Query)q);
        List res = q.getResultList();
        GroupingTestCase.assertEquals((int)3, (int)res.size());
        q = this.em.createQuery("select substring(o.stringField, 1, 2), count(o) from AllFieldTypes o group by substring(o.stringField, 1, 2)");
        this.prepareQuery((Query)q);
        res = q.getResultList();
        GroupingTestCase.assertEquals((int)4, (int)res.size());
    }

    public void testGroupedAggregate() {
        OpenJPAQuery q = this.em.createQuery("select count(o) from AllFieldTypes o group by o.byteField order by o.byteField asc");
        this.prepareQuery((Query)q);
        List res = q.getResultList();
        GroupingTestCase.assertEquals((int)3, (int)res.size());
        Iterator itr = res.iterator();
        GroupingTestCase.assertEquals((Object)1L, itr.next());
        GroupingTestCase.assertEquals((Object)2L, itr.next());
        GroupingTestCase.assertEquals((Object)1L, itr.next());
        GroupingTestCase.assertTrue((!itr.hasNext() ? 1 : 0) != 0);
    }

    public void testGroupedRelationAggregate() {
        OpenJPAQuery q = this.em.createQuery("select count(o), max(o.selfOneOne.longField) from AllFieldTypes o group by o.intField order by o.intField asc");
        List res = q.getResultList();
        GroupingTestCase.assertEquals((int)2, (int)res.size());
        Iterator itr = res.iterator();
        Object[] o = (Object[])itr.next();
        GroupingTestCase.assertEquals((Object)2L, (Object)o[0]);
        GroupingTestCase.assertEquals((Object)4L, (Object)o[1]);
        o = (Object[])itr.next();
        GroupingTestCase.assertEquals((Object)2L, (Object)o[0]);
        GroupingTestCase.assertEquals((Object)2L, (Object)o[1]);
        GroupingTestCase.assertTrue((!itr.hasNext() ? 1 : 0) != 0);
    }

    public void testGroupedMixedProjection() {
        OpenJPAQuery q = this.em.createQuery("select count(o), o.shortField from AllFieldTypes o group by o.intField, o.shortField order by o.intField asc");
        this.prepareQuery((Query)q);
        List res = q.getResultList();
        GroupingTestCase.assertEquals((int)2, (int)res.size());
        Iterator itr = res.iterator();
        Object[] o = (Object[])itr.next();
        GroupingTestCase.assertEquals((Object)2L, (Object)o[0]);
        GroupingTestCase.assertEquals((Object)-1, (Object)o[1]);
        o = (Object[])itr.next();
        GroupingTestCase.assertEquals((Object)2L, (Object)o[0]);
        GroupingTestCase.assertEquals((Object)-2, (Object)o[1]);
        GroupingTestCase.assertTrue((!itr.hasNext() ? 1 : 0) != 0);
    }

    public void testSimpleHaving() {
        OpenJPAQuery q = this.em.createQuery("select o.intField from AllFieldTypes o group by o.intField having o.intField < 2");
        this.prepareQuery((Query)q);
        GroupingTestCase.assertEquals((Object)1, (Object)q.getSingleResult());
    }

    public void testAggregateHaving() {
        OpenJPAQuery q = this.em.createQuery("select o.byteField from AllFieldTypes o group by o.byteField having count(o) > 1");
        this.prepareQuery((Query)q);
        GroupingTestCase.assertEquals((Object)1, (Object)q.getSingleResult());
    }

    public void testMixedHaving() {
        OpenJPAQuery q = this.em.createQuery("select o.byteField from AllFieldTypes o group by o.byteField having count(o) > 1 or o.byteField = 0 order by o.byteField asc");
        this.prepareQuery((Query)q);
        List res = q.getResultList();
        GroupingTestCase.assertEquals((int)2, (int)res.size());
        Iterator itr = res.iterator();
        GroupingTestCase.assertEquals((Object)0, itr.next());
        GroupingTestCase.assertEquals((Object)1, itr.next());
        GroupingTestCase.assertTrue((!itr.hasNext() ? 1 : 0) != 0);
    }

    public void testVariableGroup() {
        OpenJPAQuery q = this.em.createQuery("select max(other.longField) from AllFieldTypes o, AllFieldTypes other where other member of o.selfOneMany group by other.intField order by other.intField asc");
        this.prepareQuery((Query)q);
        List res = q.getResultList();
        GroupingTestCase.assertEquals((int)2, (int)res.size());
        Iterator itr = res.iterator();
        GroupingTestCase.assertEquals((Object)2L, itr.next());
        GroupingTestCase.assertEquals((Object)4L, itr.next());
        GroupingTestCase.assertTrue((!itr.hasNext() ? 1 : 0) != 0);
    }

    public void testVariableHaving() {
        JDBCConfiguration conf = (JDBCConfiguration)this.em.getConfiguration();
        DBDictionary dict = conf.getDBDictionaryInstance();
        if (dict instanceof DerbyDictionary) {
            return;
        }
        OpenJPAQuery q = this.em.createQuery("select max(o.longField), other.byteField from AllFieldTypes o, AllFieldTypes other where other member of o.selfOneMany group by other.byteField having sum(other.intField) = 2");
        this.prepareQuery((Query)q);
        GroupingTestCase.assertEquals((Object)3L, (Object)((Object[])q.getSingleResult())[0]);
    }
}

