/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.pudefaults;

import javax.persistence.EntityTransaction;
import org.apache.openjpa.jdbc.sql.DB2Dictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.pudefaults.PUDefaultSchemaEntity;
import org.apache.openjpa.persistence.pudefaults.PUSchemaInSequenceAnnotationEntity;
import org.apache.openjpa.persistence.pudefaults.PUSchemaInSequenceMappingEntity;
import org.apache.openjpa.persistence.pudefaults.PUSchemaInTableAnnotationEntity;
import org.apache.openjpa.persistence.pudefaults.PUSchemaInTableMappingEntity;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestSchemaPUDefault
extends SQLListenerTestCase {
    @Override
    public void setUp() throws Exception {
        super.setUp(PUDefaultSchemaEntity.class, PUSchemaInSequenceAnnotationEntity.class, PUSchemaInTableAnnotationEntity.class, PUSchemaInTableMappingEntity.class, PUSchemaInSequenceMappingEntity.class);
        this.setSupportedDatabases(DB2Dictionary.class);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    protected String getPersistenceUnitName() {
        return "puDefault";
    }

    public void testSchemaInPUDefault() {
        this.persist(new PUDefaultSchemaEntity());
        this.assertContainsSQL("ALTER SEQUENCE schemaInPUDefaults.SeqName_4DefaultSchema");
        this.assertContainsSQL("INSERT INTO schemaInPUDefaults.PUDefaultSchemaEntity");
    }

    public void testSchemaInSequenceAnnotation() {
        this.persist(new PUSchemaInSequenceAnnotationEntity());
        this.assertContainsSQL("ALTER SEQUENCE schemaInSequenceAnnotation.SeqName_4AnnoSequenceSchema");
        this.assertContainsSQL("INSERT INTO schemaInPUDefaults.PUSchemaInSequenceAnnotationEntity");
    }

    public void testSchemaInTableAnnotation() {
        this.persist(new PUSchemaInTableAnnotationEntity());
        this.assertContainsSQL("ALTER SEQUENCE schemaInPUDefaults.SeqName_4AnnoTableSchema");
        this.assertContainsSQL("INSERT INTO schemaInTableAnnotation.PUSchemaInTable");
    }

    public void testSchemaInTableMapping() {
        this.persist(new PUSchemaInTableMappingEntity());
        this.assertContainsSQL("ALTER SEQUENCE schemaInPUDefaults.SeqName_4TableMappingSchema");
        this.assertContainsSQL("INSERT INTO schemaInTableMapping.PUSchemaInTableMapping");
    }

    public void testSchemaInSequenceMapping() {
        this.persist(new PUSchemaInSequenceMappingEntity());
        this.assertContainsSQL("ALTER SEQUENCE schemaInSequenceMapping.SeqName_4SequenceMappingSchema");
        this.assertContainsSQL("INSERT INTO schemaInPUDefaults.PUSchemaInSequenceMappingEntity");
    }

    public void persist(Object ent) {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tx = em.getTransaction();
        tx.begin();
        em.persist(ent);
        tx.commit();
        em.close();
    }
}

