/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.pudefaults;

import javax.persistence.EntityTransaction;
import org.apache.openjpa.jdbc.sql.DB2Dictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.pudefaults.PUDefaultSchemaEntity;
import org.apache.openjpa.persistence.pudefaults.PUSchemaInSequenceAnnotationEntity;
import org.apache.openjpa.persistence.pudefaults.PUSchemaInSequenceMappingEntity;
import org.apache.openjpa.persistence.pudefaults.PUSchemaInTableAnnotationEntity;
import org.apache.openjpa.persistence.pudefaults.PUSchemaInTableMappingEntity;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestOpenJPASchemaPUDefault
extends SQLListenerTestCase {
    @Override
    public void setUp() throws Exception {
        super.setUp(PUDefaultSchemaEntity.class, PUSchemaInSequenceAnnotationEntity.class, PUSchemaInTableAnnotationEntity.class, PUSchemaInTableMappingEntity.class, PUSchemaInSequenceMappingEntity.class);
        this.setSupportedDatabases(DB2Dictionary.class);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    protected String getPersistenceUnitName() {
        return "overrideMappingSchema";
    }

    public void testOpenJPASchemaOverridesORM() {
        this.persist(new PUDefaultSchemaEntity());
        this.assertContainsSQL("ALTER SEQUENCE PUSCHEMA.SeqName_4DefaultSchema");
        this.assertContainsSQL("INSERT INTO PUSCHEMA.PUDefaultSchemaEntity");
    }

    public void persist(Object ent) {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tx = em.getTransaction();
        tx.begin();
        em.persist(ent);
        tx.commit();
        em.close();
    }
}

