/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.puconf;

import java.util.MissingResourceException;
import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.test.PersistenceTestCase;

public class TestPersistenceUnitConfig
extends PersistenceTestCase {
    private String persistenceXmlResource = ((Object)((Object)this)).getClass().getPackage().getName().replaceAll("\\.", "/") + "/META-INF/persistence.xml";

    public EntityManagerFactory createEmf(String unitName) {
        return OpenJPAPersistence.createEntityManagerFactory((String)unitName, (String)this.persistenceXmlResource);
    }

    public void testCreateEMFWithGoodPU() {
        EntityManagerFactory emf = null;
        try {
            emf = this.createEmf("PUTest-Good");
            TestPersistenceUnitConfig.assertNotNull((String)"Assert emf was successfully created.", (Object)emf);
        }
        finally {
            if (emf != null) {
                try {
                    emf.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public void testCreateEMFWithBadJarFileElement() {
        EntityManagerFactory emf = null;
        try {
            emf = this.createEmf("PUTest-Good");
        }
        finally {
            if (emf != null) {
                try {
                    emf.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public void testCreateEMFWithNonOpenJPAProvider() {
        EntityManagerFactory emf = null;
        try {
            emf = this.createEmf("PUTest-NonOpenJPAProvider");
            TestPersistenceUnitConfig.fail((String)"The createEntityManager() operation did not throw any Exception.");
        }
        catch (MissingResourceException missingResourceException) {
        }
        finally {
            if (emf != null) {
                try {
                    emf.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public void testCreateEMFWithBadJarFileElementAndNonOpenJPAProvider() {
        EntityManagerFactory emf = null;
        try {
            emf = this.createEmf("PUTest-BadJarFile-NonOpenJPAProvider");
            TestPersistenceUnitConfig.fail((String)"The createEntityManager() operation did not throw any Exception.");
        }
        catch (MissingResourceException missingResourceException) {
        }
        finally {
            if (emf != null) {
                try {
                    emf.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

