/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.proxy.entities;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.DecimalFormat;
import java.text.ParseException;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.persistence.proxy.entities.Annuity;
import org.apache.openjpa.persistence.proxy.entities.IEquityAnnuity;

@Entity
@DiscriminatorValue(value="EQUITY")
public class EquityAnnuity
extends Annuity
implements IEquityAnnuity,
PersistenceCapable,
Externalizable {
    private static final long serialVersionUID = -7227462924769151013L;
    private String fundNames;
    private Double indexRate;
    private static int pcInheritedFieldCount = Annuity.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient boolean pcVersionInit;
    static /* synthetic */ Class class$Lorg$apache$openjpa$persistence$proxy$entities$Annuity;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Ljava$lang$Double;
    static /* synthetic */ Class class$Lorg$apache$openjpa$persistence$proxy$entities$EquityAnnuity;

    @Override
    @Column(name="FUND_NAMES")
    public String getFundNames() {
        if (this.pcStateManager == null) {
            return this.pcgetFundNames();
        }
        int n = pcInheritedFieldCount + 0;
        this.pcStateManager.accessingField(n);
        return this.pcgetFundNames();
    }

    @Override
    public void setFundNames(String string) {
        if (this.pcStateManager == null) {
            this.pcsetFundNames(string);
            return;
        }
        this.pcStateManager.settingStringField((PersistenceCapable)this, pcInheritedFieldCount + 0, this.pcgetFundNames(), string, 0);
    }

    @Override
    @Column(name="INDEX_RATE")
    public Double getIndexRate() {
        if (this.pcStateManager == null) {
            return this.pcgetIndexRate();
        }
        int n = pcInheritedFieldCount + 1;
        this.pcStateManager.accessingField(n);
        return this.pcgetIndexRate();
    }

    @Override
    public void setIndexRate(Double d) {
        if (this.pcStateManager == null) {
            this.pcsetIndexRate(d);
            return;
        }
        this.pcStateManager.settingObjectField((PersistenceCapable)this, pcInheritedFieldCount + 1, (Object)this.pcgetIndexRate(), (Object)d, 0);
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 196634845;
    }

    static {
        Class clazz = class$Lorg$apache$openjpa$persistence$proxy$entities$Annuity != null ? class$Lorg$apache$openjpa$persistence$proxy$entities$Annuity : (class$Lorg$apache$openjpa$persistence$proxy$entities$Annuity = EquityAnnuity.class$("org.apache.openjpa.persistence.proxy.entities.Annuity"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"fundNames", "indexRate"};
        Class[] classArray = new Class[2];
        Class clazz2 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = EquityAnnuity.class$("java.lang.String"));
        classArray[0] = clazz2;
        Class clazz3 = class$Ljava$lang$Double != null ? class$Ljava$lang$Double : (class$Ljava$lang$Double = EquityAnnuity.class$("java.lang.Double"));
        classArray[1] = clazz3;
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26};
        Class clazz4 = class$Lorg$apache$openjpa$persistence$proxy$entities$EquityAnnuity != null ? class$Lorg$apache$openjpa$persistence$proxy$entities$EquityAnnuity : (class$Lorg$apache$openjpa$persistence$proxy$entities$EquityAnnuity = EquityAnnuity.class$("org.apache.openjpa.persistence.proxy.entities.EquityAnnuity"));
        PCRegistry.register((Class)clazz4, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"EquityAnnuity", (PersistenceCapable)new EquityAnnuity());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.pcsetFundNames(null);
        this.pcsetIndexRate(null);
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        EquityAnnuity equityAnnuity = new EquityAnnuity();
        if (bl) {
            equityAnnuity.pcClearFields();
        }
        equityAnnuity.pcStateManager = stateManager;
        equityAnnuity.pcCopyKeyFieldsFromObjectId(object);
        return equityAnnuity;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        EquityAnnuity equityAnnuity = new EquityAnnuity();
        if (bl) {
            equityAnnuity.pcClearFields();
        }
        equityAnnuity.pcStateManager = stateManager;
        return equityAnnuity;
    }

    protected static int pcGetManagedFieldCount() {
        return 2 + Annuity.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcsetFundNames(this.pcStateManager.replaceStringField((PersistenceCapable)this, n));
                return;
            }
            case 1: {
                this.pcsetIndexRate((Double)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n));
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.pcgetFundNames());
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.pcgetIndexRate());
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(EquityAnnuity equityAnnuity, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(equityAnnuity, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcsetFundNames(equityAnnuity.pcgetFundNames());
                return;
            }
            case 1: {
                this.pcsetIndexRate(equityAnnuity.pcgetIndexRate());
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        EquityAnnuity equityAnnuity = (EquityAnnuity)object;
        if (equityAnnuity.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(equityAnnuity, nArray[n]);
            ++n;
        }
    }

    @Override
    public Class pcGetIDOwningClass() {
        Class clazz = class$Lorg$apache$openjpa$persistence$proxy$entities$EquityAnnuity != null ? class$Lorg$apache$openjpa$persistence$proxy$entities$EquityAnnuity : (class$Lorg$apache$openjpa$persistence$proxy$entities$EquityAnnuity = EquityAnnuity.class$("org.apache.openjpa.persistence.proxy.entities.EquityAnnuity"));
        return clazz;
    }

    protected String pcgetFundNames() {
        return this.fundNames;
    }

    protected void pcsetFundNames(String string) {
        this.fundNames = string;
    }

    protected Double pcgetIndexRate() {
        return this.indexRate;
    }

    protected void pcsetIndexRate(Double d) {
        if (d != null) {
            DecimalFormat decimalFormat = new DecimalFormat("#.##");
            try {
                df.indexRate = decimalFormat.parse(decimalFormat.format(d)).doubleValue();
            }
            catch (ParseException parseException) {
                throw new RuntimeException(parseException);
            }
        } else {
            this.indexRate = null;
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.pcReadUnmanaged(objectInput);
        this.pcSetDetachedState(objectInput.readObject());
        this.pcReplaceStateManager((StateManager)objectInput.readObject());
        this.readExternalFields(objectInput);
    }

    @Override
    protected void readExternalFields(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternalFields(objectInput);
        this.pcsetFundNames((String)objectInput.readObject());
        this.pcsetIndexRate((Double)objectInput.readObject());
    }

    @Override
    protected void pcReadUnmanaged(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.pcReadUnmanaged(objectInput);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.pcWriteUnmanaged(objectOutput);
        if (this.pcStateManager != null) {
            if (this.pcStateManager.writeDetached(objectOutput)) {
                return;
            }
        } else {
            objectOutput.writeObject(this.pcGetDetachedState());
            objectOutput.writeObject(null);
        }
        this.writeExternalFields(objectOutput);
    }

    @Override
    protected void writeExternalFields(ObjectOutput objectOutput) throws IOException {
        super.writeExternalFields(objectOutput);
        objectOutput.writeObject(this.pcgetFundNames());
        objectOutput.writeObject(this.pcgetIndexRate());
    }

    @Override
    protected void pcWriteUnmanaged(ObjectOutput objectOutput) throws IOException {
        super.pcWriteUnmanaged(objectOutput);
    }
}

