/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.proxy.delayed.vec;

import java.util.Collection;
import javax.persistence.EntityManager;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.proxy.delayed.IDepartment;
import org.apache.openjpa.persistence.proxy.delayed.IEmployee;
import org.apache.openjpa.persistence.proxy.delayed.vec.TestDelayedVectorProxy;
import org.apache.openjpa.util.DelayedVectorProxy;

public class TestDelayedVectorProxyDetachLite
extends TestDelayedVectorProxy {
    @Override
    public void setUp() {
        super.setUp("openjpa.DetachState", "loaded(LiteAutoDetach=true,detachProxyFields=false)");
    }

    @Override
    public void testPostDetach() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        IDepartment d = this.createDepartment();
        IEmployee e = this.createEmployee();
        e.setDept(d);
        e.setEmpName("John");
        Collection<IEmployee> emps = this.createEmployees();
        emps.add(e);
        d.setEmployees(emps);
        em.getTransaction().begin();
        em.persist((Object)d);
        em.getTransaction().commit();
        this.resetSQL();
        em.clear();
        d = this.findDepartment((EntityManager)em, d.getId());
        emps = d.getEmployees();
        em.close();
        this.assertNoneSQLAnyOrder("SELECT .* DC_EMPLOYEE .*");
        TestDelayedVectorProxyDetachLite.assertTrue((boolean)(emps instanceof DelayedVectorProxy));
        DelayedVectorProxy dep = (DelayedVectorProxy)emps;
        dep.setDirectAccess(true);
        TestDelayedVectorProxyDetachLite.assertEquals((int)0, (int)dep.size());
        dep.setDirectAccess(false);
        TestDelayedVectorProxyDetachLite.assertNotNull(emps);
        this.resetSQL();
        TestDelayedVectorProxyDetachLite.assertTrue((boolean)emps.contains(e));
        e = this.getEmployee(emps, 0);
        this.assertAnySQLAnyOrder("SELECT .* DC_EMPLOYEE .*");
        this.resetSQL();
        TestDelayedVectorProxyDetachLite.assertEquals((int)1, (int)emps.size());
        TestDelayedVectorProxyDetachLite.assertTrue((boolean)(e instanceof PersistenceCapable));
        PersistenceCapable pc = (PersistenceCapable)e;
        TestDelayedVectorProxyDetachLite.assertTrue((pc.pcGetStateManager() == null ? 1 : 0) != 0);
        this.assertNoneSQLAnyOrder("SELECT .* DC_EMPLOYEE .*");
    }
}

