/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.proxy;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.persistence.EntityManager;
import org.apache.openjpa.conf.Compatibility;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.proxy.entities.Address;
import org.apache.openjpa.persistence.proxy.entities.Annuity;
import org.apache.openjpa.persistence.proxy.entities.AnnuityHolder;
import org.apache.openjpa.persistence.proxy.entities.AnnuityHolderCategory;
import org.apache.openjpa.persistence.proxy.entities.AnnuityPersistebleObject;
import org.apache.openjpa.persistence.proxy.entities.AnnuityType;
import org.apache.openjpa.persistence.proxy.entities.Contact;
import org.apache.openjpa.persistence.proxy.entities.ContactType;
import org.apache.openjpa.persistence.proxy.entities.EquityAnnuity;
import org.apache.openjpa.persistence.proxy.entities.FixedAnnuity;
import org.apache.openjpa.persistence.proxy.entities.IAnnuity;
import org.apache.openjpa.persistence.proxy.entities.IAnnuityHolder;
import org.apache.openjpa.persistence.proxy.entities.IContact;
import org.apache.openjpa.persistence.proxy.entities.IEquityAnnuity;
import org.apache.openjpa.persistence.proxy.entities.IFixedAnnuity;
import org.apache.openjpa.persistence.proxy.entities.IPayor;
import org.apache.openjpa.persistence.proxy.entities.IPayout;
import org.apache.openjpa.persistence.proxy.entities.IRider;
import org.apache.openjpa.persistence.proxy.entities.Payor;
import org.apache.openjpa.persistence.proxy.entities.Payout;
import org.apache.openjpa.persistence.proxy.entities.Person;
import org.apache.openjpa.persistence.proxy.entities.Rider;
import org.apache.openjpa.persistence.proxy.entities.RiderType;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestDetachMerge
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        this.setUp(DROP_TABLES, Address.class, Annuity.class, AnnuityHolder.class, AnnuityPersistebleObject.class, Contact.class, EquityAnnuity.class, FixedAnnuity.class, Payor.class, Payout.class, Person.class, Rider.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnnuity1Compat() throws Exception {
        OpenJPAEntityManagerFactorySPI emf1 = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.createEntityManagerFactory((String)"Annuity1Compat", (String)"org/apache/openjpa/persistence/proxy/persistence1.xml");
        TestDetachMerge.assertNotNull((Object)emf1);
        Log log = emf1.getConfiguration().getLog("test");
        if (log.isTraceEnabled()) {
            Compatibility compat = emf1.getConfiguration().getCompatibilityInstance();
            TestDetachMerge.assertNotNull((Object)compat);
            log.trace((Object)"started testAnnuity1Compat()");
            log.trace((Object)("FlushBeforeDetach=" + compat.getFlushBeforeDetach()));
            log.trace((Object)("CopyOnDetach=" + compat.getCopyOnDetach()));
            log.trace((Object)("CascadeWithDetach=" + compat.getCascadeWithDetach()));
            log.trace((Object)("IgnoreDetachedStateFieldForProxySerialization=" + compat.getIgnoreDetachedStateFieldForProxySerialization()));
        }
        try {
            this.execute(emf1);
        }
        catch (RuntimeException e) {
            TestDetachMerge.fail((String)("testAnuity1Compat() should not have caused an execption!" + e));
        }
        finally {
            emf1.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnnuity2Compat() throws Exception {
        OpenJPAEntityManagerFactorySPI emf2 = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.createEntityManagerFactory((String)"Annuity2Compat", (String)"org/apache/openjpa/persistence/proxy/persistence2.xml");
        TestDetachMerge.assertNotNull((Object)emf2);
        Log log = emf2.getConfiguration().getLog("test");
        if (log.isTraceEnabled()) {
            Compatibility compat = emf2.getConfiguration().getCompatibilityInstance();
            TestDetachMerge.assertNotNull((Object)compat);
            log.trace((Object)"started testAnnuity2Compat()");
            log.trace((Object)("FlushBeforeDetach=" + compat.getFlushBeforeDetach()));
            log.trace((Object)("CopyOnDetach=" + compat.getCopyOnDetach()));
            log.trace((Object)("CascadeWithDetach=" + compat.getCascadeWithDetach()));
            log.trace((Object)("IgnoreDetachedStateFieldForProxySerialization=" + compat.getIgnoreDetachedStateFieldForProxySerialization()));
        }
        try {
            this.execute(emf2);
        }
        catch (RuntimeException e) {
            TestDetachMerge.fail((String)("testAnuity2Compat() should not have caused an execption!" + e));
        }
        finally {
            emf2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(OpenJPAEntityManagerFactorySPI myEMF) throws Exception {
        Log log = myEMF.getConfiguration().getLog("test");
        IContact contact = null;
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)"creating contact");
            }
            try {
                contact = this.createContact(myEMF);
            }
            catch (Exception e) {
                log.error((Object)"Create Contact failed.", (Throwable)e);
                throw e;
            }
            try {
                this.verifyContactValues(myEMF, contact);
            }
            catch (Exception e) {
                log.error((Object)"Create Contact verification failed.", (Throwable)e);
                throw e;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)"creating annuity holder");
            }
            IAnnuityHolder annuityHolder = null;
            try {
                annuityHolder = this.createAnnuityHolder(myEMF, contact);
            }
            catch (Exception e) {
                log.error((Object)"failed to create Annuity Holder Successfully.", (Throwable)e);
                throw e;
            }
            try {
                this.verifyAnnuityHolderValues(myEMF, annuityHolder);
            }
            catch (Exception e) {
                log.info((Object)"failed to verify create annuity holder successfuly.", (Throwable)e);
                throw e;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)"creating payor");
            }
            IPayor payor = null;
            try {
                payor = this.createPayor(myEMF);
            }
            catch (Exception e) {
                log.error((Object)"failed to create payor successfuly.", (Throwable)e);
                throw e;
            }
            try {
                this.verifyPayorValues(myEMF, payor);
            }
            catch (Exception e) {
                log.error((Object)"failed to verify create payor successfuly.", (Throwable)e);
                throw e;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)"creating annuity");
            }
            IAnnuity annuity = null;
            AnnuityType annuityType = AnnuityType.FIXED;
            try {
                annuity = this.createAnnuityWithRider(myEMF, annuityType);
            }
            catch (Exception e) {
                log.error((Object)"failed to create annuity successfuly.", (Throwable)e);
                throw e;
            }
            try {
                log.trace((Object)"verify annuity with rider");
                this.verifyAnnuityValues(myEMF, annuity, annuityType);
            }
            catch (Exception e) {
                log.error((Object)"failed to verify create annuity successfuly.", (Throwable)e);
                throw e;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)"upating annuity");
            }
            try {
                log.trace((Object)"create annuity with payout");
                annuity = this.createAnnuityPayout(myEMF, annuity);
            }
            catch (Exception e) {
                log.error((Object)"failed to create annuity successfuly.", (Throwable)e);
                throw e;
            }
            try {
                this.verifyAnnuityValues(myEMF, annuity, annuityType);
            }
            catch (Exception e) {
                log.error((Object)"failed to verify create annuity successfuly.", (Throwable)e);
                throw e;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)"upating annuity");
            }
            try {
                EntityManager em = this.createEM(myEMF);
                em.getTransaction().begin();
                annuity.getPayors().add(payor);
                annuity.setAnnuityHolderId(annuityHolder.getId());
                annuity = (IAnnuity)em.merge((Object)annuity);
                em.getTransaction().commit();
                this.closeEM(em);
            }
            catch (Exception e) {
                log.error((Object)"failed to update annuity successfuly.", (Throwable)e);
                throw e;
            }
            try {
                this.verifyAnnuityValues(myEMF, annuity, annuityType);
            }
            catch (Exception e) {
                log.error((Object)"failed to verify annuity update successfuly.", (Throwable)e);
                throw e;
            }
        }
        finally {
            log.error((Object)"scenario: failed.");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"scenario: completed.");
        }
    }

    private IAnnuity createAnnuityPayout(OpenJPAEntityManagerFactorySPI myEMF, IAnnuity annuity) {
        EntityManager em = this.createEM(myEMF);
        em.getTransaction().begin();
        Payout payout = new Payout();
        payout.setAnnuity(annuity);
        payout.setTaxableAmount(new BigDecimal(100.0));
        payout.setStartDate(Calendar.getInstance());
        payout.setEndDate(Calendar.getInstance());
        payout.setId(this.getId());
        em.persist((Object)payout);
        em.getTransaction().commit();
        em.getTransaction().begin();
        annuity.getPayouts().add(payout);
        em.getTransaction().commit();
        this.closeEM(em);
        return annuity;
    }

    private IAnnuity createAnnuityWithRider(OpenJPAEntityManagerFactorySPI myEMF, AnnuityType annuityType) {
        EntityManager em = this.createEM(myEMF);
        em.getTransaction().begin();
        IAnnuity annuity = this.createAnnuity(annuityType);
        IRider rider1 = this.getRider();
        IRider rider2 = this.getRider();
        IRider rider3 = this.getRider();
        annuity.getRiders().add(rider1);
        annuity.getRiders().add(rider2);
        annuity.getRiders().add(rider3);
        em.persist((Object)annuity);
        em.getTransaction().commit();
        this.closeEM(em);
        return annuity;
    }

    private IAnnuity createAnnuity(AnnuityType annuityType) {
        if (AnnuityType.BASIC.equals((Object)annuityType)) {
            Annuity annuity = new Annuity();
            annuity.setId(this.getId());
            annuity.setAmount(500.0);
            annuity.setAccountNumber("123456");
            return annuity;
        }
        if (AnnuityType.EQUITY.equals((Object)annuityType)) {
            EquityAnnuity annuity = new EquityAnnuity();
            annuity.setId(this.getId());
            annuity.setAmount(500.0);
            annuity.setAccountNumber("123456");
            annuity.setFundNames("Something nothing wrong");
            annuity.setIndexRate(10.99);
            annuity.setLastPaidAmt(100.0);
            return annuity;
        }
        if (AnnuityType.FIXED.equals((Object)annuityType)) {
            FixedAnnuity annuity = new FixedAnnuity();
            annuity.setRate(10.0);
            annuity.setId(this.getId());
            annuity.setAmount(500.0);
            annuity.setAccountNumber("123456");
            return annuity;
        }
        return null;
    }

    private IRider getRider() {
        Rider rider = new Rider();
        rider.setId(this.getId());
        rider.setRule("Pay");
        rider.setType(RiderType.REPLACE);
        rider.setEffectiveDate(new Date());
        return rider;
    }

    private void verifyAnnuityValues(OpenJPAEntityManagerFactorySPI myEMF, IAnnuity annuity, AnnuityType annuityType) throws Exception {
        int i;
        IAnnuity results = this.findAnnuityById(myEMF, Annuity.class, annuity.getId());
        if (annuity instanceof IFixedAnnuity) {
            this.assertEqual((IFixedAnnuity)annuity, (IFixedAnnuity)results, "Fixed Annuity from Client is not equal to DB value", "Mismacth was found.");
        } else if (annuity instanceof IEquityAnnuity) {
            this.assertEqual((IEquityAnnuity)annuity, (IEquityAnnuity)results, "Equity Annuity from Client is not equal to DB value", "Mismacth was found.");
        } else {
            this.assertEqual(annuity, results, "Basic Annuity from Client is not equal to DB value", "Mismacth was found.");
        }
        this.assertEqual(annuity.getPayouts(), results.getPayouts(), "Annuity payouts from Client is not equal to DB value", "Mismacth was found in number of payouts");
        boolean found = false;
        if (annuity.getPayouts() != null) {
            IPayout clientPayout = null;
            for (i = 0; i < annuity.getPayouts().size(); ++i) {
                found = false;
                clientPayout = annuity.getPayouts().get(i);
                for (IPayout resultPayout : results.getPayouts()) {
                    if (!clientPayout.getId().equals(resultPayout.getId())) continue;
                    found = true;
                    this.assertEqual(clientPayout, resultPayout, "Annuity Payout from Client is not equal to DB value at location: " + i, "Mismacth was found");
                }
                if (found || clientPayout == null) continue;
                throw new RuntimeException("Annuity: Payout from client is not equal to DB.  Found Payout with id: " + clientPayout.getId() + " on the client side, but not in the database for annuity id:" + annuity.getId());
            }
        }
        this.assertRidersEqual(annuity.getRiders(), results.getRiders(), "Annuity rider from Client is not equal to DB value", "Mismacth was found in number of rider");
        if (annuity.getRiders() != null) {
            IRider clientRider = null;
            for (i = 0; i < annuity.getRiders().size(); ++i) {
                found = false;
                clientRider = annuity.getRiders().get(i);
                for (IRider resultRider : results.getRiders()) {
                    if (!clientRider.getId().equals(resultRider.getId())) continue;
                    found = true;
                    this.assertEqual(clientRider, resultRider, "Annuity rider from Client is not equal to DB value at location: " + i, "Mismacth was found");
                }
                if (found || clientRider == null) continue;
                throw new RuntimeException("Annuity: Rider from client is not equal to DB.  Found rider with id: " + clientRider.getId() + " on the client side, but not in the database for annuity id:" + annuity.getId());
            }
        }
        this.assertPayorsEqual(annuity.getPayors(), results.getPayors(), "Annuity Payor from Client is not equal to DB value", "Mismacth was found.");
        if (annuity.getPayors() != null) {
            IPayor clientPayor = null;
            for (i = 0; i < annuity.getPayors().size(); ++i) {
                found = false;
                clientPayor = annuity.getPayors().get(i);
                for (IPayor resultPayor : results.getPayors()) {
                    if (!clientPayor.getId().equals(resultPayor.getId())) continue;
                    found = true;
                    this.assertEqual(annuity.getPayors().get(i), resultPayor, "Annuity payor from Client is not equal to DB value at location: " + i, "Mismacth was found");
                }
                if (found || clientPayor == null) continue;
                throw new RuntimeException("Annuity: Payor from client is not equal to DB.  Found payor with id: " + clientPayor.getId() + " on the client side, but not in the database for annuity id:" + annuity.getId());
            }
        }
    }

    private void assertEqual(IAnnuity annuity, IAnnuity results, String string, String string2) throws Exception {
        if (annuity == null && results == null) {
            return;
        }
        if (annuity == null) {
            throw new RuntimeException("Annuity: Annuities ! equal (Annuity was null).");
        }
        if (!annuity.getId().equals(results.getId())) {
            throw new RuntimeException("Annuity: Annuities ! equal (Annuity ids not the same).");
        }
        this.assertPayorsEqual(annuity.getPayors(), results.getPayors(), string, string2);
        this.assertRidersEqual(annuity.getRiders(), results.getRiders(), string, string2);
        this.assertEqual(annuity.getPayouts(), results.getPayouts(), string, string2);
    }

    private void assertEqual(IEquityAnnuity annuity, IEquityAnnuity results, String string, String string2) throws Exception {
        if (annuity == null && results == null) {
            return;
        }
        if (annuity == null) {
            throw new RuntimeException("Annuity: Annuities ! equal (EquityAnnuity was null).");
        }
        if (!annuity.getId().equals(results.getId())) {
            throw new RuntimeException("Annuity: Annuities ! equal (EquityAnnuity ids not the same).");
        }
        this.assertPayorsEqual(annuity.getPayors(), results.getPayors(), string, string2);
        this.assertRidersEqual(annuity.getRiders(), results.getRiders(), string, string2);
        this.assertEqual(annuity.getPayouts(), results.getPayouts(), string, string2);
    }

    private void assertEqual(IFixedAnnuity annuity, IFixedAnnuity results, String string, String string2) throws Exception {
        if (annuity == null && results == null) {
            return;
        }
        if (annuity == null) {
            throw new RuntimeException("Annuity: Annuities ! equal (FixedAnnuity was null).");
        }
        if (!annuity.getId().equals(results.getId())) {
            throw new RuntimeException("Annuity: Annuities ! equal (FixedAnnuity ids not the same).");
        }
        this.assertPayorsEqual(annuity.getPayors(), results.getPayors(), string, string2);
        this.assertRidersEqual(annuity.getRiders(), results.getRiders(), string, string2);
        this.assertEqual(annuity.getPayouts(), results.getPayouts(), string, string2);
    }

    private IAnnuity findAnnuityById(OpenJPAEntityManagerFactorySPI myEMF, Class<Annuity> class1, String id) {
        EntityManager em = this.createEM(myEMF);
        IAnnuity ann = (IAnnuity)em.find(class1, (Object)id);
        this.closeEM(em);
        return ann;
    }

    private void assertEqual(List<IPayout> payouts, List<IPayout> payouts2, String string, String string2) throws Exception {
        if (payouts == null && payouts2 == null) {
            return;
        }
        if (payouts == null) {
            throw new RuntimeException("Annuity: IPayout list not the same (payouts was null)!");
        }
        if (payouts.size() != payouts2.size()) {
            throw new RuntimeException("Annuity: IPayout list not the same (payouts size not the same)!");
        }
        for (int i = 0; i < payouts.size(); ++i) {
            IPayout payout = payouts.get(i);
            boolean found = false;
            int j = 0;
            while (i < payouts2.size()) {
                try {
                    this.assertEqual(payout, payouts2.get(j), string, string2);
                    found = true;
                    break;
                }
                catch (Exception e) {
                    ++j;
                }
            }
            if (found) continue;
            throw new RuntimeException("Annuity: IPayout list not the same (no match found)!");
        }
    }

    private void assertEqual(IPayout clientPayout, IPayout resultPayout, String string, String string2) throws Exception {
        if (clientPayout == null && resultPayout == null) {
            return;
        }
        if (clientPayout == null) {
            throw new RuntimeException("Annuity: IPayout not the same (clientPayout was null)! " + string + " " + string2);
        }
        if (clientPayout.getId().equals(resultPayout.getId())) {
            return;
        }
        throw new RuntimeException("Annuity: IPayout not the same (clientPayout ids not the same)! " + string + " " + string2);
    }

    private void assertRidersEqual(List<IRider> riders, List<IRider> riders2, String string, String string2) throws Exception {
        if (riders == null && riders2 == null) {
            return;
        }
        if (riders == null) {
            throw new RuntimeException("Annuity: IRider list not the same (riders was null)!");
        }
        if (riders.size() != riders2.size()) {
            throw new RuntimeException("Annuity: IRider list not the same (riders size not the same)!");
        }
        for (int i = 0; i < riders.size(); ++i) {
            IRider rider = riders.get(i);
            boolean found = false;
            int j = 0;
            while (i < riders2.size()) {
                try {
                    this.assertEqual(rider, riders2.get(j), string, string2);
                    found = true;
                    break;
                }
                catch (Exception e) {
                    ++j;
                }
            }
            if (found) continue;
            throw new RuntimeException("Annuity: IRider list not the same (match not found)!");
        }
    }

    private void assertEqual(IRider clientRider, IRider resultRider, String string, String string2) throws Exception {
        if (clientRider == null && resultRider == null) {
            return;
        }
        if (clientRider == null) {
            throw new RuntimeException("Annuity: IRider not the same (clientRider was null)! " + string + " " + string2);
        }
        if (clientRider.getId().equals(resultRider.getId())) {
            return;
        }
        throw new RuntimeException("Annuity: IRider not the same (no match found)! " + string + " " + string2);
    }

    private void assertPayorsEqual(List<IPayor> payors, List<IPayor> payors2, String string, String string2) throws Exception {
        if (payors == null && payors2 == null) {
            return;
        }
        if (payors == null) {
            throw new RuntimeException("Annuity: IPayor list not the same (payors was null)!");
        }
        if (payors.size() != payors2.size()) {
            throw new RuntimeException("Annuity: IPayor list not the same (payors size not the same)! payors=" + Arrays.toString(payors.toArray()) + ", payors2=" + payors2.toString());
        }
        for (int i = 0; i < payors.size(); ++i) {
            IPayor payor = payors.get(i);
            boolean found = false;
            int j = 0;
            while (i < payors2.size()) {
                try {
                    this.assertEqual(payor, payors2.get(j), string, string2);
                    found = true;
                    break;
                }
                catch (Exception e) {
                    ++j;
                }
            }
            if (found) continue;
            throw new RuntimeException("Annuity: IPayor list not the same (no match found)!");
        }
    }

    private void verifyPayorValues(OpenJPAEntityManagerFactorySPI myEMF, IPayor payor) throws Exception {
        IPayor results = null;
        results = this.findPayorById(myEMF, Payor.class, payor.getId());
        this.assertEqual(payor, results, "Payor from Client is not equal to DB value.", "Mismacth was found.");
    }

    private IPayor findPayorById(OpenJPAEntityManagerFactorySPI myEMF, Class<Payor> class1, String id) {
        EntityManager em = this.createEM(myEMF);
        IPayor ip = (IPayor)em.find(class1, (Object)id);
        this.closeEM(em);
        return ip;
    }

    private void assertEqual(IPayor payor, IPayor results, String string, String string2) throws Exception {
        if (payor == null && results == null) {
            return;
        }
        if (payor == null) {
            throw new RuntimeException("Annuity: IPayor not the same (payor was null)! " + string + " " + string2);
        }
        if (payor.getId().equals(results.getId())) {
            return;
        }
        throw new RuntimeException("Annuity: IPayor not the same (no match found)! " + string + " " + string2);
    }

    private IPayor createPayor(OpenJPAEntityManagerFactorySPI myEMF) {
        EntityManager em = this.createEM(myEMF);
        em.getTransaction().begin();
        Payor payor = new Payor();
        payor.setId(this.getId());
        payor.setName("Payor");
        em.persist((Object)payor);
        em.getTransaction().commit();
        this.closeEM(em);
        return payor;
    }

    private void verifyAnnuityHolderValues(OpenJPAEntityManagerFactorySPI myEMF, IAnnuityHolder annuityHolder) throws Exception {
        IAnnuityHolder result = null;
        result = this.findHolderById(myEMF, AnnuityHolder.class, annuityHolder.getId());
        this.assertEqual(annuityHolder, result, "Annuity Holder from Client is not equal to DB value.", "Mismacth was found.");
        this.assertEqual(annuityHolder.getContact(), result.getContact(), "Annuity Holder Contact from Client is not equal to DB value.", "Mismacth was found.");
    }

    private IAnnuityHolder findHolderById(OpenJPAEntityManagerFactorySPI myEMF, Class<AnnuityHolder> class1, String id) {
        EntityManager em = this.createEM(myEMF);
        IAnnuityHolder result = (IAnnuityHolder)em.find(class1, (Object)id);
        this.closeEM(em);
        return result;
    }

    private EntityManager createEM(OpenJPAEntityManagerFactorySPI myEMF) {
        return myEMF.createEntityManager();
    }

    private void assertEqual(IAnnuityHolder annuityHolder, IAnnuityHolder results, String string, String string2) throws Exception {
        if (annuityHolder == null && results == null) {
            return;
        }
        if (annuityHolder == null) {
            throw new RuntimeException("Annuity: IAnnuityHolder not the same (annuityHolder was null)! " + string + " " + string2);
        }
        if (annuityHolder.getId().equals(results.getId())) {
            return;
        }
        throw new RuntimeException("Annuity: IAnnuityHolder not the same (no match found)! " + string + " " + string2);
    }

    private void assertEqual(IContact contact, IContact contact2, String string, String string2) throws Exception {
        if (contact == null && contact2 == null) {
            return;
        }
        if (contact == null) {
            throw new RuntimeException("Annuity: Contacts not the same (contact was null)! " + string + " " + string2);
        }
        if (contact.getId().equals(contact2.getId())) {
            return;
        }
        throw new RuntimeException("Annuity: Contacts not the same (no match found)! " + string + " " + string2);
    }

    private IAnnuityHolder createAnnuityHolder(OpenJPAEntityManagerFactorySPI myEMF, IContact contact) {
        EntityManager em = this.createEM(myEMF);
        em.getTransaction().begin();
        AnnuityHolder annuityHolder = new AnnuityHolder();
        annuityHolder.setCategory(AnnuityHolderCategory.METAL);
        annuityHolder.setContact(contact);
        annuityHolder.setId(this.getId());
        annuityHolder.setFirstName("bob");
        annuityHolder.setDateOfBirth(new Date());
        annuityHolder.setGovernmentId("US");
        annuityHolder.setLastName("dog");
        annuityHolder.setTimeOfBirth(new Date());
        em.persist((Object)annuityHolder);
        em.getTransaction().commit();
        this.closeEM(em);
        return annuityHolder;
    }

    private void verifyContactValues(OpenJPAEntityManagerFactorySPI myEMF, IContact contact) throws Exception {
        IContact results = null;
        results = this.findContactById(myEMF, Contact.class, contact.getId());
        this.assertEqual(contact, results, "Contact from Client is not equal to DB value.", "Mismacth was found.");
    }

    private IContact findContactById(OpenJPAEntityManagerFactorySPI myEMF, Class<Contact> class1, String id) {
        EntityManager em = this.createEM(myEMF);
        IContact ic = (IContact)em.find(class1, (Object)id);
        this.closeEM(em);
        return ic;
    }

    private IContact createContact(OpenJPAEntityManagerFactorySPI myEMF) {
        EntityManager em = this.createEM(myEMF);
        em.getTransaction().begin();
        Contact contact = null;
        contact = new Contact();
        contact.setContactType(ContactType.BUSINESS);
        contact.setId(this.getId());
        contact.setEmail("here@there");
        contact.setPhone("555-5555");
        em.persist((Object)contact);
        em.getTransaction().commit();
        this.closeEM(em);
        return contact;
    }

    private String getId() {
        UUID uid = UUID.randomUUID();
        return uid.toString();
    }
}

