/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.proxy;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToMany;
import javax.persistence.Version;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.persistence.proxy.ConcreteEntity;
import org.apache.openjpa.util.IntId;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.UserException;

@MappedSuperclass
public abstract class AbstractEntity
implements PersistenceCapable {
    @Id
    @GeneratedValue
    private int id;
    @Version
    int version;
    @OneToMany(cascade={CascadeType.ALL})
    private Set<ConcreteEntity> items = new LinkedHashSet<ConcreteEntity>();
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient boolean pcVersionInit;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Ljava$util$Set;
    static /* synthetic */ Class class$Lorg$apache$openjpa$persistence$proxy$AbstractEntity;
    private transient Object pcDetachedState;

    public int getId() {
        return AbstractEntity.pcGetid(this);
    }

    public Set<ConcreteEntity> getItems() {
        return AbstractEntity.pcGetitems(this);
    }

    public void addItem(ConcreteEntity ce) {
        if (AbstractEntity.pcGetitems(this) == null) {
            AbstractEntity.pcSetitems(this, new LinkedHashSet());
        }
        AbstractEntity.pcGetitems(this).add(ce);
    }

    public int pcGetEnhancementContractVersion() {
        return 196634845;
    }

    static {
        pcFieldNames = new String[]{"id", "items", "version"};
        Class[] classArray = new Class[3];
        classArray[0] = Integer.TYPE;
        Class clazz = class$Ljava$util$Set != null ? class$Ljava$util$Set : (class$Ljava$util$Set = AbstractEntity.class$("java.util.Set"));
        classArray[1] = clazz;
        classArray[2] = Integer.TYPE;
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 5, 21};
        Class clazz2 = class$Lorg$apache$openjpa$persistence$proxy$AbstractEntity != null ? class$Lorg$apache$openjpa$persistence$proxy$AbstractEntity : (class$Lorg$apache$openjpa$persistence$proxy$AbstractEntity = AbstractEntity.class$("org.apache.openjpa.persistence.proxy.AbstractEntity"));
        PCRegistry.register((Class)clazz2, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"AbstractEntity", null);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this.id = 0;
        this.items = null;
        this.version = 0;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        throw new UserException();
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        throw new UserException();
    }

    protected static int pcGetManagedFieldCount() {
        return 3;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.id = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.items = (Set)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.version = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                this.pcVersionInit = true;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.id);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.items);
                return;
            }
            case 2: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.version);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(AbstractEntity abstractEntity, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.id = abstractEntity.id;
                return;
            }
            case 1: {
                this.items = abstractEntity.items;
                return;
            }
            case 2: {
                this.version = abstractEntity.version;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        AbstractEntity abstractEntity = (AbstractEntity)object;
        if (abstractEntity.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(abstractEntity, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return new Integer(this.version);
        }
        return this.pcStateManager.getVersion();
    }

    public void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        IntId intId = (IntId)object;
        fieldConsumer.storeIntField(0 + pcInheritedFieldCount, intId.getId());
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        IntId intId = (IntId)object;
        this.id = intId.getId();
    }

    public Class pcGetIDOwningClass() {
        Class clazz = class$Lorg$apache$openjpa$persistence$proxy$AbstractEntity != null ? class$Lorg$apache$openjpa$persistence$proxy$AbstractEntity : (class$Lorg$apache$openjpa$persistence$proxy$AbstractEntity = AbstractEntity.class$("org.apache.openjpa.persistence.proxy.AbstractEntity"));
        return clazz;
    }

    public Object pcNewObjectIdInstance(Object object) {
        return new IntId(this.pcGetIDOwningClass(), (String)object);
    }

    public Object pcNewObjectIdInstance() {
        return new IntId(this.pcGetIDOwningClass(), this.id);
    }

    private static final int pcGetid(AbstractEntity abstractEntity) {
        if (abstractEntity.pcStateManager == null) {
            return abstractEntity.id;
        }
        int n = pcInheritedFieldCount + 0;
        abstractEntity.pcStateManager.accessingField(n);
        return abstractEntity.id;
    }

    private static final void pcSetid(AbstractEntity abstractEntity, int n) {
        if (abstractEntity.pcStateManager == null) {
            abstractEntity.id = n;
            return;
        }
        abstractEntity.pcStateManager.settingIntField((PersistenceCapable)abstractEntity, pcInheritedFieldCount + 0, abstractEntity.id, n, 0);
    }

    private static final Set pcGetitems(AbstractEntity abstractEntity) {
        if (abstractEntity.pcStateManager == null) {
            return abstractEntity.items;
        }
        int n = pcInheritedFieldCount + 1;
        abstractEntity.pcStateManager.accessingField(n);
        return abstractEntity.items;
    }

    private static final void pcSetitems(AbstractEntity abstractEntity, Set set) {
        if (abstractEntity.pcStateManager == null) {
            abstractEntity.items = set;
            return;
        }
        abstractEntity.pcStateManager.settingObjectField((PersistenceCapable)abstractEntity, pcInheritedFieldCount + 1, abstractEntity.items, (Object)set, 0);
    }

    static final int pcGetversion(AbstractEntity abstractEntity) {
        if (abstractEntity.pcStateManager == null) {
            return abstractEntity.version;
        }
        int n = pcInheritedFieldCount + 2;
        abstractEntity.pcStateManager.accessingField(n);
        return abstractEntity.version;
    }

    static final void pcSetversion(AbstractEntity abstractEntity, int n) {
        if (abstractEntity.pcStateManager == null) {
            abstractEntity.version = n;
            abstractEntity.pcVersionInit = true;
            return;
        }
        abstractEntity.pcStateManager.settingIntField((PersistenceCapable)abstractEntity, pcInheritedFieldCount + 2, abstractEntity.version, n, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (this.version != 0) {
            return Boolean.TRUE;
        }
        if (this.pcVersionInit) {
            return Boolean.TRUE;
        }
        return null;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }
}

