/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.property;

import java.util.HashMap;
import javax.persistence.Query;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.property.EmbeddableAddress;
import org.apache.openjpa.persistence.property.EntityContact;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestEMProperties
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        this.setUp(EntityContact.class, EmbeddableAddress.class, DROP_TABLES, "javax.persistence.query.timeout", 23456);
    }

    public void testQueryTimeoutPropertyDefault() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String sql = "select * from EntityContact";
        OpenJPAQuery query = OpenJPAPersistence.cast((Query)em.createNativeQuery(sql));
        TestEMProperties.assertEquals((int)23456, (int)query.getFetchPlan().getQueryTimeout());
        em.clear();
        em.close();
    }

    public void testQueryTimeoutPropertyOnEntityManagerCreation() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("javax.persistence.query.timeout", "12345");
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager(properties);
        String sql = "select * from EntityContact";
        OpenJPAQuery query = OpenJPAPersistence.cast((Query)em.createNativeQuery(sql));
        TestEMProperties.assertEquals((int)12345, (int)query.getFetchPlan().getQueryTimeout());
        em.clear();
        em.close();
    }

    public void testQueryTimeoutPropertySetOnEntityManager() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.setProperty("javax.persistence.query.timeout", (Object)"12345");
        String sql = "select * from EntityContact";
        OpenJPAQuery query = OpenJPAPersistence.cast((Query)em.createNativeQuery(sql));
        TestEMProperties.assertEquals((int)12345, (int)query.getFetchPlan().getQueryTimeout());
        em.clear();
        em.close();
    }
}

