/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.models.library;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.persistence.models.library.Borrower;
import org.apache.openjpa.persistence.models.library.Subject;
import org.apache.openjpa.util.IntId;
import org.apache.openjpa.util.InternalException;

@Entity
@Table(name="LIBBOOK")
public class Book
implements PersistenceCapable {
    private static final int WEEKS_TIME_MS = 604800000;
    @Id
    @GeneratedValue
    private int oid;
    @Basic
    private String title;
    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dueDate;
    @ManyToOne
    private Borrower borrower;
    @ManyToMany(mappedBy="books", cascade={CascadeType.PERSIST})
    private Set<Subject> subjects;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Lorg$apache$openjpa$persistence$models$library$Borrower;
    static /* synthetic */ Class class$Ljava$util$Date;
    static /* synthetic */ Class class$Ljava$util$Set;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Lorg$apache$openjpa$persistence$models$library$Book;
    private transient Object pcDetachedState;

    protected Book() {
    }

    public Book(String title) {
        if (title != null) {
            title = title.trim();
        }
        if (title == null || title.length() <= 0) {
            throw new IllegalArgumentException("Title cannot be empty or null");
        }
        this.title = title;
        this.subjects = new HashSet<Subject>();
    }

    public String getTitle() {
        return Book.pcGettitle(this);
    }

    public Borrower getBorrower() {
        return Book.pcGetborrower(this);
    }

    void setBorrower(Borrower borrower) {
        if (borrower != null) {
            Book.pcSetborrower(this, borrower);
            long one_week_out = System.currentTimeMillis() + 604800000L;
            Book.pcSetdueDate(this, new Date(one_week_out));
        }
    }

    void clearBorrower() {
        Book.pcSetborrower(this, null);
        Book.pcSetdueDate(this, null);
    }

    public Date getDueDate() {
        return Book.pcGetdueDate(this);
    }

    public boolean addSubject(Subject subject) {
        boolean retv = false;
        if (subject != null && subject.addBook(this)) {
            retv = true;
            Book.pcGetsubjects(this).add(subject);
        }
        return retv;
    }

    public boolean removeSubject(Subject subject) {
        boolean retv = false;
        if (subject != null && subject.removeBook(this)) {
            retv = true;
            Book.pcGetsubjects(this).remove(subject);
        }
        return retv;
    }

    public List<Subject> getSubjects() {
        if (Book.pcGetsubjects(this) == null) {
            return null;
        }
        return new ArrayList<Subject>(Book.pcGetsubjects(this));
    }

    public String toString() {
        return "book [" + Book.pcGetoid(this) + "] \"" + Book.pcGettitle(this) + "\"" + (Book.pcGetdueDate(this) == null ? "" : " due back: " + Book.pcGetdueDate(this));
    }

    public int hashCode() {
        return Book.pcGetoid(this);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (Book.pcGetoid(this) == 0) {
            return false;
        }
        if (other instanceof Book) {
            Book ob = (Book)other;
            return Book.pcGetoid(this) == Book.pcGetoid(ob);
        }
        return false;
    }

    public int pcGetEnhancementContractVersion() {
        return 196634845;
    }

    static {
        pcFieldNames = new String[]{"borrower", "dueDate", "oid", "subjects", "title"};
        Class[] classArray = new Class[5];
        Class clazz = class$Lorg$apache$openjpa$persistence$models$library$Borrower != null ? class$Lorg$apache$openjpa$persistence$models$library$Borrower : (class$Lorg$apache$openjpa$persistence$models$library$Borrower = Book.class$("org.apache.openjpa.persistence.models.library.Borrower"));
        classArray[0] = clazz;
        Class clazz2 = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = Book.class$("java.util.Date"));
        classArray[1] = clazz2;
        classArray[2] = Integer.TYPE;
        Class clazz3 = class$Ljava$util$Set != null ? class$Ljava$util$Set : (class$Ljava$util$Set = Book.class$("java.util.Set"));
        classArray[3] = clazz3;
        Class clazz4 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Book.class$("java.lang.String"));
        classArray[4] = clazz4;
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{10, 26, 26, 5, 26};
        Class clazz5 = class$Lorg$apache$openjpa$persistence$models$library$Book != null ? class$Lorg$apache$openjpa$persistence$models$library$Book : (class$Lorg$apache$openjpa$persistence$models$library$Book = Book.class$("org.apache.openjpa.persistence.models.library.Book"));
        PCRegistry.register((Class)clazz5, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"Book", (PersistenceCapable)new Book());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this.borrower = null;
        this.dueDate = null;
        this.oid = 0;
        this.subjects = null;
        this.title = null;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        Book book = new Book();
        if (bl) {
            book.pcClearFields();
        }
        book.pcStateManager = stateManager;
        book.pcCopyKeyFieldsFromObjectId(object);
        return book;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        Book book = new Book();
        if (bl) {
            book.pcClearFields();
        }
        book.pcStateManager = stateManager;
        return book;
    }

    protected static int pcGetManagedFieldCount() {
        return 5;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.borrower = (Borrower)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.dueDate = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.oid = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.subjects = (Set)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.title = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.borrower);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.dueDate);
                return;
            }
            case 2: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.oid);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.subjects);
                return;
            }
            case 4: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.title);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(Book book, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.borrower = book.borrower;
                return;
            }
            case 1: {
                this.dueDate = book.dueDate;
                return;
            }
            case 2: {
                this.oid = book.oid;
                return;
            }
            case 3: {
                this.subjects = book.subjects;
                return;
            }
            case 4: {
                this.title = book.title;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        Book book = (Book)object;
        if (book.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(book, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        IntId intId = (IntId)object;
        fieldConsumer.storeIntField(2 + pcInheritedFieldCount, intId.getId());
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        IntId intId = (IntId)object;
        this.oid = intId.getId();
    }

    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Lorg$apache$openjpa$persistence$models$library$Book != null ? class$Lorg$apache$openjpa$persistence$models$library$Book : (class$Lorg$apache$openjpa$persistence$models$library$Book = Book.class$("org.apache.openjpa.persistence.models.library.Book"));
        return new IntId(clazz, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        Class clazz = class$Lorg$apache$openjpa$persistence$models$library$Book != null ? class$Lorg$apache$openjpa$persistence$models$library$Book : (class$Lorg$apache$openjpa$persistence$models$library$Book = Book.class$("org.apache.openjpa.persistence.models.library.Book"));
        return new IntId(clazz, this.oid);
    }

    private static final Borrower pcGetborrower(Book book) {
        if (book.pcStateManager == null) {
            return book.borrower;
        }
        int n = pcInheritedFieldCount + 0;
        book.pcStateManager.accessingField(n);
        return book.borrower;
    }

    private static final void pcSetborrower(Book book, Borrower borrower) {
        if (book.pcStateManager == null) {
            book.borrower = borrower;
            return;
        }
        book.pcStateManager.settingObjectField((PersistenceCapable)book, pcInheritedFieldCount + 0, (Object)book.borrower, (Object)borrower, 0);
    }

    private static final Date pcGetdueDate(Book book) {
        if (book.pcStateManager == null) {
            return book.dueDate;
        }
        int n = pcInheritedFieldCount + 1;
        book.pcStateManager.accessingField(n);
        return book.dueDate;
    }

    private static final void pcSetdueDate(Book book, Date date) {
        if (book.pcStateManager == null) {
            book.dueDate = date;
            return;
        }
        book.pcStateManager.settingObjectField((PersistenceCapable)book, pcInheritedFieldCount + 1, (Object)book.dueDate, (Object)date, 0);
    }

    private static final int pcGetoid(Book book) {
        if (book.pcStateManager == null) {
            return book.oid;
        }
        int n = pcInheritedFieldCount + 2;
        book.pcStateManager.accessingField(n);
        return book.oid;
    }

    private static final void pcSetoid(Book book, int n) {
        if (book.pcStateManager == null) {
            book.oid = n;
            return;
        }
        book.pcStateManager.settingIntField((PersistenceCapable)book, pcInheritedFieldCount + 2, book.oid, n, 0);
    }

    private static final Set pcGetsubjects(Book book) {
        if (book.pcStateManager == null) {
            return book.subjects;
        }
        int n = pcInheritedFieldCount + 3;
        book.pcStateManager.accessingField(n);
        return book.subjects;
    }

    private static final void pcSetsubjects(Book book, Set set) {
        if (book.pcStateManager == null) {
            book.subjects = set;
            return;
        }
        book.pcStateManager.settingObjectField((PersistenceCapable)book, pcInheritedFieldCount + 3, book.subjects, (Object)set, 0);
    }

    private static final String pcGettitle(Book book) {
        if (book.pcStateManager == null) {
            return book.title;
        }
        int n = pcInheritedFieldCount + 4;
        book.pcStateManager.accessingField(n);
        return book.title;
    }

    private static final void pcSettitle(Book book, String string) {
        if (book.pcStateManager == null) {
            book.title = string;
            return;
        }
        book.pcStateManager.settingStringField((PersistenceCapable)book, pcInheritedFieldCount + 4, book.title, string, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (this.oid != 0) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        return Boolean.FALSE;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }
}

