/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.models.company;

import java.beans.ExceptionListener;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.XMLDecoder;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.persistence.EntityManagerFactory;
import junit.framework.AssertionFailedError;
import org.apache.openjpa.persistence.models.company.IAddress;
import org.apache.openjpa.persistence.models.company.ICompany;
import org.apache.openjpa.persistence.models.company.ICustomer;
import org.apache.openjpa.persistence.models.company.IEmployee;
import org.apache.openjpa.persistence.models.company.IFullTimeEmployee;
import org.apache.openjpa.persistence.models.company.ILineItem;
import org.apache.openjpa.persistence.models.company.IPartTimeEmployee;
import org.apache.openjpa.persistence.models.company.IPerson;
import org.apache.openjpa.persistence.models.company.IProduct;
import org.apache.openjpa.persistence.models.company.IProductOrder;
import org.apache.openjpa.persistence.test.SingleEMTestCase;

public abstract class CompanyModelTest
extends SingleEMTestCase {
    private static Map<Class, Class> factoryClasses;
    private Map<Class, Class> impls;

    @Override
    public void setUp() {
        this.impls = new HashMap<Class, Class>();
        this.impls.put(IAddress.class, this.localClass("Address"));
        this.impls.put(ICompany.class, this.localClass("Company"));
        this.impls.put(ICustomer.class, this.localClass("Customer"));
        this.impls.put(IPerson.class, this.localClass("Person"));
        this.impls.put(IEmployee.class, this.localClass("Employee"));
        this.impls.put(IFullTimeEmployee.class, this.localClass("FullTimeEmployee"));
        this.impls.put(ILineItem.class, this.localClass("LineItem"));
        this.impls.put(IProductOrder.class, this.localClass("ProductOrder"));
        this.impls.put(IPartTimeEmployee.class, this.localClass("PartTimeEmployee"));
        this.impls.put(IProduct.class, this.localClass("Product"));
        super.setUp(this.impls.values().toArray(new Class[this.impls.size()]));
        this.checkModel();
    }

    @Override
    public void tearDown() throws Exception {
        this.impls.clear();
        this.impls = null;
        factoryClasses = null;
        super.tearDown();
    }

    private Class localClass(String name) {
        String pkg = ((Object)((Object)this)).getClass().getPackage().getName();
        try {
            return Class.forName(pkg + "." + name);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public void testBasicQueries() throws Exception {
        for (Class c : this.impls.values()) {
            for (PropertyDescriptor pd : Introspector.getBeanInfo(c).getPropertyDescriptors()) {
                if (pd.getWriteMethod() == null) continue;
                TreeSet<String> queries = new TreeSet<String>();
                this.getBasicQueries(queries, pd, "x.");
                StringBuilder str = new StringBuilder();
                for (String query : queries) {
                    this.find(c, "where " + query, new Object[0]);
                    str.append(str.length() > 0 ? " or " : "").append(query);
                }
                this.find(c, "where " + str, new Object[0]);
            }
        }
    }

    void getBasicQueries(Set<String> queries, PropertyDescriptor pd, String prefix) throws Exception {
        if (prefix.split("\\.").length > 2) {
            return;
        }
        Class<Object> type = pd.getPropertyType();
        String name = prefix + pd.getName();
        if (!queries.add(name + " is not null")) {
            return;
        }
        queries.add(name + " is null");
        if (type.isAssignableFrom(Number.class) || type == Integer.TYPE || type == Double.TYPE || type == Float.TYPE || type == Long.TYPE || type == Short.TYPE) {
            queries.add(name + " = 0");
            queries.add(name + " <> 0");
            queries.add(name + " > 0");
            queries.add(name + " < 0");
            queries.add(name + " >= 0");
            queries.add(name + " <= 0");
            queries.add("sqrt(" + name + ") <> 0");
            queries.add("abs(" + name + ") <> 0");
        }
        if (type.isAssignableFrom(Collection.class)) {
            queries.add(name + " IS EMPTY");
            queries.add(name + " IS NOT EMPTY");
            queries.add("size(" + name + ") <> 0");
        }
        if (type.isAssignableFrom(String.class)) {
            queries.add("lower(" + name + ") = 'x'");
            queries.add("upper(" + name + ") = 'x'");
            queries.add("concat(" + name + ", " + name + ") = 'x'");
            queries.add("substring(" + name + ", 1, 2) = 'x'");
            queries.add("length(" + name + ") > 0");
            queries.add("locate(" + name + ", 'x', 1) > 0");
            queries.add("trim(leading ' ' from " + name + ") = 'x'");
        }
        if (type.isAssignableFrom(Date.class)) {
            queries.add(name + " <> CURRENT_TIMESTAMP");
        }
        if (this.impls.containsKey(type) || this.impls.containsValue(type)) {
            for (PropertyDescriptor desc : Introspector.getBeanInfo(type).getPropertyDescriptors()) {
                if (desc.getWriteMethod() == null || name.endsWith("." + desc.getName() + ".")) continue;
                this.getBasicQueries(queries, desc, name + ".");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkModel() {
        try {
            this.verifyModel();
        }
        catch (AssertionFailedError e) {
            this.clear((EntityManagerFactory)this.emf, this.impls.values().toArray(new Class[this.impls.size()]));
            factoryClasses = this.impls;
            try {
                final LinkedList exceptions = new LinkedList();
                XMLDecoder decoder = new XMLDecoder(CompanyModelTest.class.getResourceAsStream("companies.xml"));
                decoder.setExceptionListener(new ExceptionListener(){

                    @Override
                    public void exceptionThrown(Exception e) {
                        exceptions.add(e);
                    }
                });
                Collection obs = (Collection)decoder.readObject();
                if (exceptions.size() > 0) {
                    throw new IllegalStateException((Throwable)exceptions.get(0));
                }
                CompanyModelTest.assertNotNull((Object)obs);
                this.persist(obs.toArray());
                decoder.close();
            }
            finally {
                factoryClasses = null;
            }
        }
        this.verifyModel();
    }

    int queryCount(Class c, String query, Object ... params) {
        return this.find(c, query, params).size();
    }

    int queryCount(Class c) {
        return this.find(c, null, new Object[0]).size();
    }

    Class impl(Class c) {
        return this.impls.get(c);
    }

    void verifyModel() {
        CompanyModelTest.assertEquals((int)2, (int)this.queryCount(this.impl(ICompany.class)));
        CompanyModelTest.assertEquals((int)11, (int)this.queryCount(this.impl(IAddress.class)));
        CompanyModelTest.assertEquals((int)3, (int)this.queryCount(this.impl(IProduct.class)));
        CompanyModelTest.assertEquals((int)2, (int)this.queryCount(this.impl(IProductOrder.class)));
        CompanyModelTest.assertEquals((int)3, (int)this.queryCount(this.impl(ILineItem.class)));
        CompanyModelTest.assertEquals((int)1, (int)this.queryCount(this.impl(IPartTimeEmployee.class)));
        CompanyModelTest.assertEquals((int)3, (int)this.queryCount(this.impl(IFullTimeEmployee.class)));
        CompanyModelTest.assertEquals((int)4, (int)this.queryCount(this.impl(ICustomer.class)));
        CompanyModelTest.assertEquals((int)3, (int)this.queryCount(this.impl(IAddress.class), "where x.state = 'CA'", new Object[0]));
        CompanyModelTest.assertEquals((int)1, (int)this.queryCount(this.impl(ICompany.class), "where size(x.employees) = 4", new Object[0]));
        CompanyModelTest.assertEquals((int)1, (int)this.queryCount(this.impl(ICompany.class), "where size(x.employees) = 0", new Object[0]));
        CompanyModelTest.assertEquals((int)2, (int)this.queryCount(this.impl(ICustomer.class), "where size(x.orders) = 1", new Object[0]));
        CompanyModelTest.assertEquals((int)1, (int)this.queryCount(this.impl(IProductOrder.class), "where x.shippedDate is null", new Object[0]));
        CompanyModelTest.assertEquals((int)1, (int)this.queryCount(this.impl(IProductOrder.class), "where x.shippedDate is not null", new Object[0]));
        CompanyModelTest.assertEquals((int)1, (int)this.queryCount(this.impl(IEmployee.class), "where x.manager is null", new Object[0]));
        CompanyModelTest.assertEquals((int)2, (int)this.queryCount(this.impl(IEmployee.class), "where x.manager.manager is null", new Object[0]));
        CompanyModelTest.assertEquals((int)1, (int)this.queryCount(this.impl(IEmployee.class), "where x.manager.manager.manager is null", new Object[0]));
        CompanyModelTest.assertEquals((int)2, (int)this.queryCount(this.impl(IPerson.class), "where x.firstName like ?1 and x.lastName like ?1", "M%"));
        CompanyModelTest.assertEquals((int)1, (int)this.queryCount(this.impl(IPerson.class), "where x.homeAddress.state = 'CA'", new Object[0]));
    }

    public static Object create(Class intf) throws InstantiationException, IllegalAccessException {
        return factoryClasses.get(intf).newInstance();
    }
}

