/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.meta;

import javax.persistence.AttributeConverter;
import javax.persistence.Converter;
import javax.persistence.Entity;
import javax.persistence.Id;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.StringId;

public class TestMetamodelWithEnum
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        super.setUp("openjpa.RuntimeUnenhancedClasses", "unsupported", "openjpa.DynamicEnhancementAgent", "false", Main.class, AttributeConverterImpl.class);
    }

    public void testEnsureEnumDontFail() {
        TestMetamodelWithEnum.assertNotNull((Object)this.emf.getMetamodel());
    }

    public static enum MyEnum {
        A;

    }

    @Entity
    public static class Main
    implements PersistenceCapable {
        @Id
        private String id;
        private MyEnum enumColumn;
        private static int pcInheritedFieldCount;
        private static String[] pcFieldNames;
        private static Class[] pcFieldTypes;
        private static byte[] pcFieldFlags;
        private static Class pcPCSuperclass;
        protected transient StateManager pcStateManager;
        static /* synthetic */ Class class$Lorg$apache$openjpa$persistence$meta$TestMetamodelWithEnum$MyEnum;
        static /* synthetic */ Class class$Ljava$lang$String;
        static /* synthetic */ Class class$Lorg$apache$openjpa$persistence$meta$TestMetamodelWithEnum$Main;
        private transient Object pcDetachedState;

        public String getId() {
            return Main.pcGetid(this);
        }

        public void setId(String id) {
            Main.pcSetid(this, id);
        }

        public MyEnum getEnumColumn() {
            return Main.pcGetenumColumn(this);
        }

        public void setEnumColumn(MyEnum enumColumn) {
            Main.pcSetenumColumn(this, enumColumn);
        }

        public int pcGetEnhancementContractVersion() {
            return 196634845;
        }

        static {
            pcFieldNames = new String[]{"enumColumn", "id"};
            Class[] classArray = new Class[2];
            Class clazz = class$Lorg$apache$openjpa$persistence$meta$TestMetamodelWithEnum$MyEnum != null ? class$Lorg$apache$openjpa$persistence$meta$TestMetamodelWithEnum$MyEnum : (class$Lorg$apache$openjpa$persistence$meta$TestMetamodelWithEnum$MyEnum = Main.class$("org.apache.openjpa.persistence.meta.TestMetamodelWithEnum$MyEnum"));
            classArray[0] = clazz;
            Class clazz2 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Main.class$("java.lang.String"));
            classArray[1] = clazz2;
            pcFieldTypes = classArray;
            pcFieldFlags = new byte[]{26, 26};
            Class clazz3 = class$Lorg$apache$openjpa$persistence$meta$TestMetamodelWithEnum$Main != null ? class$Lorg$apache$openjpa$persistence$meta$TestMetamodelWithEnum$Main : (class$Lorg$apache$openjpa$persistence$meta$TestMetamodelWithEnum$Main = Main.class$("org.apache.openjpa.persistence.meta.TestMetamodelWithEnum$Main"));
            PCRegistry.register((Class)clazz3, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"TestMetamodelWithEnum$Main", (PersistenceCapable)new Main());
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        protected void pcClearFields() {
            this.enumColumn = null;
            this.id = null;
        }

        public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
            Main main = new Main();
            if (bl) {
                main.pcClearFields();
            }
            main.pcStateManager = stateManager;
            main.pcCopyKeyFieldsFromObjectId(object);
            return main;
        }

        public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
            Main main = new Main();
            if (bl) {
                main.pcClearFields();
            }
            main.pcStateManager = stateManager;
            return main;
        }

        protected static int pcGetManagedFieldCount() {
            return 2;
        }

        public void pcReplaceField(int n) {
            int n2 = n - pcInheritedFieldCount;
            if (n2 < 0) {
                throw new IllegalArgumentException();
            }
            switch (n2) {
                case 0: {
                    this.enumColumn = (MyEnum)((Object)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n));
                    return;
                }
                case 1: {
                    this.id = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                    return;
                }
            }
            throw new IllegalArgumentException();
        }

        public void pcReplaceFields(int[] nArray) {
            int n = 0;
            while (n < nArray.length) {
                this.pcReplaceField(nArray[n]);
                ++n;
            }
        }

        public void pcProvideField(int n) {
            int n2 = n - pcInheritedFieldCount;
            if (n2 < 0) {
                throw new IllegalArgumentException();
            }
            switch (n2) {
                case 0: {
                    this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.enumColumn);
                    return;
                }
                case 1: {
                    this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.id);
                    return;
                }
            }
            throw new IllegalArgumentException();
        }

        public void pcProvideFields(int[] nArray) {
            int n = 0;
            while (n < nArray.length) {
                this.pcProvideField(nArray[n]);
                ++n;
            }
        }

        protected void pcCopyField(Main main, int n) {
            int n2 = n - pcInheritedFieldCount;
            if (n2 < 0) {
                throw new IllegalArgumentException();
            }
            switch (n2) {
                case 0: {
                    this.enumColumn = main.enumColumn;
                    return;
                }
                case 1: {
                    this.id = main.id;
                    return;
                }
            }
            throw new IllegalArgumentException();
        }

        public void pcCopyFields(Object object, int[] nArray) {
            Main main = (Main)object;
            if (main.pcStateManager != this.pcStateManager) {
                throw new IllegalArgumentException();
            }
            if (this.pcStateManager == null) {
                throw new IllegalStateException();
            }
            int n = 0;
            while (n < nArray.length) {
                this.pcCopyField(main, nArray[n]);
                ++n;
            }
        }

        public Object pcGetGenericContext() {
            if (this.pcStateManager == null) {
                return null;
            }
            return this.pcStateManager.getGenericContext();
        }

        public Object pcFetchObjectId() {
            if (this.pcStateManager == null) {
                return null;
            }
            return this.pcStateManager.fetchObjectId();
        }

        public boolean pcIsDeleted() {
            if (this.pcStateManager == null) {
                return false;
            }
            return this.pcStateManager.isDeleted();
        }

        public boolean pcIsDirty() {
            if (this.pcStateManager == null) {
                return false;
            }
            StateManager stateManager = this.pcStateManager;
            RedefinitionHelper.dirtyCheck((StateManager)stateManager);
            return stateManager.isDirty();
        }

        public boolean pcIsNew() {
            if (this.pcStateManager == null) {
                return false;
            }
            return this.pcStateManager.isNew();
        }

        public boolean pcIsPersistent() {
            if (this.pcStateManager == null) {
                return false;
            }
            return this.pcStateManager.isPersistent();
        }

        public boolean pcIsTransactional() {
            if (this.pcStateManager == null) {
                return false;
            }
            return this.pcStateManager.isTransactional();
        }

        public boolean pcSerializing() {
            if (this.pcStateManager == null) {
                return false;
            }
            return this.pcStateManager.serializing();
        }

        public void pcDirty(String string) {
            if (this.pcStateManager == null) {
                return;
            }
            this.pcStateManager.dirty(string);
        }

        public StateManager pcGetStateManager() {
            return this.pcStateManager;
        }

        public Object pcGetVersion() {
            if (this.pcStateManager == null) {
                return null;
            }
            return this.pcStateManager.getVersion();
        }

        public void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
            if (this.pcStateManager != null) {
                this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
                return;
            }
            this.pcStateManager = stateManager;
        }

        public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
            throw new InternalException();
        }

        public void pcCopyKeyFieldsToObjectId(Object object) {
            throw new InternalException();
        }

        public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
            StringId stringId = (StringId)object;
            fieldConsumer.storeStringField(1 + pcInheritedFieldCount, stringId.getId());
        }

        public void pcCopyKeyFieldsFromObjectId(Object object) {
            StringId stringId = (StringId)object;
            this.id = stringId.getId();
        }

        public Object pcNewObjectIdInstance(Object object) {
            Class clazz = class$Lorg$apache$openjpa$persistence$meta$TestMetamodelWithEnum$Main != null ? class$Lorg$apache$openjpa$persistence$meta$TestMetamodelWithEnum$Main : (class$Lorg$apache$openjpa$persistence$meta$TestMetamodelWithEnum$Main = Main.class$("org.apache.openjpa.persistence.meta.TestMetamodelWithEnum$Main"));
            return new StringId(clazz, (String)object);
        }

        public Object pcNewObjectIdInstance() {
            Class clazz = class$Lorg$apache$openjpa$persistence$meta$TestMetamodelWithEnum$Main != null ? class$Lorg$apache$openjpa$persistence$meta$TestMetamodelWithEnum$Main : (class$Lorg$apache$openjpa$persistence$meta$TestMetamodelWithEnum$Main = Main.class$("org.apache.openjpa.persistence.meta.TestMetamodelWithEnum$Main"));
            return new StringId(clazz, this.id);
        }

        private static final MyEnum pcGetenumColumn(Main main) {
            if (main.pcStateManager == null) {
                return main.enumColumn;
            }
            int n = pcInheritedFieldCount + 0;
            main.pcStateManager.accessingField(n);
            return main.enumColumn;
        }

        private static final void pcSetenumColumn(Main main, MyEnum myEnum) {
            if (main.pcStateManager == null) {
                main.enumColumn = myEnum;
                return;
            }
            main.pcStateManager.settingObjectField((PersistenceCapable)main, pcInheritedFieldCount + 0, (Object)main.enumColumn, (Object)myEnum, 0);
        }

        private static final String pcGetid(Main main) {
            if (main.pcStateManager == null) {
                return main.id;
            }
            int n = pcInheritedFieldCount + 1;
            main.pcStateManager.accessingField(n);
            return main.id;
        }

        private static final void pcSetid(Main main, String string) {
            if (main.pcStateManager == null) {
                main.id = string;
                return;
            }
            main.pcStateManager.settingStringField((PersistenceCapable)main, pcInheritedFieldCount + 1, main.id, string, 0);
        }

        public Boolean pcIsDetached() {
            if (this.pcStateManager != null) {
                if (this.pcStateManager.isDetached()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
                return Boolean.TRUE;
            }
            if (!this.pcisDetachedStateDefinitive()) {
                return null;
            }
            return Boolean.FALSE;
        }

        private boolean pcisDetachedStateDefinitive() {
            return false;
        }

        public Object pcGetDetachedState() {
            return this.pcDetachedState;
        }

        public void pcSetDetachedState(Object object) {
            this.pcDetachedState = object;
        }
    }

    @Converter
    public static class AttributeConverterImpl
    implements AttributeConverter<MyEnum, String> {
        public String convertToDatabaseColumn(MyEnum myEnum) {
            return myEnum.name();
        }

        public MyEnum convertToEntityAttribute(String s) {
            return MyEnum.valueOf(s);
        }
    }
}

