/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.meta;

import java.util.Collection;
import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.meta.QueryMetaData;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.meta.MdrTestEntity;
import org.apache.openjpa.persistence.test.AbstractPersistenceTestCase;
import org.apache.openjpa.persistence.xmlmapping.entities.Customer;
import org.apache.openjpa.persistence.xmlmapping.entities.EAddress;
import org.apache.openjpa.persistence.xmlmapping.entities.Order;
import org.apache.openjpa.persistence.xmlmapping.xmlbindings.myaddress.Address;

public class TestMetaDataRepository
extends AbstractPersistenceTestCase {
    private final String PU_NAME = "mdr-pu";

    public void setUp() throws Exception {
        super.setUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPreloadBasic() {
        OpenJPAEntityManagerFactorySPI emf = null;
        try {
            emf = this.createNamedEMF("mdr-pu", "openjpa.MetaDataRepository", "Preload=true");
            MetaDataRepository mdr = emf.getConfiguration().getMetaDataRepositoryInstance();
            ClassMetaData metadata = mdr.getCachedMetaData(MdrTestEntity.class);
            TestMetaDataRepository.assertNotNull((Object)metadata);
            Collection aliases = mdr.getAliasNames();
            TestMetaDataRepository.assertTrue((boolean)aliases.contains("MdrTestEntity"));
            QueryMetaData query = mdr.getCachedQueryMetaData("query");
            TestMetaDataRepository.assertNotNull((Object)query);
        }
        catch (Throwable throwable) {
            this.closeEMF((EntityManagerFactory)emf);
            throw throwable;
        }
        this.closeEMF((EntityManagerFactory)emf);
    }

    public void testPreloadCleanUp() {
        OpenJPAEntityManagerFactorySPI emf = null;
        emf = this.createNamedEMF("mdr-pu", "openjpa.MetaDataRepository", "Preload=true");
        MetaDataRepository repo = emf.getConfiguration().getMetaDataRepositoryInstance();
        emf.createEntityManager();
        this.closeEMF((EntityManagerFactory)emf);
        TestMetaDataRepository.assertFalse((String)"The PCRegistry should no longer reference the MetaDataRepository.", (boolean)PCRegistry.removeRegisterClassListener((PCRegistry.RegisterClassListener)repo));
    }

    public void testXmlMappingPreload() {
        OpenJPAEntityManagerFactorySPI emf = null;
        try {
            emf = this.createNamedEMF("test", "openjpa.MetaDataRepository", "Preload=true", Customer.class, Customer.CustomerKey.class, Order.class, EAddress.class);
            MetaDataRepository mdr = emf.getConfiguration().getMetaDataRepositoryInstance();
            TestMetaDataRepository.assertNotNull((Object)mdr.getCachedXMLMetaData(Address.class));
            TestMetaDataRepository.assertNull((Object)mdr.getCachedXMLMetaData(Order.class));
        }
        catch (Throwable throwable) {
            this.closeEMF((EntityManagerFactory)emf);
            throw throwable;
        }
        this.closeEMF((EntityManagerFactory)emf);
    }

    public void testPreloadConfiguration() {
        OpenJPAEntityManagerFactorySPI emf = this.createNamedEMF("mdr-pu", "openjpa.MetaDataRepository", "preload=true");
        TestMetaDataRepository.assertTrue((boolean)MetaDataRepository.needsPreload((OpenJPAConfiguration)emf.getConfiguration()));
        emf.close();
        emf = this.createNamedEMF("mdr-pu", "openjpa.MetaDataRepository", "Preload=true");
        TestMetaDataRepository.assertTrue((boolean)MetaDataRepository.needsPreload((OpenJPAConfiguration)emf.getConfiguration()));
        emf.close();
    }
}

