/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.meta;

import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.persistence.meta.common.apps.FieldOrderPC;
import org.apache.openjpa.persistence.meta.common.apps.FieldOrderPCSubclass;

public class TestFieldDeclarationOrder
extends AbstractTestCase {
    public TestFieldDeclarationOrder(String test) {
        super(test, "metacactusapp");
    }

    public void testSubclass() {
        ClassMetaData meta = JPAFacadeHelper.getMetaData((EntityManagerFactory)this.getEmf(), FieldOrderPCSubclass.class);
        FieldMetaData[] fmds = meta.getFieldsInListingOrder();
        TestFieldDeclarationOrder.assertEquals((int)11, (int)fmds.length);
        TestFieldDeclarationOrder.assertEquals((String)"firstField", (String)fmds[0].getName());
        TestFieldDeclarationOrder.assertEquals((String)"secondField", (String)fmds[1].getName());
        TestFieldDeclarationOrder.assertEquals((String)"thirdField", (String)fmds[2].getName());
        TestFieldDeclarationOrder.assertEquals((String)"unmanagedField", (String)fmds[3].getName());
        TestFieldDeclarationOrder.assertEquals((String)"intField", (String)fmds[4].getName());
        TestFieldDeclarationOrder.assertEquals((String)"oneToOneField", (String)fmds[5].getName());
        TestFieldDeclarationOrder.assertEquals((String)"sub1", (String)fmds[6].getName());
        TestFieldDeclarationOrder.assertEquals((String)"sub2", (String)fmds[7].getName());
        TestFieldDeclarationOrder.assertEquals((String)"sub3", (String)fmds[8].getName());
        TestFieldDeclarationOrder.assertEquals((String)"unmanagedSubField", (String)fmds[9].getName());
        TestFieldDeclarationOrder.assertEquals((String)"undeclaredSubField", (String)fmds[10].getName());
    }

    public void testSuperclass() {
        ClassMetaData meta = JPAFacadeHelper.getMetaData((EntityManagerFactory)this.getEmf(), FieldOrderPC.class);
        FieldMetaData[] fmds = meta.getFieldsInListingOrder();
        TestFieldDeclarationOrder.assertEquals((int)6, (int)fmds.length);
        TestFieldDeclarationOrder.assertEquals((String)"firstField", (String)fmds[0].getName());
        TestFieldDeclarationOrder.assertEquals((String)"secondField", (String)fmds[1].getName());
        TestFieldDeclarationOrder.assertEquals((String)"thirdField", (String)fmds[2].getName());
        TestFieldDeclarationOrder.assertEquals((String)"unmanagedField", (String)fmds[3].getName());
        TestFieldDeclarationOrder.assertEquals((String)"intField", (String)fmds[4].getName());
        TestFieldDeclarationOrder.assertEquals((String)"oneToOneField", (String)fmds[5].getName());
    }
}

