/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.meta;

import java.util.List;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.openjpa.persistence.ArgumentException;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.persistence.meta.common.apps.ExternalValues;

public class TestExternalValues
extends AbstractTestCase {
    public TestExternalValues(String test) {
        super(test, "metacactusapp");
    }

    public void setUp() throws Exception {
        this.deleteAll(ExternalValues.class);
    }

    public void testInsert() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        ExternalValues pc = new ExternalValues();
        pc.setBooleanToShort(true);
        pc.setByteToDouble((byte)4);
        pc.setIntToFloat(4);
        pc.setLongToChar(4L);
        pc.setShortToString((short)4);
        pc.setFloatToBoolean(4.5f);
        pc.setDoubleToByte(4.5);
        pc.setCharToInt('f');
        pc.setStringToLong("foo");
        pm.persist((Object)pc);
        Object oid = pm.getObjectId((Object)pc);
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.currentEntityManager();
        pc = (ExternalValues)pm.find(ExternalValues.class, oid);
        TestExternalValues.assertTrue((boolean)pc.getBooleanToShort());
        TestExternalValues.assertEquals((byte)4, (byte)pc.getByteToDouble());
        TestExternalValues.assertEquals((int)4, (int)pc.getIntToFloat());
        TestExternalValues.assertEquals((long)4L, (long)pc.getLongToChar());
        TestExternalValues.assertEquals((short)4, (short)pc.getShortToString());
        TestExternalValues.assertTrue((4.5f == pc.getFloatToBoolean() ? 1 : 0) != 0);
        TestExternalValues.assertTrue((4.5 == pc.getDoubleToByte() ? 1 : 0) != 0);
        TestExternalValues.assertEquals((char)'f', (char)pc.getCharToInt());
        TestExternalValues.assertEquals((String)"foo", (String)pc.getStringToLong());
        this.endEm((EntityManager)pm);
    }

    public void testComplexStrings() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        ExternalValues pc = new ExternalValues();
        pc.setShortToString((short)3);
        pc.setStringToLong("long string");
        pm.persist((Object)pc);
        Object oid = pm.getObjectId((Object)pc);
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.currentEntityManager();
        pc = (ExternalValues)pm.find(ExternalValues.class, oid);
        TestExternalValues.assertEquals((int)3, (int)pc.getShortToString());
        this.endEm((EntityManager)pm);
    }

    public void testAllNull() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        ExternalValues pc = new ExternalValues();
        pm.persist((Object)pc);
        Object oid = pm.getObjectId((Object)pc);
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.currentEntityManager();
        pc = (ExternalValues)pm.find(ExternalValues.class, oid);
        this.endEm((EntityManager)pm);
    }

    public void testPositionalBindingQueryParameterEqualsDeclaredType() {
        UUID uuid = new UUID(1L, 4L);
        this.createInstance(uuid);
        OpenJPAEntityManager em = this.currentEntityManager();
        String jpql = "SELECT p FROM ExternalValues p WHERE p.uuid=?1";
        List result = em.createQuery(jpql).setParameter(1, (Object)uuid).getResultList();
        TestExternalValues.assertFalse((boolean)result.isEmpty());
        for (ExternalValues x : result) {
            TestExternalValues.assertEquals((Object)uuid, (Object)x.getUuid());
            TestExternalValues.assertEquals((Object)uuid, (Object)x.getUuid2());
        }
    }

    public void testNamedBindingQueryParameterEqualsDeclaredType() {
        UUID uuid = new UUID(2L, 4L);
        this.createInstance(uuid);
        OpenJPAEntityManager em = this.currentEntityManager();
        String jpql = "SELECT p FROM ExternalValues p WHERE p.uuid=:uuid";
        List result = em.createQuery(jpql).setParameter("uuid", (Object)uuid).getResultList();
        TestExternalValues.assertFalse((boolean)result.isEmpty());
        for (ExternalValues pc : result) {
            TestExternalValues.assertEquals((Object)uuid, (Object)pc.getUuid());
            TestExternalValues.assertEquals((Object)uuid, (Object)pc.getUuid2());
        }
    }

    public void testPositionalBindingQueryParameterNotEqualsExternalizedType() {
        UUID uuid = new UUID(1L, 4L);
        this.createInstance(uuid);
        OpenJPAEntityManager em = this.currentEntityManager();
        String jpql = "SELECT p FROM ExternalValues p WHERE p.uuid=?1";
        Query query = em.createQuery(jpql).setParameter(1, (Object)uuid.toString());
        try {
            query.getResultList();
            TestExternalValues.fail((String)"Expected ArgumentException");
        }
        catch (ArgumentException argumentException) {
            // empty catch block
        }
    }

    public void testNamedBindingQueryParameterNotEqualsExternalizedType() {
        UUID uuid = new UUID(2L, 4L);
        this.createInstance(uuid);
        OpenJPAEntityManager em = this.currentEntityManager();
        String jpql = "SELECT p FROM ExternalValues p WHERE p.uuid=:uuid";
        Query query = em.createQuery(jpql).setParameter("uuid", (Object)uuid.toString());
        try {
            query.getResultList();
            TestExternalValues.fail((String)"Expected ArgumentException");
        }
        catch (ArgumentException argumentException) {
            // empty catch block
        }
    }

    private void createInstance(UUID uuid) {
        OpenJPAEntityManager em = this.currentEntityManager();
        em.getTransaction().begin();
        ExternalValues pc = new ExternalValues();
        pc.setUuid(uuid);
        pc.setUuid2(uuid);
        em.persist((Object)pc);
        em.getTransaction().commit();
        em.clear();
    }
}

