/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.merge;

import java.sql.Date;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.merge.LineItem;
import org.apache.openjpa.persistence.merge.LineItemPK;
import org.apache.openjpa.persistence.merge.Order;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestMultipleMerge
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        this.setUp("openjpa.Compatibility", "NonDefaultMappingAllowed=true", CLEAR_TABLES, Order.class, LineItemPK.class, LineItem.class);
    }

    public void testMultiMerge() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Order order = new Order(1L);
        LineItem item = new LineItem("my product", 44, 4.99f);
        order.addItem(item);
        em.merge((Object)order);
        em.getTransaction().commit();
        em.getTransaction().begin();
        LineItem additional = new LineItem("My second product", 1, 999.95f);
        order.addItem(additional);
        order.setOrderEntry(new Date(System.currentTimeMillis()));
        em.merge((Object)order);
        em.merge((Object)order);
        em.getTransaction().commit();
        em.clear();
        LineItemPK liPK = new LineItemPK();
        liPK.setItemId(1L);
        liPK.setOrderId(1L);
        LineItem li = (LineItem)em.find(LineItem.class, (Object)liPK);
        TestMultipleMerge.assertNotNull((Object)li);
        TestMultipleMerge.assertEquals((String)item.getProductName(), (String)li.getProductName());
        liPK.setItemId(2L);
        liPK.setOrderId(1L);
        li = (LineItem)em.find(LineItem.class, (Object)liPK);
        TestMultipleMerge.assertNotNull((Object)li);
        TestMultipleMerge.assertEquals((String)additional.getProductName(), (String)li.getProductName());
        em.close();
    }
}

