/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.merge;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.merge.model.Car;
import org.apache.openjpa.persistence.merge.model.Label;
import org.apache.openjpa.persistence.merge.model.Label2;
import org.apache.openjpa.persistence.merge.model.Make;
import org.apache.openjpa.persistence.merge.model.Model;
import org.apache.openjpa.persistence.merge.model.ShipPackage;
import org.apache.openjpa.persistence.merge.model.ShipPackage2;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestMergeDetachStateField
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        this.setUp(Label.class, ShipPackage.class, Label2.class, ShipPackage2.class, Car.class, Model.class, Make.class, CLEAR_TABLES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCascadeMergeDetachState() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        try {
            ShipPackage p = new ShipPackage();
            Label l = new Label(p);
            p.setLabel(l);
            em.getTransaction().begin();
            em.persist((Object)l);
            em.getTransaction().commit();
            em.clear();
            TestMergeDetachStateField.assertFalse((boolean)em.contains((Object)l));
            TestMergeDetachStateField.assertFalse((boolean)em.contains((Object)p));
            TestMergeDetachStateField.assertFalse((boolean)em.contains((Object)l.getPackage()));
            TestMergeDetachStateField.assertFalse((boolean)em.contains((Object)p.getLabel()));
            em.getTransaction().begin();
            Label mergedLabel = (Label)em.merge((Object)l);
            TestMergeDetachStateField.assertFalse((mergedLabel == l ? 1 : 0) != 0);
            TestMergeDetachStateField.assertFalse((p == mergedLabel.getPackage() ? 1 : 0) != 0);
            TestMergeDetachStateField.assertTrue((mergedLabel == mergedLabel.getPackage().getLabel() ? 1 : 0) != 0);
            TestMergeDetachStateField.assertFalse((l == mergedLabel.getPackage().getLabel() ? 1 : 0) != 0);
            em.remove((Object)mergedLabel);
            em.getTransaction().commit();
        }
        finally {
            if (em != null) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCascadeMergeDetachState2() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        try {
            ShipPackage2 p = new ShipPackage2();
            Label2 l = new Label2(p);
            p.setLabel2(l);
            em.getTransaction().begin();
            em.persist((Object)p);
            em.getTransaction().commit();
            em.clear();
            TestMergeDetachStateField.assertFalse((boolean)em.contains((Object)l));
            TestMergeDetachStateField.assertFalse((boolean)em.contains((Object)p));
            TestMergeDetachStateField.assertFalse((boolean)em.contains((Object)l.getPackage2()));
            TestMergeDetachStateField.assertFalse((boolean)em.contains((Object)p.getLabel2()));
            em.getTransaction().begin();
            ShipPackage2 mergedPackage = (ShipPackage2)em.merge((Object)p);
            TestMergeDetachStateField.assertFalse((mergedPackage == p ? 1 : 0) != 0);
            TestMergeDetachStateField.assertFalse((l == mergedPackage.getLabel2() ? 1 : 0) != 0);
            TestMergeDetachStateField.assertTrue((mergedPackage == mergedPackage.getLabel2().getPackage2() ? 1 : 0) != 0);
            TestMergeDetachStateField.assertFalse((p == mergedPackage.getLabel2().getPackage2() ? 1 : 0) != 0);
            em.remove((Object)mergedPackage);
            em.getTransaction().commit();
        }
        finally {
            if (em != null) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCascadeMergeDetachStateComplex() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        try {
            Car c1 = new Car();
            Car c2 = new Car();
            Make mk1 = new Make();
            ArrayList<Model> models = new ArrayList<Model>();
            Model md1 = new Model();
            models.add(md1);
            Model md2 = new Model();
            models.add(md2);
            c1.setModel(md1);
            c2.setModel(md2);
            md1.setCar(c1);
            md1.setMake(mk1);
            md2.setCar(c2);
            md1.setMake(mk1);
            mk1.setModels(models);
            em.getTransaction().begin();
            em.persist((Object)c1);
            em.getTransaction().commit();
            Object[] entities = new Object[]{c1, c2, mk1, md1, md2};
            em.clear();
            this.verifyDetached((EntityManager)em, entities);
            em.getTransaction().begin();
            Model mergedModel = (Model)em.merge((Object)md1);
            TestMergeDetachStateField.assertFalse((mergedModel == md1 ? 1 : 0) != 0);
            TestMergeDetachStateField.assertFalse((mergedModel.getMake() == mk1 ? 1 : 0) != 0);
            List<Model> mds = mergedModel.getMake().getModels();
            TestMergeDetachStateField.assertTrue((boolean)mds.contains(mergedModel));
            TestMergeDetachStateField.assertFalse((c1 == mergedModel.getCar() ? 1 : 0) != 0);
            TestMergeDetachStateField.assertTrue((mergedModel.getCar().getModel() == mergedModel ? 1 : 0) != 0);
            em.remove((Object)mergedModel);
            em.getTransaction().commit();
        }
        finally {
            if (em != null) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    private void verifyDetached(EntityManager em, Object[] entities) {
        for (Object entity : entities) {
            Object m;
            TestMergeDetachStateField.assertFalse((boolean)em.contains(entity));
            if (entity instanceof Car) {
                Car c = (Car)entity;
                TestMergeDetachStateField.assertFalse((boolean)em.contains((Object)c.getModel()));
                continue;
            }
            if (entity instanceof Make) {
                m = (Make)entity;
                List<Model> mds = ((Make)m).getModels();
                for (Model md : mds) {
                    TestMergeDetachStateField.assertFalse((boolean)em.contains((Object)md));
                }
                continue;
            }
            if (!(entity instanceof Model)) continue;
            m = (Model)entity;
            TestMergeDetachStateField.assertFalse((boolean)em.contains((Object)((Model)m).getCar()));
            TestMergeDetachStateField.assertFalse((boolean)em.contains((Object)((Model)m).getMake()));
        }
    }
}

