/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.managedinterface;

import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.kernel.AbstractBrokerFactory;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.managedinterface.SimpleManagedInterface;
import org.apache.openjpa.persistence.query.SimpleEntity;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestSimpleManagedInterface
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        this.setUp(SimpleManagedInterface.class, SimpleEntity.class, CLEAR_TABLES);
    }

    public void testMetaDataRepository() {
        AbstractBrokerFactory bf = (AbstractBrokerFactory)JPAFacadeHelper.toBrokerFactory((EntityManagerFactory)this.emf);
        bf.makeReadOnly();
        MetaDataRepository repos = bf.getConfiguration().getMetaDataRepositoryInstance();
        ClassMetaData meta = repos.getMetaData(SimpleManagedInterface.class, null, false);
        TestSimpleManagedInterface.assertNotNull((Object)meta);
        TestSimpleManagedInterface.assertTrue((boolean)meta.isManagedInterface());
        TestSimpleManagedInterface.assertEquals(SimpleManagedInterface.class, (Object)meta.getDescribedType());
    }

    public void testInterfaceImplGeneration() {
        ((AbstractBrokerFactory)JPAFacadeHelper.toBrokerFactory((EntityManagerFactory)this.emf)).makeReadOnly();
        ClassMetaData meta = JPAFacadeHelper.getMetaData((EntityManagerFactory)this.emf, SimpleManagedInterface.class);
        TestSimpleManagedInterface.assertEquals(SimpleManagedInterface.class, (Object)meta.getDescribedType());
    }

    public void testBasicOperations() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        SimpleManagedInterface pc = (SimpleManagedInterface)em.createInstance(SimpleManagedInterface.class);
        pc.setId(17);
        pc.setString("hello!");
        em.getTransaction().begin();
        em.persist((Object)pc);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        pc = (SimpleManagedInterface)em.find(SimpleManagedInterface.class, (Object)17);
        TestSimpleManagedInterface.assertNotNull((Object)pc);
        em.getTransaction().begin();
        pc.setString("updated");
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.remove(em.getReference(SimpleManagedInterface.class, (Object)17));
        em.getTransaction().commit();
        em.close();
    }

    public void testJPQL() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        TestSimpleManagedInterface.assertEquals((int)0, (int)em.createQuery("select o from SimpleManagedInterface o").getResultList().size());
        em.close();
    }
}

