/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.lifecycle;

import javax.persistence.EntityManager;
import org.apache.openjpa.enhance.UnenhancedPropertyAccess;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.PCState;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.test.SingleEMTestCase;

public class TestPessimisticPNonTransToPDirty
extends SingleEMTestCase {
    @Override
    public void setUp() {
        this.setUp(UnenhancedPropertyAccess.class, CLEAR_TABLES, "openjpa.RuntimeUnenhancedClasses", "supported");
        UnenhancedPropertyAccess o = new UnenhancedPropertyAccess();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)o);
        em.getTransaction().commit();
        em.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPNonTransToPDirty() {
        this.em.setOptimistic(false);
        UnenhancedPropertyAccess o = (UnenhancedPropertyAccess)this.em.createQuery("select o from UnenhancedPropertyAccess o").getSingleResult();
        this.em.getTransaction().begin();
        try {
            Broker b = JPAFacadeHelper.toBroker((EntityManager)this.em);
            OpenJPAStateManager sm = b.getStateManager((Object)o);
            TestPessimisticPNonTransToPDirty.assertEquals((Object)PCState.PNONTRANS, (Object)sm.getPCState());
            o.setLazyField("foo");
            TestPessimisticPNonTransToPDirty.assertEquals((Object)PCState.PDIRTY, (Object)sm.getPCState());
        }
        finally {
            this.em.getTransaction().rollback();
        }
    }
}

