/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel.common.apps;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.persistence.FetchAttribute;
import org.apache.openjpa.persistence.FetchGroup;
import org.apache.openjpa.persistence.FetchGroups;
import org.apache.openjpa.persistence.kernel.common.apps.PCFile;
import org.apache.openjpa.util.IntId;
import org.apache.openjpa.util.InternalException;

@Entity
@FetchGroups(value={@FetchGroup(name="name+parent+grandparent", attributes={@FetchAttribute(name="_name"), @FetchAttribute(name="_parent", recursionDepth=2)}), @FetchGroup(name="name+parent+grandparent+greatgrandparent", attributes={@FetchAttribute(name="_name"), @FetchAttribute(name="_parent", recursionDepth=3)}), @FetchGroup(name="name+parent", attributes={@FetchAttribute(name="_name"), @FetchAttribute(name="_parent")}), @FetchGroup(name="allparents", attributes={@FetchAttribute(name="_name"), @FetchAttribute(name="_parent", recursionDepth=-1)}), @FetchGroup(name="name", attributes={@FetchAttribute(name="_name")})})
public class PCDirectory
implements PersistenceCapable {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private int id;
    @Column(name="name_col")
    private String _name;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST})
    private PCDirectory _parent;
    @ManyToMany(cascade={CascadeType.PERSIST})
    private Set<PCDirectory> _children;
    @ManyToMany(cascade={CascadeType.PERSIST})
    private Set<PCFile> _files;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Ljava$util$Set;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Lorg$apache$openjpa$persistence$kernel$common$apps$PCDirectory;
    private transient Object pcDetachedState;

    public PCDirectory() {
    }

    public PCDirectory(String name) {
        this._name = name;
    }

    public int getId() {
        return PCDirectory.pcGetid(this);
    }

    public String getName() {
        return PCDirectory.pcGet_name(this);
    }

    public PCDirectory getParent() {
        return PCDirectory.pcGet_parent(this);
    }

    public Set getChildren() {
        return PCDirectory.pcGet_children(this);
    }

    public Set getFiles() {
        return PCDirectory.pcGet_files(this);
    }

    public void add(PCDirectory dir) {
        if (dir == null) {
            throw new NullPointerException("null directory");
        }
        if (dir.getParent() != null && dir.getParent() != this) {
            throw new IllegalArgumentException(dir + " has a different parent");
        }
        if (PCDirectory.pcGet_children(this) == null) {
            PCDirectory.pcSet_children(this, new HashSet());
        }
        PCDirectory.pcGet_children(this).add(dir);
        PCDirectory.pcSet_parent(dir, this);
    }

    public PCFile add(String name) {
        if (name == null) {
            throw new NullPointerException("null file");
        }
        PCFile file = new PCFile(this, name);
        if (PCDirectory.pcGet_files(this) == null) {
            PCDirectory.pcSet_files(this, new HashSet());
        }
        if (PCDirectory.pcGet_files(this).contains(file)) {
            throw new IllegalArgumentException("duplicate file" + file);
        }
        PCDirectory.pcGet_files(this).add(file);
        return file;
    }

    public boolean isChild(PCDirectory dir, boolean recurse) {
        if (PCDirectory.pcGet_children(this) == null) {
            return false;
        }
        if (PCDirectory.pcGet_children(this).contains(dir)) {
            return true;
        }
        if (recurse) {
            for (PCDirectory child : PCDirectory.pcGet_children(this)) {
                if (!child.isChild(dir, recurse)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isChild(PCFile file, boolean recurse) {
        if (PCDirectory.pcGet_files(this) != null && PCDirectory.pcGet_files(this).contains(file)) {
            return true;
        }
        if (PCDirectory.pcGet_children(this) == null) {
            return false;
        }
        if (recurse) {
            for (PCDirectory child : PCDirectory.pcGet_children(this)) {
                if (!child.isChild(file, recurse)) continue;
                return true;
            }
        }
        return false;
    }

    public static Object reflect(PCDirectory instance, String name) {
        if (instance == null) {
            return null;
        }
        try {
            return PCDirectory.class.getDeclaredField(name).get(instance);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int pcGetEnhancementContractVersion() {
        return 196634845;
    }

    static {
        pcFieldNames = new String[]{"_children", "_files", "_name", "_parent", "id"};
        Class[] classArray = new Class[5];
        Class clazz = class$Ljava$util$Set != null ? class$Ljava$util$Set : (class$Ljava$util$Set = PCDirectory.class$("java.util.Set"));
        classArray[0] = clazz;
        classArray[1] = class$Ljava$util$Set != null ? class$Ljava$util$Set : (class$Ljava$util$Set = PCDirectory.class$("java.util.Set"));
        Class clazz2 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = PCDirectory.class$("java.lang.String"));
        classArray[2] = clazz2;
        Class clazz3 = class$Lorg$apache$openjpa$persistence$kernel$common$apps$PCDirectory != null ? class$Lorg$apache$openjpa$persistence$kernel$common$apps$PCDirectory : (class$Lorg$apache$openjpa$persistence$kernel$common$apps$PCDirectory = PCDirectory.class$("org.apache.openjpa.persistence.kernel.common.apps.PCDirectory"));
        classArray[3] = clazz3;
        classArray[4] = Integer.TYPE;
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{5, 5, 26, 5, 26};
        PCRegistry.register((Class)(class$Lorg$apache$openjpa$persistence$kernel$common$apps$PCDirectory != null ? class$Lorg$apache$openjpa$persistence$kernel$common$apps$PCDirectory : (class$Lorg$apache$openjpa$persistence$kernel$common$apps$PCDirectory = PCDirectory.class$("org.apache.openjpa.persistence.kernel.common.apps.PCDirectory"))), (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"PCDirectory", (PersistenceCapable)new PCDirectory());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this._children = null;
        this._files = null;
        this._name = null;
        this._parent = null;
        this.id = 0;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        PCDirectory pCDirectory = new PCDirectory();
        if (bl) {
            pCDirectory.pcClearFields();
        }
        pCDirectory.pcStateManager = stateManager;
        pCDirectory.pcCopyKeyFieldsFromObjectId(object);
        return pCDirectory;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        PCDirectory pCDirectory = new PCDirectory();
        if (bl) {
            pCDirectory.pcClearFields();
        }
        pCDirectory.pcStateManager = stateManager;
        return pCDirectory;
    }

    protected static int pcGetManagedFieldCount() {
        return 5;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this._children = (Set)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this._files = (Set)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this._name = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this._parent = (PCDirectory)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.id = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this._children);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this._files);
                return;
            }
            case 2: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this._name);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this._parent);
                return;
            }
            case 4: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.id);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(PCDirectory pCDirectory, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this._children = pCDirectory._children;
                return;
            }
            case 1: {
                this._files = pCDirectory._files;
                return;
            }
            case 2: {
                this._name = pCDirectory._name;
                return;
            }
            case 3: {
                this._parent = pCDirectory._parent;
                return;
            }
            case 4: {
                this.id = pCDirectory.id;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        PCDirectory pCDirectory = (PCDirectory)object;
        if (pCDirectory.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(pCDirectory, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        IntId intId = (IntId)object;
        fieldConsumer.storeIntField(4 + pcInheritedFieldCount, intId.getId());
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        IntId intId = (IntId)object;
        this.id = intId.getId();
    }

    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Lorg$apache$openjpa$persistence$kernel$common$apps$PCDirectory != null ? class$Lorg$apache$openjpa$persistence$kernel$common$apps$PCDirectory : (class$Lorg$apache$openjpa$persistence$kernel$common$apps$PCDirectory = PCDirectory.class$("org.apache.openjpa.persistence.kernel.common.apps.PCDirectory"));
        return new IntId(clazz, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        Class clazz = class$Lorg$apache$openjpa$persistence$kernel$common$apps$PCDirectory != null ? class$Lorg$apache$openjpa$persistence$kernel$common$apps$PCDirectory : (class$Lorg$apache$openjpa$persistence$kernel$common$apps$PCDirectory = PCDirectory.class$("org.apache.openjpa.persistence.kernel.common.apps.PCDirectory"));
        return new IntId(clazz, this.id);
    }

    private static final Set pcGet_children(PCDirectory pCDirectory) {
        if (pCDirectory.pcStateManager == null) {
            return pCDirectory._children;
        }
        int n = pcInheritedFieldCount + 0;
        pCDirectory.pcStateManager.accessingField(n);
        return pCDirectory._children;
    }

    private static final void pcSet_children(PCDirectory pCDirectory, Set set) {
        if (pCDirectory.pcStateManager == null) {
            pCDirectory._children = set;
            return;
        }
        pCDirectory.pcStateManager.settingObjectField((PersistenceCapable)pCDirectory, pcInheritedFieldCount + 0, pCDirectory._children, (Object)set, 0);
    }

    private static final Set pcGet_files(PCDirectory pCDirectory) {
        if (pCDirectory.pcStateManager == null) {
            return pCDirectory._files;
        }
        int n = pcInheritedFieldCount + 1;
        pCDirectory.pcStateManager.accessingField(n);
        return pCDirectory._files;
    }

    private static final void pcSet_files(PCDirectory pCDirectory, Set set) {
        if (pCDirectory.pcStateManager == null) {
            pCDirectory._files = set;
            return;
        }
        pCDirectory.pcStateManager.settingObjectField((PersistenceCapable)pCDirectory, pcInheritedFieldCount + 1, pCDirectory._files, (Object)set, 0);
    }

    private static final String pcGet_name(PCDirectory pCDirectory) {
        if (pCDirectory.pcStateManager == null) {
            return pCDirectory._name;
        }
        int n = pcInheritedFieldCount + 2;
        pCDirectory.pcStateManager.accessingField(n);
        return pCDirectory._name;
    }

    private static final void pcSet_name(PCDirectory pCDirectory, String string) {
        if (pCDirectory.pcStateManager == null) {
            pCDirectory._name = string;
            return;
        }
        pCDirectory.pcStateManager.settingStringField((PersistenceCapable)pCDirectory, pcInheritedFieldCount + 2, pCDirectory._name, string, 0);
    }

    private static final PCDirectory pcGet_parent(PCDirectory pCDirectory) {
        if (pCDirectory.pcStateManager == null) {
            return pCDirectory._parent;
        }
        int n = pcInheritedFieldCount + 3;
        pCDirectory.pcStateManager.accessingField(n);
        return pCDirectory._parent;
    }

    private static final void pcSet_parent(PCDirectory pCDirectory, PCDirectory pCDirectory2) {
        if (pCDirectory.pcStateManager == null) {
            pCDirectory._parent = pCDirectory2;
            return;
        }
        pCDirectory.pcStateManager.settingObjectField((PersistenceCapable)pCDirectory, pcInheritedFieldCount + 3, (Object)pCDirectory._parent, (Object)pCDirectory2, 0);
    }

    private static final int pcGetid(PCDirectory pCDirectory) {
        if (pCDirectory.pcStateManager == null) {
            return pCDirectory.id;
        }
        int n = pcInheritedFieldCount + 4;
        pCDirectory.pcStateManager.accessingField(n);
        return pCDirectory.id;
    }

    private static final void pcSetid(PCDirectory pCDirectory, int n) {
        if (pCDirectory.pcStateManager == null) {
            pCDirectory.id = n;
            return;
        }
        pCDirectory.pcStateManager.settingIntField((PersistenceCapable)pCDirectory, pcInheritedFieldCount + 4, pCDirectory.id, n, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (this.id != 0) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        return Boolean.FALSE;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }
}

