/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel.common.apps;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.util.IntId;
import org.apache.openjpa.util.InternalException;

@Entity
@Table(name="ALL_FLDTYPETEST")
public class AllFieldTypesTest
implements PersistenceCapable {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private int id;
    private int testint;
    private long testlong;
    private short testshort;
    private float testfloat = 1.0f;
    private double testdouble = 1.0;
    private byte testbyte;
    private boolean testboolean;
    private char testchar;
    private String testString;
    private String testBigString;
    @Temporal(value=TemporalType.DATE)
    private Date testDate;
    @Temporal(value=TemporalType.DATE)
    private Calendar testCalendar;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(scale=-1)
    private Timestamp testTstScale0;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(scale=3)
    private Timestamp testTstScale3;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(scale=6)
    private Timestamp testTstScale6;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Timestamp testTstMaxScale;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(scale=-1)
    private Date testDateScale0;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(scale=3)
    private Date testDateScale3;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date testDateMaxScale;
    private Object testObject;
    private BigInteger testBigInteger;
    private BigDecimal testBigDecimal;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Ljava$math$BigDecimal;
    static /* synthetic */ Class class$Ljava$math$BigInteger;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Ljava$util$Calendar;
    static /* synthetic */ Class class$Ljava$util$Date;
    static /* synthetic */ Class class$Ljava$sql$Timestamp;
    static /* synthetic */ Class class$Lorg$apache$openjpa$persistence$kernel$common$apps$AllFieldTypesTest;
    private transient Object pcDetachedState;

    public Date getTestDate() {
        return AllFieldTypesTest.pcGettestDate(this);
    }

    public void setTestDate(Date testDate) {
        AllFieldTypesTest.pcSettestDate(this, testDate);
    }

    public void setTestCalendar(Calendar testCalendar) {
        AllFieldTypesTest.pcSettestCalendar(this, testCalendar);
    }

    public Calendar getTestCalendar() {
        return AllFieldTypesTest.pcGettestCalendar(this);
    }

    public Object getTestObject() {
        return this.testObject;
    }

    public void setTestObject(Object testObject) {
        this.testObject = testObject;
    }

    public char getTestchar() {
        return AllFieldTypesTest.pcGettestchar(this);
    }

    public void setTestchar(char testchar) {
        AllFieldTypesTest.pcSettestchar(this, testchar);
    }

    public int getTestint() {
        return AllFieldTypesTest.pcGettestint(this);
    }

    public void setTestint(int testint) {
        AllFieldTypesTest.pcSettestint(this, testint);
    }

    public short getTestshort() {
        return AllFieldTypesTest.pcGettestshort(this);
    }

    public void setTestshort(short testshort) {
        AllFieldTypesTest.pcSettestshort(this, testshort);
    }

    public long getTestlong() {
        return AllFieldTypesTest.pcGettestlong(this);
    }

    public void setTestlong(long testlong) {
        AllFieldTypesTest.pcSettestlong(this, testlong);
    }

    public boolean getTestboolean() {
        return AllFieldTypesTest.pcGettestboolean(this);
    }

    public void setTestboolean(boolean testboolean) {
        AllFieldTypesTest.pcSettestboolean(this, testboolean);
    }

    public float getTestfloat() {
        return AllFieldTypesTest.pcGettestfloat(this);
    }

    public void setTestfloat(float testfloat) {
        AllFieldTypesTest.pcSettestfloat(this, testfloat);
    }

    public double getTestdouble() {
        return AllFieldTypesTest.pcGettestdouble(this);
    }

    public void setTestdouble(double testdouble) {
        AllFieldTypesTest.pcSettestdouble(this, testdouble);
    }

    public String getTestString() {
        return AllFieldTypesTest.pcGettestString(this);
    }

    public void setTestString(String testString) {
        AllFieldTypesTest.pcSettestString(this, testString);
    }

    public void setTestBigString(String testBigString) {
        AllFieldTypesTest.pcSettestBigString(this, testBigString);
    }

    public String getTestBigString() {
        return AllFieldTypesTest.pcGettestBigString(this);
    }

    public byte getTestbyte() {
        return AllFieldTypesTest.pcGettestbyte(this);
    }

    public void setTestbyte(byte testbyte) {
        AllFieldTypesTest.pcSettestbyte(this, testbyte);
    }

    public BigInteger getTestBigInteger() {
        return AllFieldTypesTest.pcGettestBigInteger(this);
    }

    public void setTestBigInteger(BigInteger testBigInteger) {
        AllFieldTypesTest.pcSettestBigInteger(this, testBigInteger);
    }

    public BigDecimal getTestBigDecimal() {
        return AllFieldTypesTest.pcGettestBigDecimal(this);
    }

    public void setTestBigDecimal(BigDecimal testBigDecimal) {
        AllFieldTypesTest.pcSettestBigDecimal(this, testBigDecimal);
    }

    public Timestamp getTestTstScale0() {
        return AllFieldTypesTest.pcGettestTstScale0(this);
    }

    public void setTestTstScale0(Timestamp testTstScale0) {
        AllFieldTypesTest.pcSettestTstScale0(this, testTstScale0);
    }

    public Timestamp getTestTstScale3() {
        return AllFieldTypesTest.pcGettestTstScale3(this);
    }

    public void setTestTstScale3(Timestamp testTstScale3) {
        AllFieldTypesTest.pcSettestTstScale3(this, testTstScale3);
    }

    public Timestamp getTestTstScale6() {
        return AllFieldTypesTest.pcGettestTstScale6(this);
    }

    public void setTestTstScale6(Timestamp testTstScale6) {
        AllFieldTypesTest.pcSettestTstScale6(this, testTstScale6);
    }

    public Timestamp getTestTstMaxScale() {
        return AllFieldTypesTest.pcGettestTstMaxScale(this);
    }

    public void setTestTstMaxScale(Timestamp testTstMaxScale) {
        AllFieldTypesTest.pcSettestTstMaxScale(this, testTstMaxScale);
    }

    public Date getTestDateMaxScale() {
        return AllFieldTypesTest.pcGettestDateMaxScale(this);
    }

    public void setTestDateMaxScale(Date testDateMaxScale) {
        AllFieldTypesTest.pcSettestDateMaxScale(this, testDateMaxScale);
    }

    public Date getTestDateScale0() {
        return AllFieldTypesTest.pcGettestDateScale0(this);
    }

    public void setTestDateScale0(Date testDateScale0) {
        AllFieldTypesTest.pcSettestDateScale0(this, testDateScale0);
    }

    public Date getTestDateScale3() {
        return AllFieldTypesTest.pcGettestDateScale3(this);
    }

    public void setTestDateScale3(Date testDateScale3) {
        AllFieldTypesTest.pcSettestDateScale3(this, testDateScale3);
    }

    public void randomize(boolean objects, boolean blobs) {
        AllFieldTypesTest.pcSettestint(this, AbstractTestCase.randomInt());
        AllFieldTypesTest.pcSettestlong(this, AbstractTestCase.randomLong());
        AllFieldTypesTest.pcSettestshort(this, AbstractTestCase.randomShort());
        AllFieldTypesTest.pcSettestfloat(this, AbstractTestCase.randomFloat().floatValue());
        AllFieldTypesTest.pcSettestdouble(this, AbstractTestCase.randomDouble());
        AllFieldTypesTest.pcSettestbyte(this, AbstractTestCase.randomByte());
        AllFieldTypesTest.pcSettestboolean(this, AbstractTestCase.randomBoolean());
        AllFieldTypesTest.pcSettestchar(this, AbstractTestCase.randomChar().charValue());
        if (objects) {
            AllFieldTypesTest.pcSettestString(this, AbstractTestCase.randomString());
            AllFieldTypesTest.pcSettestDate(this, AbstractTestCase.randomDate());
            AllFieldTypesTest.pcSettestCalendar(this, Calendar.getInstance());
            AllFieldTypesTest.pcGettestCalendar(this).setTime(AbstractTestCase.randomDate());
            AllFieldTypesTest.pcSettestBigInteger(this, AbstractTestCase.randomBigInteger());
            AllFieldTypesTest.pcSettestBigDecimal(this, AbstractTestCase.randomBigDecimal());
        }
        if (blobs && objects) {
            this.testObject = AbstractTestCase.randomBlob();
            AllFieldTypesTest.pcSettestBigString(this, AbstractTestCase.randomClob());
        }
    }

    public String toString() {
        return "\n{testint=" + AllFieldTypesTest.pcGettestint(this) + ";testlong=" + AllFieldTypesTest.pcGettestlong(this) + ";testshort=" + AllFieldTypesTest.pcGettestshort(this) + ";testfloat=" + AllFieldTypesTest.pcGettestfloat(this) + ";testdouble=" + AllFieldTypesTest.pcGettestdouble(this) + ";testbyte=" + AllFieldTypesTest.pcGettestbyte(this) + ";testboolean=" + AllFieldTypesTest.pcGettestboolean(this) + ";testchar=" + AllFieldTypesTest.pcGettestchar(this) + ";testString=" + AllFieldTypesTest.pcGettestString(this) + ";testBigString=" + AllFieldTypesTest.pcGettestBigString(this) + ";testDate=" + AllFieldTypesTest.pcGettestDate(this) + ";testCalendar=" + AllFieldTypesTest.pcGettestCalendar(this) + ";testObject=" + this.testObject + "(" + (this.testObject instanceof byte[] ? "(byte[])" + ((byte[])this.testObject).length + "" : (this.testObject == null ? "null" : this.testObject.getClass().getName())) + ");testBigInteger=" + AllFieldTypesTest.pcGettestBigInteger(this) + ";testBigDecimal=" + AllFieldTypesTest.pcGettestBigDecimal(this) + ";}";
    }

    public int hashCode() {
        return (int)((double)((float)((long)AllFieldTypesTest.pcGettestint(this) + AllFieldTypesTest.pcGettestlong(this) + (long)AllFieldTypesTest.pcGettestshort(this)) + AllFieldTypesTest.pcGettestfloat(this)) + AllFieldTypesTest.pcGettestdouble(this) + (double)AllFieldTypesTest.pcGettestbyte(this) + (double)(AllFieldTypesTest.pcGettestboolean(this) ? 1 : 0) + (double)AllFieldTypesTest.pcGettestchar(this) + (double)(AllFieldTypesTest.pcGettestString(this) == null ? 0 : AllFieldTypesTest.pcGettestString(this).hashCode()) + (double)(AllFieldTypesTest.pcGettestBigString(this) == null ? 0 : AllFieldTypesTest.pcGettestBigString(this).hashCode()) + (double)(AllFieldTypesTest.pcGettestDate(this) == null ? 0 : AllFieldTypesTest.pcGettestDate(this).hashCode()) + (double)(AllFieldTypesTest.pcGettestCalendar(this) == null ? 0 : AllFieldTypesTest.pcGettestCalendar(this).hashCode()) + (double)(this.testObject == null ? 0 : this.testObject.hashCode()) + (double)(AllFieldTypesTest.pcGettestBigInteger(this) == null ? 0 : AllFieldTypesTest.pcGettestBigInteger(this).hashCode()) + (double)(AllFieldTypesTest.pcGettestBigDecimal(this) == null ? 0 : AllFieldTypesTest.pcGettestBigDecimal(this).hashCode())) % Integer.MAX_VALUE;
    }

    public boolean equals(Object other) {
        if (other == null && !(other instanceof AllFieldTypesTest)) {
            return false;
        }
        AllFieldTypesTest o = (AllFieldTypesTest)other;
        return AllFieldTypesTest.pcGettestint(o) == AllFieldTypesTest.pcGettestint(this) && AllFieldTypesTest.pcGettestlong(o) == AllFieldTypesTest.pcGettestlong(this) && AllFieldTypesTest.pcGettestshort(o) == AllFieldTypesTest.pcGettestshort(this) && AllFieldTypesTest.pcGettestfloat(o) == AllFieldTypesTest.pcGettestfloat(this) && AllFieldTypesTest.pcGettestdouble(o) == AllFieldTypesTest.pcGettestdouble(this) && AllFieldTypesTest.pcGettestbyte(o) == AllFieldTypesTest.pcGettestbyte(this) && AllFieldTypesTest.pcGettestboolean(o) == AllFieldTypesTest.pcGettestboolean(this) && AllFieldTypesTest.pcGettestchar(o) == AllFieldTypesTest.pcGettestchar(this) && this.eq(AllFieldTypesTest.pcGettestString(o), AllFieldTypesTest.pcGettestString(this)) && this.eq(AllFieldTypesTest.pcGettestBigString(o), AllFieldTypesTest.pcGettestBigString(this)) && this.eq(AllFieldTypesTest.pcGettestDate(o), AllFieldTypesTest.pcGettestDate(this)) && this.eq(AllFieldTypesTest.pcGettestCalendar(o), AllFieldTypesTest.pcGettestCalendar(this)) && this.eq(o.testObject, this.testObject) && this.eq(AllFieldTypesTest.pcGettestBigInteger(o), AllFieldTypesTest.pcGettestBigInteger(o)) && this.eq(AllFieldTypesTest.pcGettestBigDecimal(o), AllFieldTypesTest.pcGettestBigDecimal(o));
    }

    private boolean eq(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null && b != null) {
            return false;
        }
        if (a != null && b == null) {
            return false;
        }
        if (a instanceof byte[] && b instanceof byte[]) {
            return Arrays.equals((byte[])a, (byte[])b);
        }
        return a.equals(b);
    }

    public int pcGetEnhancementContractVersion() {
        return 196634845;
    }

    static {
        pcFieldNames = new String[]{"id", "testBigDecimal", "testBigInteger", "testBigString", "testCalendar", "testDate", "testDateMaxScale", "testDateScale0", "testDateScale3", "testString", "testTstMaxScale", "testTstScale0", "testTstScale3", "testTstScale6", "testboolean", "testbyte", "testchar", "testdouble", "testfloat", "testint", "testlong", "testshort"};
        Class[] classArray = new Class[22];
        classArray[0] = Integer.TYPE;
        Class clazz = class$Ljava$math$BigDecimal != null ? class$Ljava$math$BigDecimal : (class$Ljava$math$BigDecimal = AllFieldTypesTest.class$("java.math.BigDecimal"));
        classArray[1] = clazz;
        Class clazz2 = class$Ljava$math$BigInteger != null ? class$Ljava$math$BigInteger : (class$Ljava$math$BigInteger = AllFieldTypesTest.class$("java.math.BigInteger"));
        classArray[2] = clazz2;
        Class clazz3 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = AllFieldTypesTest.class$("java.lang.String"));
        classArray[3] = clazz3;
        Class clazz4 = class$Ljava$util$Calendar != null ? class$Ljava$util$Calendar : (class$Ljava$util$Calendar = AllFieldTypesTest.class$("java.util.Calendar"));
        classArray[4] = clazz4;
        Class clazz5 = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = AllFieldTypesTest.class$("java.util.Date"));
        classArray[5] = clazz5;
        classArray[6] = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = AllFieldTypesTest.class$("java.util.Date"));
        classArray[7] = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = AllFieldTypesTest.class$("java.util.Date"));
        classArray[8] = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = AllFieldTypesTest.class$("java.util.Date"));
        classArray[9] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = AllFieldTypesTest.class$("java.lang.String"));
        Class clazz6 = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = AllFieldTypesTest.class$("java.sql.Timestamp"));
        classArray[10] = clazz6;
        classArray[11] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = AllFieldTypesTest.class$("java.sql.Timestamp"));
        classArray[12] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = AllFieldTypesTest.class$("java.sql.Timestamp"));
        classArray[13] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = AllFieldTypesTest.class$("java.sql.Timestamp"));
        classArray[14] = Boolean.TYPE;
        classArray[15] = Byte.TYPE;
        classArray[16] = Character.TYPE;
        classArray[17] = Double.TYPE;
        classArray[18] = Float.TYPE;
        classArray[19] = Integer.TYPE;
        classArray[20] = Long.TYPE;
        classArray[21] = Short.TYPE;
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26};
        Class clazz7 = class$Lorg$apache$openjpa$persistence$kernel$common$apps$AllFieldTypesTest != null ? class$Lorg$apache$openjpa$persistence$kernel$common$apps$AllFieldTypesTest : (class$Lorg$apache$openjpa$persistence$kernel$common$apps$AllFieldTypesTest = AllFieldTypesTest.class$("org.apache.openjpa.persistence.kernel.common.apps.AllFieldTypesTest"));
        PCRegistry.register((Class)clazz7, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"AllFieldTypesTest", (PersistenceCapable)new AllFieldTypesTest());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this.id = 0;
        this.testBigDecimal = null;
        this.testBigInteger = null;
        this.testBigString = null;
        this.testCalendar = null;
        this.testDate = null;
        this.testDateMaxScale = null;
        this.testDateScale0 = null;
        this.testDateScale3 = null;
        this.testString = null;
        this.testTstMaxScale = null;
        this.testTstScale0 = null;
        this.testTstScale3 = null;
        this.testTstScale6 = null;
        this.testboolean = false;
        this.testbyte = 0;
        this.testchar = '\u0000';
        this.testdouble = 0.0;
        this.testfloat = 0.0f;
        this.testint = 0;
        this.testlong = 0L;
        this.testshort = 0;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        AllFieldTypesTest allFieldTypesTest = new AllFieldTypesTest();
        if (bl) {
            allFieldTypesTest.pcClearFields();
        }
        allFieldTypesTest.pcStateManager = stateManager;
        allFieldTypesTest.pcCopyKeyFieldsFromObjectId(object);
        return allFieldTypesTest;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        AllFieldTypesTest allFieldTypesTest = new AllFieldTypesTest();
        if (bl) {
            allFieldTypesTest.pcClearFields();
        }
        allFieldTypesTest.pcStateManager = stateManager;
        return allFieldTypesTest;
    }

    protected static int pcGetManagedFieldCount() {
        return 22;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.id = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.testBigDecimal = (BigDecimal)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.testBigInteger = (BigInteger)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.testBigString = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.testCalendar = (Calendar)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.testDate = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.testDateMaxScale = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.testDateScale0 = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.testDateScale3 = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this.testString = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 10: {
                this.testTstMaxScale = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 11: {
                this.testTstScale0 = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 12: {
                this.testTstScale3 = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 13: {
                this.testTstScale6 = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 14: {
                this.testboolean = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 15: {
                this.testbyte = this.pcStateManager.replaceByteField((PersistenceCapable)this, n);
                return;
            }
            case 16: {
                this.testchar = this.pcStateManager.replaceCharField((PersistenceCapable)this, n);
                return;
            }
            case 17: {
                this.testdouble = this.pcStateManager.replaceDoubleField((PersistenceCapable)this, n);
                return;
            }
            case 18: {
                this.testfloat = this.pcStateManager.replaceFloatField((PersistenceCapable)this, n);
                return;
            }
            case 19: {
                this.testint = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 20: {
                this.testlong = this.pcStateManager.replaceLongField((PersistenceCapable)this, n);
                return;
            }
            case 21: {
                this.testshort = this.pcStateManager.replaceShortField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.id);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.testBigDecimal);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.testBigInteger);
                return;
            }
            case 3: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.testBigString);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.testCalendar);
                return;
            }
            case 5: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.testDate);
                return;
            }
            case 6: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.testDateMaxScale);
                return;
            }
            case 7: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.testDateScale0);
                return;
            }
            case 8: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.testDateScale3);
                return;
            }
            case 9: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.testString);
                return;
            }
            case 10: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.testTstMaxScale);
                return;
            }
            case 11: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.testTstScale0);
                return;
            }
            case 12: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.testTstScale3);
                return;
            }
            case 13: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.testTstScale6);
                return;
            }
            case 14: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.testboolean);
                return;
            }
            case 15: {
                this.pcStateManager.providedByteField((PersistenceCapable)this, n, this.testbyte);
                return;
            }
            case 16: {
                this.pcStateManager.providedCharField((PersistenceCapable)this, n, this.testchar);
                return;
            }
            case 17: {
                this.pcStateManager.providedDoubleField((PersistenceCapable)this, n, this.testdouble);
                return;
            }
            case 18: {
                this.pcStateManager.providedFloatField((PersistenceCapable)this, n, this.testfloat);
                return;
            }
            case 19: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.testint);
                return;
            }
            case 20: {
                this.pcStateManager.providedLongField((PersistenceCapable)this, n, this.testlong);
                return;
            }
            case 21: {
                this.pcStateManager.providedShortField((PersistenceCapable)this, n, this.testshort);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(AllFieldTypesTest allFieldTypesTest, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.id = allFieldTypesTest.id;
                return;
            }
            case 1: {
                this.testBigDecimal = allFieldTypesTest.testBigDecimal;
                return;
            }
            case 2: {
                this.testBigInteger = allFieldTypesTest.testBigInteger;
                return;
            }
            case 3: {
                this.testBigString = allFieldTypesTest.testBigString;
                return;
            }
            case 4: {
                this.testCalendar = allFieldTypesTest.testCalendar;
                return;
            }
            case 5: {
                this.testDate = allFieldTypesTest.testDate;
                return;
            }
            case 6: {
                this.testDateMaxScale = allFieldTypesTest.testDateMaxScale;
                return;
            }
            case 7: {
                this.testDateScale0 = allFieldTypesTest.testDateScale0;
                return;
            }
            case 8: {
                this.testDateScale3 = allFieldTypesTest.testDateScale3;
                return;
            }
            case 9: {
                this.testString = allFieldTypesTest.testString;
                return;
            }
            case 10: {
                this.testTstMaxScale = allFieldTypesTest.testTstMaxScale;
                return;
            }
            case 11: {
                this.testTstScale0 = allFieldTypesTest.testTstScale0;
                return;
            }
            case 12: {
                this.testTstScale3 = allFieldTypesTest.testTstScale3;
                return;
            }
            case 13: {
                this.testTstScale6 = allFieldTypesTest.testTstScale6;
                return;
            }
            case 14: {
                this.testboolean = allFieldTypesTest.testboolean;
                return;
            }
            case 15: {
                this.testbyte = allFieldTypesTest.testbyte;
                return;
            }
            case 16: {
                this.testchar = allFieldTypesTest.testchar;
                return;
            }
            case 17: {
                this.testdouble = allFieldTypesTest.testdouble;
                return;
            }
            case 18: {
                this.testfloat = allFieldTypesTest.testfloat;
                return;
            }
            case 19: {
                this.testint = allFieldTypesTest.testint;
                return;
            }
            case 20: {
                this.testlong = allFieldTypesTest.testlong;
                return;
            }
            case 21: {
                this.testshort = allFieldTypesTest.testshort;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        AllFieldTypesTest allFieldTypesTest = (AllFieldTypesTest)object;
        if (allFieldTypesTest.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(allFieldTypesTest, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        IntId intId = (IntId)object;
        fieldConsumer.storeIntField(0 + pcInheritedFieldCount, intId.getId());
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        IntId intId = (IntId)object;
        this.id = intId.getId();
    }

    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Lorg$apache$openjpa$persistence$kernel$common$apps$AllFieldTypesTest != null ? class$Lorg$apache$openjpa$persistence$kernel$common$apps$AllFieldTypesTest : (class$Lorg$apache$openjpa$persistence$kernel$common$apps$AllFieldTypesTest = AllFieldTypesTest.class$("org.apache.openjpa.persistence.kernel.common.apps.AllFieldTypesTest"));
        return new IntId(clazz, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        Class clazz = class$Lorg$apache$openjpa$persistence$kernel$common$apps$AllFieldTypesTest != null ? class$Lorg$apache$openjpa$persistence$kernel$common$apps$AllFieldTypesTest : (class$Lorg$apache$openjpa$persistence$kernel$common$apps$AllFieldTypesTest = AllFieldTypesTest.class$("org.apache.openjpa.persistence.kernel.common.apps.AllFieldTypesTest"));
        return new IntId(clazz, this.id);
    }

    private static final int pcGetid(AllFieldTypesTest allFieldTypesTest) {
        if (allFieldTypesTest.pcStateManager == null) {
            return allFieldTypesTest.id;
        }
        int n = pcInheritedFieldCount + 0;
        allFieldTypesTest.pcStateManager.accessingField(n);
        return allFieldTypesTest.id;
    }

    private static final void pcSetid(AllFieldTypesTest allFieldTypesTest, int n) {
        if (allFieldTypesTest.pcStateManager == null) {
            allFieldTypesTest.id = n;
            return;
        }
        allFieldTypesTest.pcStateManager.settingIntField((PersistenceCapable)allFieldTypesTest, pcInheritedFieldCount + 0, allFieldTypesTest.id, n, 0);
    }

    private static final BigDecimal pcGettestBigDecimal(AllFieldTypesTest allFieldTypesTest) {
        if (allFieldTypesTest.pcStateManager == null) {
            return allFieldTypesTest.testBigDecimal;
        }
        int n = pcInheritedFieldCount + 1;
        allFieldTypesTest.pcStateManager.accessingField(n);
        return allFieldTypesTest.testBigDecimal;
    }

    private static final void pcSettestBigDecimal(AllFieldTypesTest allFieldTypesTest, BigDecimal bigDecimal) {
        if (allFieldTypesTest.pcStateManager == null) {
            allFieldTypesTest.testBigDecimal = bigDecimal;
            return;
        }
        allFieldTypesTest.pcStateManager.settingObjectField((PersistenceCapable)allFieldTypesTest, pcInheritedFieldCount + 1, (Object)allFieldTypesTest.testBigDecimal, (Object)bigDecimal, 0);
    }

    private static final BigInteger pcGettestBigInteger(AllFieldTypesTest allFieldTypesTest) {
        if (allFieldTypesTest.pcStateManager == null) {
            return allFieldTypesTest.testBigInteger;
        }
        int n = pcInheritedFieldCount + 2;
        allFieldTypesTest.pcStateManager.accessingField(n);
        return allFieldTypesTest.testBigInteger;
    }

    private static final void pcSettestBigInteger(AllFieldTypesTest allFieldTypesTest, BigInteger bigInteger) {
        if (allFieldTypesTest.pcStateManager == null) {
            allFieldTypesTest.testBigInteger = bigInteger;
            return;
        }
        allFieldTypesTest.pcStateManager.settingObjectField((PersistenceCapable)allFieldTypesTest, pcInheritedFieldCount + 2, (Object)allFieldTypesTest.testBigInteger, (Object)bigInteger, 0);
    }

    private static final String pcGettestBigString(AllFieldTypesTest allFieldTypesTest) {
        if (allFieldTypesTest.pcStateManager == null) {
            return allFieldTypesTest.testBigString;
        }
        int n = pcInheritedFieldCount + 3;
        allFieldTypesTest.pcStateManager.accessingField(n);
        return allFieldTypesTest.testBigString;
    }

    private static final void pcSettestBigString(AllFieldTypesTest allFieldTypesTest, String string) {
        if (allFieldTypesTest.pcStateManager == null) {
            allFieldTypesTest.testBigString = string;
            return;
        }
        allFieldTypesTest.pcStateManager.settingStringField((PersistenceCapable)allFieldTypesTest, pcInheritedFieldCount + 3, allFieldTypesTest.testBigString, string, 0);
    }

    private static final Calendar pcGettestCalendar(AllFieldTypesTest allFieldTypesTest) {
        if (allFieldTypesTest.pcStateManager == null) {
            return allFieldTypesTest.testCalendar;
        }
        int n = pcInheritedFieldCount + 4;
        allFieldTypesTest.pcStateManager.accessingField(n);
        return allFieldTypesTest.testCalendar;
    }

    private static final void pcSettestCalendar(AllFieldTypesTest allFieldTypesTest, Calendar calendar) {
        if (allFieldTypesTest.pcStateManager == null) {
            allFieldTypesTest.testCalendar = calendar;
            return;
        }
        allFieldTypesTest.pcStateManager.settingObjectField((PersistenceCapable)allFieldTypesTest, pcInheritedFieldCount + 4, (Object)allFieldTypesTest.testCalendar, (Object)calendar, 0);
    }

    private static final Date pcGettestDate(AllFieldTypesTest allFieldTypesTest) {
        if (allFieldTypesTest.pcStateManager == null) {
            return allFieldTypesTest.testDate;
        }
        int n = pcInheritedFieldCount + 5;
        allFieldTypesTest.pcStateManager.accessingField(n);
        return allFieldTypesTest.testDate;
    }

    private static final void pcSettestDate(AllFieldTypesTest allFieldTypesTest, Date date) {
        if (allFieldTypesTest.pcStateManager == null) {
            allFieldTypesTest.testDate = date;
            return;
        }
        allFieldTypesTest.pcStateManager.settingObjectField((PersistenceCapable)allFieldTypesTest, pcInheritedFieldCount + 5, (Object)allFieldTypesTest.testDate, (Object)date, 0);
    }

    private static final Date pcGettestDateMaxScale(AllFieldTypesTest allFieldTypesTest) {
        if (allFieldTypesTest.pcStateManager == null) {
            return allFieldTypesTest.testDateMaxScale;
        }
        int n = pcInheritedFieldCount + 6;
        allFieldTypesTest.pcStateManager.accessingField(n);
        return allFieldTypesTest.testDateMaxScale;
    }

    private static final void pcSettestDateMaxScale(AllFieldTypesTest allFieldTypesTest, Date date) {
        if (allFieldTypesTest.pcStateManager == null) {
            allFieldTypesTest.testDateMaxScale = date;
            return;
        }
        allFieldTypesTest.pcStateManager.settingObjectField((PersistenceCapable)allFieldTypesTest, pcInheritedFieldCount + 6, (Object)allFieldTypesTest.testDateMaxScale, (Object)date, 0);
    }

    private static final Date pcGettestDateScale0(AllFieldTypesTest allFieldTypesTest) {
        if (allFieldTypesTest.pcStateManager == null) {
            return allFieldTypesTest.testDateScale0;
        }
        int n = pcInheritedFieldCount + 7;
        allFieldTypesTest.pcStateManager.accessingField(n);
        return allFieldTypesTest.testDateScale0;
    }

    private static final void pcSettestDateScale0(AllFieldTypesTest allFieldTypesTest, Date date) {
        if (allFieldTypesTest.pcStateManager == null) {
            allFieldTypesTest.testDateScale0 = date;
            return;
        }
        allFieldTypesTest.pcStateManager.settingObjectField((PersistenceCapable)allFieldTypesTest, pcInheritedFieldCount + 7, (Object)allFieldTypesTest.testDateScale0, (Object)date, 0);
    }

    private static final Date pcGettestDateScale3(AllFieldTypesTest allFieldTypesTest) {
        if (allFieldTypesTest.pcStateManager == null) {
            return allFieldTypesTest.testDateScale3;
        }
        int n = pcInheritedFieldCount + 8;
        allFieldTypesTest.pcStateManager.accessingField(n);
        return allFieldTypesTest.testDateScale3;
    }

    private static final void pcSettestDateScale3(AllFieldTypesTest allFieldTypesTest, Date date) {
        if (allFieldTypesTest.pcStateManager == null) {
            allFieldTypesTest.testDateScale3 = date;
            return;
        }
        allFieldTypesTest.pcStateManager.settingObjectField((PersistenceCapable)allFieldTypesTest, pcInheritedFieldCount + 8, (Object)allFieldTypesTest.testDateScale3, (Object)date, 0);
    }

    private static final String pcGettestString(AllFieldTypesTest allFieldTypesTest) {
        if (allFieldTypesTest.pcStateManager == null) {
            return allFieldTypesTest.testString;
        }
        int n = pcInheritedFieldCount + 9;
        allFieldTypesTest.pcStateManager.accessingField(n);
        return allFieldTypesTest.testString;
    }

    private static final void pcSettestString(AllFieldTypesTest allFieldTypesTest, String string) {
        if (allFieldTypesTest.pcStateManager == null) {
            allFieldTypesTest.testString = string;
            return;
        }
        allFieldTypesTest.pcStateManager.settingStringField((PersistenceCapable)allFieldTypesTest, pcInheritedFieldCount + 9, allFieldTypesTest.testString, string, 0);
    }

    private static final Timestamp pcGettestTstMaxScale(AllFieldTypesTest allFieldTypesTest) {
        if (allFieldTypesTest.pcStateManager == null) {
            return allFieldTypesTest.testTstMaxScale;
        }
        int n = pcInheritedFieldCount + 10;
        allFieldTypesTest.pcStateManager.accessingField(n);
        return allFieldTypesTest.testTstMaxScale;
    }

    private static final void pcSettestTstMaxScale(AllFieldTypesTest allFieldTypesTest, Timestamp timestamp) {
        if (allFieldTypesTest.pcStateManager == null) {
            allFieldTypesTest.testTstMaxScale = timestamp;
            return;
        }
        allFieldTypesTest.pcStateManager.settingObjectField((PersistenceCapable)allFieldTypesTest, pcInheritedFieldCount + 10, (Object)allFieldTypesTest.testTstMaxScale, (Object)timestamp, 0);
    }

    private static final Timestamp pcGettestTstScale0(AllFieldTypesTest allFieldTypesTest) {
        if (allFieldTypesTest.pcStateManager == null) {
            return allFieldTypesTest.testTstScale0;
        }
        int n = pcInheritedFieldCount + 11;
        allFieldTypesTest.pcStateManager.accessingField(n);
        return allFieldTypesTest.testTstScale0;
    }

    private static final void pcSettestTstScale0(AllFieldTypesTest allFieldTypesTest, Timestamp timestamp) {
        if (allFieldTypesTest.pcStateManager == null) {
            allFieldTypesTest.testTstScale0 = timestamp;
            return;
        }
        allFieldTypesTest.pcStateManager.settingObjectField((PersistenceCapable)allFieldTypesTest, pcInheritedFieldCount + 11, (Object)allFieldTypesTest.testTstScale0, (Object)timestamp, 0);
    }

    private static final Timestamp pcGettestTstScale3(AllFieldTypesTest allFieldTypesTest) {
        if (allFieldTypesTest.pcStateManager == null) {
            return allFieldTypesTest.testTstScale3;
        }
        int n = pcInheritedFieldCount + 12;
        allFieldTypesTest.pcStateManager.accessingField(n);
        return allFieldTypesTest.testTstScale3;
    }

    private static final void pcSettestTstScale3(AllFieldTypesTest allFieldTypesTest, Timestamp timestamp) {
        if (allFieldTypesTest.pcStateManager == null) {
            allFieldTypesTest.testTstScale3 = timestamp;
            return;
        }
        allFieldTypesTest.pcStateManager.settingObjectField((PersistenceCapable)allFieldTypesTest, pcInheritedFieldCount + 12, (Object)allFieldTypesTest.testTstScale3, (Object)timestamp, 0);
    }

    private static final Timestamp pcGettestTstScale6(AllFieldTypesTest allFieldTypesTest) {
        if (allFieldTypesTest.pcStateManager == null) {
            return allFieldTypesTest.testTstScale6;
        }
        int n = pcInheritedFieldCount + 13;
        allFieldTypesTest.pcStateManager.accessingField(n);
        return allFieldTypesTest.testTstScale6;
    }

    private static final void pcSettestTstScale6(AllFieldTypesTest allFieldTypesTest, Timestamp timestamp) {
        if (allFieldTypesTest.pcStateManager == null) {
            allFieldTypesTest.testTstScale6 = timestamp;
            return;
        }
        allFieldTypesTest.pcStateManager.settingObjectField((PersistenceCapable)allFieldTypesTest, pcInheritedFieldCount + 13, (Object)allFieldTypesTest.testTstScale6, (Object)timestamp, 0);
    }

    private static final boolean pcGettestboolean(AllFieldTypesTest allFieldTypesTest) {
        if (allFieldTypesTest.pcStateManager == null) {
            return allFieldTypesTest.testboolean;
        }
        int n = pcInheritedFieldCount + 14;
        allFieldTypesTest.pcStateManager.accessingField(n);
        return allFieldTypesTest.testboolean;
    }

    private static final void pcSettestboolean(AllFieldTypesTest allFieldTypesTest, boolean bl) {
        if (allFieldTypesTest.pcStateManager == null) {
            allFieldTypesTest.testboolean = bl;
            return;
        }
        allFieldTypesTest.pcStateManager.settingBooleanField((PersistenceCapable)allFieldTypesTest, pcInheritedFieldCount + 14, allFieldTypesTest.testboolean, bl, 0);
    }

    private static final byte pcGettestbyte(AllFieldTypesTest allFieldTypesTest) {
        if (allFieldTypesTest.pcStateManager == null) {
            return allFieldTypesTest.testbyte;
        }
        int n = pcInheritedFieldCount + 15;
        allFieldTypesTest.pcStateManager.accessingField(n);
        return allFieldTypesTest.testbyte;
    }

    private static final void pcSettestbyte(AllFieldTypesTest allFieldTypesTest, byte by) {
        if (allFieldTypesTest.pcStateManager == null) {
            allFieldTypesTest.testbyte = by;
            return;
        }
        allFieldTypesTest.pcStateManager.settingByteField((PersistenceCapable)allFieldTypesTest, pcInheritedFieldCount + 15, allFieldTypesTest.testbyte, by, 0);
    }

    private static final char pcGettestchar(AllFieldTypesTest allFieldTypesTest) {
        if (allFieldTypesTest.pcStateManager == null) {
            return allFieldTypesTest.testchar;
        }
        int n = pcInheritedFieldCount + 16;
        allFieldTypesTest.pcStateManager.accessingField(n);
        return allFieldTypesTest.testchar;
    }

    private static final void pcSettestchar(AllFieldTypesTest allFieldTypesTest, char c) {
        if (allFieldTypesTest.pcStateManager == null) {
            allFieldTypesTest.testchar = c;
            return;
        }
        allFieldTypesTest.pcStateManager.settingCharField((PersistenceCapable)allFieldTypesTest, pcInheritedFieldCount + 16, allFieldTypesTest.testchar, c, 0);
    }

    private static final double pcGettestdouble(AllFieldTypesTest allFieldTypesTest) {
        if (allFieldTypesTest.pcStateManager == null) {
            return allFieldTypesTest.testdouble;
        }
        int n = pcInheritedFieldCount + 17;
        allFieldTypesTest.pcStateManager.accessingField(n);
        return allFieldTypesTest.testdouble;
    }

    private static final void pcSettestdouble(AllFieldTypesTest allFieldTypesTest, double d) {
        if (allFieldTypesTest.pcStateManager == null) {
            allFieldTypesTest.testdouble = d;
            return;
        }
        allFieldTypesTest.pcStateManager.settingDoubleField((PersistenceCapable)allFieldTypesTest, pcInheritedFieldCount + 17, allFieldTypesTest.testdouble, d, 0);
    }

    private static final float pcGettestfloat(AllFieldTypesTest allFieldTypesTest) {
        if (allFieldTypesTest.pcStateManager == null) {
            return allFieldTypesTest.testfloat;
        }
        int n = pcInheritedFieldCount + 18;
        allFieldTypesTest.pcStateManager.accessingField(n);
        return allFieldTypesTest.testfloat;
    }

    private static final void pcSettestfloat(AllFieldTypesTest allFieldTypesTest, float f) {
        if (allFieldTypesTest.pcStateManager == null) {
            allFieldTypesTest.testfloat = f;
            return;
        }
        allFieldTypesTest.pcStateManager.settingFloatField((PersistenceCapable)allFieldTypesTest, pcInheritedFieldCount + 18, allFieldTypesTest.testfloat, f, 0);
    }

    private static final int pcGettestint(AllFieldTypesTest allFieldTypesTest) {
        if (allFieldTypesTest.pcStateManager == null) {
            return allFieldTypesTest.testint;
        }
        int n = pcInheritedFieldCount + 19;
        allFieldTypesTest.pcStateManager.accessingField(n);
        return allFieldTypesTest.testint;
    }

    private static final void pcSettestint(AllFieldTypesTest allFieldTypesTest, int n) {
        if (allFieldTypesTest.pcStateManager == null) {
            allFieldTypesTest.testint = n;
            return;
        }
        allFieldTypesTest.pcStateManager.settingIntField((PersistenceCapable)allFieldTypesTest, pcInheritedFieldCount + 19, allFieldTypesTest.testint, n, 0);
    }

    private static final long pcGettestlong(AllFieldTypesTest allFieldTypesTest) {
        if (allFieldTypesTest.pcStateManager == null) {
            return allFieldTypesTest.testlong;
        }
        int n = pcInheritedFieldCount + 20;
        allFieldTypesTest.pcStateManager.accessingField(n);
        return allFieldTypesTest.testlong;
    }

    private static final void pcSettestlong(AllFieldTypesTest allFieldTypesTest, long l) {
        if (allFieldTypesTest.pcStateManager == null) {
            allFieldTypesTest.testlong = l;
            return;
        }
        allFieldTypesTest.pcStateManager.settingLongField((PersistenceCapable)allFieldTypesTest, pcInheritedFieldCount + 20, allFieldTypesTest.testlong, l, 0);
    }

    private static final short pcGettestshort(AllFieldTypesTest allFieldTypesTest) {
        if (allFieldTypesTest.pcStateManager == null) {
            return allFieldTypesTest.testshort;
        }
        int n = pcInheritedFieldCount + 21;
        allFieldTypesTest.pcStateManager.accessingField(n);
        return allFieldTypesTest.testshort;
    }

    private static final void pcSettestshort(AllFieldTypesTest allFieldTypesTest, short s) {
        if (allFieldTypesTest.pcStateManager == null) {
            allFieldTypesTest.testshort = s;
            return;
        }
        allFieldTypesTest.pcStateManager.settingShortField((PersistenceCapable)allFieldTypesTest, pcInheritedFieldCount + 21, allFieldTypesTest.testshort, s, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (this.id != 0) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        return Boolean.FALSE;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }
}

