/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import java.util.ArrayList;
import javax.persistence.RollbackException;
import org.apache.openjpa.jdbc.kernel.EntityA;
import org.apache.openjpa.jdbc.kernel.EntityB;
import org.apache.openjpa.jdbc.kernel.EntityC;
import org.apache.openjpa.jdbc.kernel.EntityD;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestSuppressBatchOLE
extends SingleEMFTestCase {
    @Override
    public void setUp() throws Exception {
        this.setUp(CLEAR_TABLES, EntityA.class, EntityB.class, EntityC.class, EntityD.class, "openjpa.BrokerImpl", "SuppressBatchOLELogging=true", "openjpa.jdbc.DBDictionary", "batchLimit=-1", "openjpa.DataCache", "false");
    }

    public void test() throws Exception {
        OpenJPAEntityManagerSPI em1 = this.emf.createEntityManager();
        OpenJPAEntityManagerSPI em2 = this.emf.createEntityManager();
        em1.getTransaction().begin();
        ArrayList<EntityA> entities = new ArrayList<EntityA>();
        for (int i = 0; i < 25; ++i) {
            EntityA a = this.createEntity();
            entities.add(a);
            em1.persist((Object)a);
        }
        em1.getTransaction().commit();
        em1.clear();
        em1.getTransaction().begin();
        em2.getTransaction().begin();
        for (EntityA a : entities) {
            EntityA a1 = (EntityA)em1.find(EntityA.class, (Object)a.getId());
            EntityA a2 = (EntityA)em2.find(EntityA.class, (Object)a.getId());
            a1.setName("asdf");
            a2.setName("asdf2");
        }
        em1.getTransaction().commit();
        try {
            em2.getTransaction().commit();
        }
        catch (RollbackException e) {
            TestSuppressBatchOLE.assertTrue((boolean)e.getMessage().contains("Suppressing"));
        }
    }

    EntityA createEntity() {
        EntityA res = new EntityA();
        EntityB b = new EntityB();
        EntityC c = new EntityC();
        EntityD d = new EntityD();
        res.setEntityB(b);
        b.setEntityC(c);
        c.setEntityD(d);
        return res;
    }
}

