/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import java.util.Properties;
import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.kernel.BaseKernelTest;
import org.apache.openjpa.persistence.kernel.common.apps.EmbeddedOwnerPC;
import org.apache.openjpa.persistence.kernel.common.apps.EmbeddedPC;

public class TestSavepointEmbedded
extends BaseKernelTest {
    private int id = 10000;

    public TestSavepointEmbedded(String name) {
        super(name);
    }

    protected String getSavepointPlugin() {
        return "in-mem(PreFlush=false)";
    }

    protected boolean expectNewEmbeddedFailure() {
        return true;
    }

    @Override
    public Properties getProperties(String[] props) {
        Properties properties = super.getProperties(props);
        properties.put("openjpa.SavepointManager", this.getSavepointPlugin());
        return properties;
    }

    public void setUp() {
        this.deleteAll(EmbeddedOwnerPC.class);
    }

    private EmbeddedOwnerPC newEmbeddedOwnerPC() {
        return new EmbeddedOwnerPC(this.id++, this.id++);
    }

    public void testClearNew() throws Exception {
        this.doClearNewTest(true, 0, 0);
        this.doClearNewTest(true, 2, 0);
        this.doClearNewTest(true, 0, 2);
        this.doClearNewTest(true, 2, 2);
        this.doClearNewTest(false, 0, 0);
        this.doClearNewTest(false, 2, 0);
        this.doClearNewTest(false, 0, 2);
        this.doClearNewTest(false, 2, 2);
    }

    public void doClearNewTest(boolean newPC, int before, int after) throws Exception {
        this.deleteAll(EmbeddedOwnerPC.class);
        OpenJPAEntityManager pm = this.getPM();
        this.startTx((EntityManager)pm);
        EmbeddedOwnerPC pc = this.newEmbeddedOwnerPC();
        pm.persist((Object)pc);
        pc.setStringField("orig");
        Object oid = pm.getObjectId((Object)pc);
        if (!newPC) {
            this.endTx((EntityManager)pm);
            this.endEm((EntityManager)pm);
            pm = this.getPM();
            this.startTx((EntityManager)pm);
            pc = (EmbeddedOwnerPC)pm.find(EmbeddedOwnerPC.class, oid);
        }
        for (int i = 0; i < before; ++i) {
            pc.setStringField("b" + i);
            pm.setSavepoint("b" + i);
        }
        pc.setStringField("test");
        pm.setSavepoint("test");
        EmbeddedPC embed = new EmbeddedPC();
        embed.setIntField(99);
        pc.setEmbedded(embed);
        for (int i = 0; i < after; ++i) {
            pc.setStringField("a" + i);
            pm.setSavepoint("a" + i);
        }
        pm.rollbackToSavepoint("test");
        if (newPC) {
            TestSavepointEmbedded.assertNull((Object)pc.getEmbedded());
        } else {
            TestSavepointEmbedded.assertEquals((int)0, (int)pc.getEmbedded().getIntField());
        }
        TestSavepointEmbedded.assertEquals((String)"test", (String)pc.getStringField());
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }

    public void testEmbeddedReassign() {
        this.doEmbeddedReassignTest(true, 0, 0);
        this.doEmbeddedReassignTest(true, 2, 0);
        this.doEmbeddedReassignTest(true, 0, 2);
        this.doEmbeddedReassignTest(true, 2, 2);
        this.doEmbeddedReassignTest(false, 0, 0);
        this.doEmbeddedReassignTest(false, 2, 0);
        this.doEmbeddedReassignTest(false, 0, 2);
        this.doEmbeddedReassignTest(false, 2, 2);
    }

    public void doEmbeddedReassignTest(boolean newPC, int before, int after) {
        int i;
        this.deleteAll(EmbeddedOwnerPC.class);
        this.deleteAll(EmbeddedPC.class);
        OpenJPAEntityManager pm = this.getPM();
        this.startTx((EntityManager)pm);
        EmbeddedOwnerPC pc = this.newEmbeddedOwnerPC();
        EmbeddedPC embed = new EmbeddedPC();
        embed.setIntField1(1000);
        pc.setStringField("orig");
        pm.persist((Object)pc);
        pc.setEmbedded(embed);
        Object oid = pm.getObjectId((Object)pc);
        if (!newPC) {
            this.endTx((EntityManager)pm);
            this.endEm((EntityManager)pm);
            pm = this.getPM();
            this.startTx((EntityManager)pm);
            pc = (EmbeddedOwnerPC)pm.find(EmbeddedOwnerPC.class, oid);
        }
        for (i = 0; i < before; ++i) {
            pc.setStringField("b" + i);
            pm.setSavepoint("b" + i);
        }
        pm.setSavepoint("test");
        embed = new EmbeddedPC();
        embed.setIntField1(2000);
        pc.setEmbedded(embed);
        for (i = 0; i < after; ++i) {
            pc.setStringField("b" + i);
            pm.setSavepoint("a" + i);
        }
        pm.rollbackToSavepoint("test");
        TestSavepointEmbedded.assertNotNull((Object)pc.getEmbedded());
        TestSavepointEmbedded.assertEquals((int)1000, (int)pc.getEmbedded().getIntField1());
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }

    public void testEmbeddedChange() throws Exception {
        try {
            this.doEmbeddedChangeTest(true, 0, 0);
            this.doEmbeddedChangeTest(true, 2, 0);
            this.doEmbeddedChangeTest(true, 0, 2);
            this.doEmbeddedChangeTest(true, 2, 2);
        }
        catch (Throwable t) {
            if (this.expectNewEmbeddedFailure()) {
                this.bug(1141, t, "changes to new embedded not detected");
            }
            throw (Exception)t;
        }
        this.doEmbeddedChangeTest(false, 0, 0);
        this.doEmbeddedChangeTest(false, 2, 0);
        this.doEmbeddedChangeTest(false, 0, 2);
        this.doEmbeddedChangeTest(false, 2, 2);
    }

    public void doEmbeddedChangeTest(boolean newPC, int before, int after) {
        int i;
        this.deleteAll(EmbeddedOwnerPC.class);
        OpenJPAEntityManager pm = this.getPM();
        this.startTx((EntityManager)pm);
        EmbeddedOwnerPC pc = this.newEmbeddedOwnerPC();
        EmbeddedPC embed = new EmbeddedPC();
        embed.setIntField1(1000);
        pc.setStringField("orig");
        pm.persist((Object)pc);
        pc.setEmbedded(embed);
        Object oid = pm.getObjectId((Object)pc);
        if (!newPC) {
            this.endTx((EntityManager)pm);
            this.endEm((EntityManager)pm);
            pm = this.getPM();
            this.startTx((EntityManager)pm);
            pc = (EmbeddedOwnerPC)pm.find(EmbeddedOwnerPC.class, oid);
        }
        for (i = 0; i < before; ++i) {
            pc.setStringField("b" + i);
            pm.setSavepoint("b" + i);
        }
        pm.setSavepoint("test");
        pc.getEmbedded().setIntField1(2000);
        for (i = 0; i < after; ++i) {
            pc.setStringField("a" + i);
            pm.setSavepoint("a" + i);
        }
        pm.rollbackToSavepoint("test");
        TestSavepointEmbedded.assertNotNull((Object)pc.getEmbedded());
        TestSavepointEmbedded.assertEquals((int)1000, (int)pc.getEmbedded().getIntField1());
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }

    public void testEmbeddedChange2() throws Exception {
        try {
            this.doEmbeddedChangeTest2(true, 0, 0);
            this.doEmbeddedChangeTest2(true, 2, 0);
            this.doEmbeddedChangeTest2(true, 0, 2);
            this.doEmbeddedChangeTest2(true, 2, 2);
        }
        catch (Throwable t) {
            if (this.expectNewEmbeddedFailure()) {
                this.bug(1141, t, "changes to new embedded not detected");
            }
            throw (Exception)t;
        }
        this.doEmbeddedChangeTest2(false, 0, 0);
        this.doEmbeddedChangeTest2(false, 2, 0);
        this.doEmbeddedChangeTest2(false, 0, 2);
        this.doEmbeddedChangeTest2(false, 2, 2);
    }

    public void doEmbeddedChangeTest2(boolean newPC, int before, int after) {
        int i;
        this.deleteAll(EmbeddedOwnerPC.class);
        this.deleteAll(EmbeddedPC.class);
        OpenJPAEntityManager pm = this.getPM();
        this.startTx((EntityManager)pm);
        EmbeddedOwnerPC pc = this.newEmbeddedOwnerPC();
        EmbeddedPC embed = new EmbeddedPC();
        embed.setIntField1(1000);
        pc.setStringField("orig");
        pm.persist((Object)pc);
        pc.setEmbedded(embed);
        Object oid = pm.getObjectId((Object)pc);
        if (!newPC) {
            this.endTx((EntityManager)pm);
            this.endEm((EntityManager)pm);
            pm = this.getPM();
            this.startTx((EntityManager)pm);
            pc = (EmbeddedOwnerPC)pm.find(EmbeddedOwnerPC.class, oid);
        }
        for (i = 0; i < before; ++i) {
            pc.getEmbedded().setIntField1(i);
            pm.setSavepoint("b" + i);
        }
        pm.setSavepoint("test");
        pc.getEmbedded().setIntField1(2000);
        for (i = 0; i < after; ++i) {
            pc.getEmbedded().setIntField1(i * -1);
            pm.setSavepoint("a" + i);
        }
        pm.rollbackToSavepoint("test");
        TestSavepointEmbedded.assertNotNull((Object)pc.getEmbedded());
        if (before == 0) {
            TestSavepointEmbedded.assertEquals((int)1000, (int)pc.getEmbedded().getIntField1());
        } else {
            TestSavepointEmbedded.assertEquals((int)(before - 1), (int)pc.getEmbedded().getIntField1());
        }
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }
}

