/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.kernel.BaseKernelTest;
import org.apache.openjpa.persistence.kernel.common.apps.RuntimeTest1;
import org.apache.openjpa.persistence.kernel.common.apps.RuntimeTest2;
import org.apache.openjpa.persistence.kernel.common.apps.RuntimeTest3;

public class TestQueries
extends BaseKernelTest {
    private static final int CHILD_COUNT = 3;
    private int id = 10000;

    public TestQueries(String name) {
        super(name);
    }

    public TestQueries() {
    }

    public void setUp() throws Exception {
        super.setUp(RuntimeTest1.class, RuntimeTest2.class, RuntimeTest3.class);
    }

    public void testSimpleQuery() {
        OpenJPAEntityManager pm = this.getPM();
        this.persist(this.newRuntimeTest1("SimpleQueryA", 50), pm);
        this.persist(this.newRuntimeTest2("SimpleQueryB", 50), pm);
        Collection results = this.runQuery(RuntimeTest1.class, false, "stringField = 'SimpleQueryA'", pm);
        TestQueries.assertEquals((int)1, (int)results.size());
        results = this.runQuery(RuntimeTest1.class, true, "intField1 = 50", pm);
        TestQueries.assertEquals((int)2, (int)results.size());
        results = this.runQuery(RuntimeTest2.class, true, "intField1 = 50", pm);
        TestQueries.assertEquals((int)1, (int)results.size());
        results = this.runQuery(RuntimeTest2.class, false, "intField1 = 50", pm);
        TestQueries.assertEquals((int)1, (int)results.size());
        this.endEm((EntityManager)pm);
    }

    public void testAndQuery() {
        String query = "intField1 > 10 AND o.intField1 < 50";
        for (int currentCount = 1; currentCount < 15; ++currentCount) {
            OpenJPAEntityManager pm = this.getPM();
            this.deleteByQuery(RuntimeTest1.class, false, query, pm);
            this.startTx((EntityManager)pm);
            for (int i = 1; i <= currentCount; ++i) {
                pm.persist((Object)this.newRuntimeTest1("AndQueryTest", 30 + i));
            }
            this.endTx((EntityManager)pm);
            Collection results = this.runQuery(RuntimeTest1.class, false, query, pm);
            TestQueries.assertEquals((int)currentCount, (int)results.size());
            this.endEm((EntityManager)pm);
        }
    }

    public void testRelationQuery() {
        this.relationQuery(10, "JOE", 20);
        this.relationQuery(99, "BOB", 2);
        this.relationQuery(3, "MARTHA", 1);
        this.relationQuery(5, "brenda", 43);
        this.relationQuery(43, "SarA", 55);
    }

    public void relationQuery(int intField, String stringField, int count) {
        OpenJPAEntityManager pm = this.getPM();
        String query = "selfOneOne.intField1 = " + intField + " AND o.selfOneOne.stringField = '" + stringField + "'";
        this.deleteByQuery(RuntimeTest1.class, true, query, pm);
        for (int currentcount = 0; currentcount <= count; ++currentcount) {
            if (currentcount != 0) {
                this.persist(this.newRuntimeTest2(stringField, intField), pm);
            }
            Collection results = this.runQuery(RuntimeTest1.class, true, query, pm);
            TestQueries.assertEquals((String)("query (" + query + ") failed to yield " + currentcount + " instances"), (int)(currentcount * 3), (int)results.size());
        }
        this.endEm((EntityManager)pm);
    }

    public void testQueryExecuteThrowsExceptionWhenNoNTR() {
        OpenJPAEntityManager pm = this.getPM();
        this.startTx((EntityManager)pm);
        pm.persist((Object)this.newRuntimeTest1("Query", 10));
        this.endTx((EntityManager)pm);
        pm.setNontransactionalRead(false);
        OpenJPAQuery q = pm.createQuery("SELECT o FROM RuntimeTest1 o");
        try {
            q.getResultList();
            TestQueries.fail((String)"Query.execute() should have thrown a JDOException when PM is outside a Transaction and NTR==false");
        }
        catch (Exception jdoe) {
            this.startTx((EntityManager)pm);
            q.getResultList();
            this.rollbackTx((EntityManager)pm);
        }
    }

    private void deleteByQuery(Class type, boolean subs, String filter, OpenJPAEntityManager pm) {
        this.startTx((EntityManager)pm);
        pm.createExtent(type, subs);
        String cstrng = type.getSimpleName();
        OpenJPAQuery query = pm.createQuery("SELECT o FROM " + cstrng + " o WHERE o." + filter);
        query.setSubclasses(subs);
        List items = query.getResultList();
        for (Object item : items) {
            pm.remove(item);
        }
        query = pm.createQuery("SELECT o FROM " + cstrng + " o WHERE o." + filter);
        query.setSubclasses(subs);
        items = query.getResultList();
        this.endTx((EntityManager)pm);
        TestQueries.assertEquals((String)("after deleting from query (" + query + "), there should have been zero items"), (int)0, (int)items.size());
    }

    private Collection runQuery(Class type, boolean subs, String filter, OpenJPAEntityManager pm) {
        pm.createExtent(type, subs);
        String cstrng = type.getName();
        OpenJPAQuery query = pm.createQuery("SELECT o FROM " + cstrng + " o WHERE o." + filter);
        query.setSubclasses(subs);
        List results = query.getResultList();
        return results;
    }

    private void persist(RuntimeTest1 parent, OpenJPAEntityManager pm) {
        for (int i = 0; i < 3; ++i) {
            RuntimeTest1 child = this.newRuntimeTest1("CHILD" + i, i * 10);
            child.setSelfOneOne(parent);
            parent.getSelfOneMany().add(child);
        }
        this.startTx((EntityManager)pm);
        pm.persist((Object)parent);
        this.endTx((EntityManager)pm);
    }

    private RuntimeTest1 newRuntimeTest1(String stringField, int intField) {
        RuntimeTest1 pc = new RuntimeTest1(stringField, intField);
        pc.setIntField(this.id++);
        return pc;
    }

    private RuntimeTest2 newRuntimeTest2(String stringField, int intField) {
        RuntimeTest2 pc = new RuntimeTest2(stringField, intField);
        pc.setIntField(this.id++);
        return pc;
    }
}

