/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import java.sql.Timestamp;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.persistence.EntityManager;
import org.apache.openjpa.lib.util.collections.ComparableComparator;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.kernel.BaseKernelTest;
import org.apache.openjpa.persistence.kernel.common.apps.ProxiesPC;
import org.apache.openjpa.util.Proxy;

public class TestProxies2
extends BaseKernelTest {
    private int _oid = 0;
    private Date _date = null;
    private java.sql.Date _sqlDate = null;
    private Timestamp _timestamp = null;

    public TestProxies2(String casename) {
        super(casename);
    }

    public void setUp() throws Exception {
        super.setUp(ProxiesPC.class);
        OpenJPAEntityManager pm = this.getPM(false, false);
        this.startTx((EntityManager)pm);
        long now = System.currentTimeMillis();
        this._date = new Date(now);
        this._sqlDate = new java.sql.Date(now);
        this._timestamp = new Timestamp(now);
        ProxiesPC pc = new ProxiesPC("main");
        pc.setDate(this._date);
        pc.setSQLDate(this._sqlDate);
        pc.setTimestamp(this._timestamp);
        pc.getStringSet().add("val1");
        pc.getStringSet().add("val2");
        pc.getStringSet().add("val3");
        pc.getStringSet().add(null);
        pc.getProxySet().add(new ProxiesPC("set1"));
        pc.getProxySet().add(new ProxiesPC("set2"));
        pc.getProxySet().add(new ProxiesPC("set3"));
        pc.getStringMap().put("key1", "1");
        pc.getStringMap().put("key2", "2");
        pc.getStringMap().put("key3", "3");
        pc.getStringMap().put(null, "null");
        pc.getStringMap().put("null", null);
        pc.getProxyMap().put("key1", new ProxiesPC("map1"));
        pc.getProxyMap().put("key2", new ProxiesPC("map2"));
        pc.getProxyMap().put("key3", new ProxiesPC("map3"));
        pc.getList().add("val1");
        pc.getList().add("val1");
        pc.getList().add("val2");
        pc.getList().add("val3");
        pc.getList().add("val3");
        pm.persist((Object)pc);
        this._oid = pc.getId();
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }

    public void testStringSet() {
        OpenJPAEntityManager pm = this.getPM(false, false);
        this.startTx((EntityManager)pm);
        ProxiesPC pc = (ProxiesPC)pm.find(ProxiesPC.class, (Object)this._oid);
        Set set = pc.getStringSet();
        TestProxies2.assertEquals((int)4, (int)set.size());
        TestProxies2.assertTrue((boolean)set.contains("val1"));
        TestProxies2.assertTrue((boolean)set.contains("val2"));
        TestProxies2.assertTrue((boolean)set.contains("val3"));
        TestProxies2.assertTrue((boolean)set.contains(null));
        set.remove("val1");
        set.remove("val1");
        set.add("val4");
        set.remove("val4");
        set.add("val5");
        set.add("val5");
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.getPM(false, false);
        pc = (ProxiesPC)pm.find(ProxiesPC.class, (Object)this._oid);
        set = pc.getStringSet();
        TestProxies2.assertEquals((int)4, (int)set.size());
        TestProxies2.assertTrue((!set.contains("val1") ? 1 : 0) != 0);
        TestProxies2.assertTrue((boolean)set.contains("val2"));
        TestProxies2.assertTrue((boolean)set.contains("val3"));
        TestProxies2.assertTrue((!set.contains("val4") ? 1 : 0) != 0);
        TestProxies2.assertTrue((boolean)set.contains("val5"));
        TestProxies2.assertTrue((boolean)set.contains(null));
        this.endEm((EntityManager)pm);
    }

    public void testStringMap() {
        OpenJPAEntityManager pm = this.getPM(false, false);
        this.startTx((EntityManager)pm);
        ProxiesPC pc = (ProxiesPC)pm.find(ProxiesPC.class, (Object)this._oid);
        Map map = pc.getStringMap();
        TestProxies2.assertEquals((int)5, (int)map.size());
        TestProxies2.assertEquals((Object)"1", map.get("key1"));
        TestProxies2.assertEquals((Object)"2", map.get("key2"));
        TestProxies2.assertEquals((Object)"3", map.get("key3"));
        TestProxies2.assertNull(map.get("null"));
        TestProxies2.assertEquals((Object)"null", map.get(null));
        map.put("key1", "1a");
        map.put("key1", "1b");
        map.put("key4", "4");
        map.remove("key4");
        map.remove("foo");
        map.put("key5", "5");
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.getPM(false, false);
        pc = (ProxiesPC)pm.find(ProxiesPC.class, (Object)this._oid);
        map = pc.getStringMap();
        TestProxies2.assertEquals((int)6, (int)map.size());
        TestProxies2.assertEquals((Object)"1b", map.get("key1"));
        TestProxies2.assertEquals((Object)"5", map.get("key5"));
        this.endEm((EntityManager)pm);
    }

    public void testProxySet() {
        OpenJPAEntityManager pm = this.getPM(false, false);
        this.startTx((EntityManager)pm);
        ProxiesPC pc = (ProxiesPC)pm.find(ProxiesPC.class, (Object)this._oid);
        TreeSet set = pc.getProxySet();
        TestProxies2.assertEquals((int)3, (int)set.size());
        Iterator itr = set.iterator();
        ProxiesPC set1 = (ProxiesPC)itr.next();
        ProxiesPC set2 = (ProxiesPC)itr.next();
        ProxiesPC set3 = (ProxiesPC)itr.next();
        TestProxies2.assertEquals((String)"set1", (String)set1.getName());
        TestProxies2.assertEquals((String)"set2", (String)set2.getName());
        TestProxies2.assertEquals((String)"set3", (String)set3.getName());
        set.remove(set1);
        set.remove(set1);
        ProxiesPC set4 = new ProxiesPC("set4");
        set.add(set4);
        set.remove(set4);
        ProxiesPC set5 = new ProxiesPC("set5");
        set.add(set5);
        set.add(set5);
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.getPM(true, false);
        this.startTx((EntityManager)pm);
        pc = (ProxiesPC)pm.find(ProxiesPC.class, (Object)this._oid);
        pm.refresh((Object)pc);
        set = pc.getProxySet();
        TestProxies2.assertEquals((int)3, (int)set.size());
        itr = set.iterator();
        set1 = (ProxiesPC)itr.next();
        set2 = (ProxiesPC)itr.next();
        set3 = (ProxiesPC)itr.next();
        TestProxies2.assertEquals((String)"set2", (String)set1.getName());
        TestProxies2.assertEquals((String)"set3", (String)set2.getName());
        TestProxies2.assertEquals((String)"set5", (String)set3.getName());
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }

    public void testProxyMap() {
        OpenJPAEntityManager pm = this.getPM(false, false);
        this.startTx((EntityManager)pm);
        ProxiesPC pc = (ProxiesPC)pm.find(ProxiesPC.class, (Object)this._oid);
        TreeMap map = pc.getProxyMap();
        TestProxies2.assertEquals((String)"original map size is correct: 3", (int)3, (int)map.size());
        ProxiesPC map1 = (ProxiesPC)map.get("key1");
        ProxiesPC map2 = (ProxiesPC)map.get("key2");
        ProxiesPC map3 = (ProxiesPC)map.get("key3");
        TestProxies2.assertEquals((String)"map1", (String)map1.getName());
        TestProxies2.assertEquals((String)"map2", (String)map2.getName());
        TestProxies2.assertEquals((String)"map3", (String)map3.getName());
        ProxiesPC map1a = new ProxiesPC("map1a");
        map.put("key1", map1a);
        ProxiesPC map1b = new ProxiesPC("map1b");
        map.put("key1", map1b);
        map.put("key4", new ProxiesPC("map4"));
        map.remove("key4");
        map.remove("foo");
        map.put("key5", new ProxiesPC("map5"));
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.getPM(false, false);
        pc = (ProxiesPC)pm.find(ProxiesPC.class, (Object)this._oid);
        this.startTx((EntityManager)pm);
        pm.refresh((Object)pc);
        map = pc.getProxyMap();
        TestProxies2.assertEquals((int)4, (int)map.size());
        TestProxies2.assertEquals((String)"map1b", (String)((ProxiesPC)map.get("key1")).getName());
        TestProxies2.assertEquals((String)"map5", (String)((ProxiesPC)map.get("key5")).getName());
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }

    public void testReplace() {
        OpenJPAEntityManager pm = this.getPM(false, false);
        this.startTx((EntityManager)pm);
        ProxiesPC pc = (ProxiesPC)pm.find(ProxiesPC.class, (Object)this._oid);
        Set set = new HashSet<String>();
        set.add("new");
        pc.setStringSet(set);
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.getPM(false, false);
        pc = (ProxiesPC)pm.find(ProxiesPC.class, (Object)this._oid);
        set = pc.getStringSet();
        TestProxies2.assertEquals((int)1, (int)set.size());
        TestProxies2.assertTrue((boolean)set.contains("new"));
        this.endEm((EntityManager)pm);
    }

    public void testComparators() {
        OpenJPAEntityManager pm = this.getPM(false, false);
        this.startTx((EntityManager)pm);
        ProxiesPC pc = (ProxiesPC)pm.find(ProxiesPC.class, (Object)this._oid);
        TestProxies2.assertNotNull((String)"pc is null", (Object)pc);
        TestProxies2.assertTrue((String)"pc.getComp() is not instanceof Proxy", (boolean)(pc.getComp() instanceof Proxy));
        TestProxies2.assertTrue((String)"(TreeSet) is not pc.getComp()).comparator() instanceof ComparableComparator", (boolean)(((TreeSet)pc.getComp()).comparator() instanceof ComparableComparator));
        pm.evict((Object)pc);
        this.endTx((EntityManager)pm);
        TestProxies2.assertTrue((String)"pc.getComp() is not instanceof ProxyTreeSet", (boolean)(pc.getComp() instanceof Proxy));
        Comparator compart = ((TreeSet)pc.getComp()).comparator();
        TestProxies2.assertNotNull((String)"compart is null", compart);
        TestProxies2.assertTrue((String)"((TreeSet) is not pc.getComp()).comparator()instanceof ComparableComparator", (boolean)(((TreeSet)pc.getComp()).comparator() instanceof ComparableComparator));
        this.endEm((EntityManager)pm);
    }

    public void testChangeListOrder() {
        OpenJPAEntityManager pm = this.getPM(false, false);
        this.startTx((EntityManager)pm);
        ProxiesPC pc = (ProxiesPC)pm.find(ProxiesPC.class, (Object)this._oid);
        List list = pc.getList();
        TestProxies2.assertEquals((int)5, (int)list.size());
        TestProxies2.assertEquals((Object)"val1", list.get(0));
        TestProxies2.assertEquals((Object)"val1", list.get(1));
        TestProxies2.assertEquals((Object)"val2", list.get(2));
        TestProxies2.assertEquals((Object)"val3", list.get(3));
        TestProxies2.assertEquals((Object)"val3", list.get(4));
        list.remove("val2");
        list.add("val2");
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.getPM(false, false);
        pc = (ProxiesPC)pm.find(ProxiesPC.class, (Object)this._oid);
        list = pc.getList();
        TestProxies2.assertEquals((int)5, (int)list.size());
        TestProxies2.assertEquals((Object)"val1", list.get(0));
        TestProxies2.assertEquals((Object)"val1", list.get(1));
        TestProxies2.assertEquals((Object)"val2", list.get(2));
        TestProxies2.assertEquals((Object)"val3", list.get(3));
        TestProxies2.assertEquals((Object)"val3", list.get(4));
        this.endEm((EntityManager)pm);
    }

    public void testDate() {
        OpenJPAEntityManager pm = this.getPM(true, true);
        this.startTx((EntityManager)pm);
        ProxiesPC pc = (ProxiesPC)pm.find(ProxiesPC.class, (Object)this._oid);
        Date date = pc.getDate();
        TestProxies2.assertNotNull((Object)date);
        TestProxies2.assertEquals((int)this._date.getYear(), (int)date.getYear());
        TestProxies2.assertEquals((int)this._date.getMonth(), (int)date.getMonth());
        TestProxies2.assertEquals((int)this._date.getDate(), (int)date.getDate());
        TestProxies2.assertTrue((!pm.isDirty((Object)pc) ? 1 : 0) != 0);
        date.setTime(System.currentTimeMillis() + 86400000L);
        TestProxies2.assertTrue((boolean)pm.isDirty((Object)pc));
        this.endTx((EntityManager)pm);
        TestProxies2.assertEquals((Object)date, (Object)pc.getDate());
        this.endEm((EntityManager)pm);
    }

    public void testSQLDate() {
        OpenJPAEntityManager pm = this.getPM(true, true);
        this.startTx((EntityManager)pm);
        ProxiesPC pc = (ProxiesPC)pm.find(ProxiesPC.class, (Object)this._oid);
        java.sql.Date date = pc.getSQLDate();
        TestProxies2.assertNotNull((Object)date);
        TestProxies2.assertEquals((int)this._sqlDate.getYear(), (int)date.getYear());
        TestProxies2.assertEquals((int)this._sqlDate.getMonth(), (int)date.getMonth());
        TestProxies2.assertEquals((int)this._sqlDate.getDate(), (int)date.getDate());
        TestProxies2.assertTrue((!pm.isDirty((Object)pc) ? 1 : 0) != 0);
        date.setTime(System.currentTimeMillis() + 86400000L);
        TestProxies2.assertTrue((boolean)pm.isDirty((Object)pc));
        this.endTx((EntityManager)pm);
        TestProxies2.assertEquals((Object)date, (Object)pc.getSQLDate());
        this.endEm((EntityManager)pm);
    }

    public void testTimestamp() {
        OpenJPAEntityManager pm = this.getPM(true, true);
        this.startTx((EntityManager)pm);
        ProxiesPC pc = (ProxiesPC)pm.find(ProxiesPC.class, (Object)this._oid);
        Timestamp tstamp = pc.getTimestamp();
        TestProxies2.assertNotNull((Object)tstamp);
        TestProxies2.assertEquals((int)this._timestamp.getYear(), (int)tstamp.getYear());
        TestProxies2.assertEquals((int)this._timestamp.getMonth(), (int)tstamp.getMonth());
        TestProxies2.assertEquals((int)this._timestamp.getDate(), (int)tstamp.getDate());
        TestProxies2.assertTrue((!pm.isDirty((Object)pc) ? 1 : 0) != 0);
        tstamp.setNanos(100);
        TestProxies2.assertTrue((boolean)pm.isDirty((Object)pc));
        this.endTx((EntityManager)pm);
        TestProxies2.assertEquals((Object)tstamp, (Object)pc.getTimestamp());
        this.endEm((EntityManager)pm);
    }
}

