/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.conf.OpenJPAConfigurationImpl;
import org.apache.openjpa.event.LifecycleEvent;
import org.apache.openjpa.event.LoadListener;
import org.apache.openjpa.kernel.AbstractBrokerFactory;
import org.apache.openjpa.kernel.BrokerImpl;
import org.apache.openjpa.kernel.StoreManager;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.ConfigurationProvider;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.kernel.BaseKernelTest;
import org.apache.openjpa.persistence.kernel.common.apps.RuntimeTest1;
import org.apache.openjpa.persistence.kernel.common.apps.RuntimeTest4;

public class TestPersistenceManagerFactoryImpl
extends BaseKernelTest {
    private OpenJPAConfiguration _conf = null;

    public TestPersistenceManagerFactoryImpl() {
    }

    public TestPersistenceManagerFactoryImpl(String test) {
        super(test);
    }

    public void setUp() {
        this._conf = new OpenJPAConfigurationImpl();
        this._conf.setConnection2UserName("user");
        this._conf.setConnection2Password("pass");
        this._conf.setConnection2URL("url");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFactoryLifecycleListeners() {
        OpenJPAEntityManagerFactory pmf = this.getEmf();
        OpenJPAEntityManagerFactorySPI pmfSPI = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.cast((EntityManagerFactory)pmf);
        LoadListener listener = new LoadListener(){

            public void afterLoad(LifecycleEvent ev) {
            }

            public void afterRefresh(LifecycleEvent ev) {
            }
        };
        pmfSPI.addLifecycleListener((Object)listener, new Class[]{RuntimeTest4.class});
        try {
            BrokerImpl broker = (BrokerImpl)JPAFacadeHelper.toBroker((EntityManager)pmf.createEntityManager());
            MetaDataRepository repos = broker.getConfiguration().getMetaDataRepositoryInstance();
            TestPersistenceManagerFactoryImpl.assertTrue((String)"no listeners defined added to Runtimetest4", (boolean)broker.getLifecycleEventManager().hasLoadListeners((Object)new RuntimeTest4("foo"), repos.getMetaData(RuntimeTest4.class, null, true)));
            TestPersistenceManagerFactoryImpl.assertFalse((String)"there should be listeners def for runtimetest1", (boolean)broker.getLifecycleEventManager().hasLoadListeners((Object)new RuntimeTest1(), repos.getMetaData(RuntimeTest1.class, null, true)));
            broker.close();
        }
        finally {
            pmfSPI.removeLifecycleListener((Object)listener);
        }
    }

    public void testPlatform() {
        OpenJPAEntityManagerFactory pmf = this.getEmf();
        TestPersistenceManagerFactoryImpl.assertNotNull(pmf.getProperties().get("Platform"));
    }

    @Override
    protected OpenJPAEntityManagerFactory getEmf(Map props) {
        props.put("openjpa.BrokerFactory", BrokerFactoryTest.class.getName());
        return super.getEmf(props);
    }

    public static class BrokerFactoryTest
    extends AbstractBrokerFactory {
        private static final long serialVersionUID = 1L;

        public static synchronized BrokerFactoryTest getInstance(ConfigurationProvider cp) {
            Object key = BrokerFactoryTest.toPoolKey((Map)cp.getProperties());
            BrokerFactoryTest factory = (BrokerFactoryTest)BrokerFactoryTest.getPooledFactoryForKey((Object)key);
            if (factory != null) {
                return factory;
            }
            factory = BrokerFactoryTest.newInstance(cp);
            BrokerFactoryTest.pool((Object)key, (AbstractBrokerFactory)factory);
            return factory;
        }

        public static BrokerFactoryTest newInstance(ConfigurationProvider cp) {
            OpenJPAConfigurationImpl conf = new OpenJPAConfigurationImpl();
            cp.setInto((Configuration)conf);
            return new BrokerFactoryTest((OpenJPAConfiguration)conf);
        }

        protected BrokerFactoryTest(OpenJPAConfiguration conf) {
            super(conf);
        }

        protected StoreManager newStoreManager() {
            return null;
        }
    }
}

