/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import org.apache.openjpa.event.AbstractTransactionListener;
import org.apache.openjpa.event.TransactionEvent;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.kernel.BaseKernelTest;
import org.apache.openjpa.persistence.kernel.common.apps.RuntimeTest1;

public class TestPMMemory
extends BaseKernelTest {
    private static final boolean _doPause = false;
    private static final int NUM_OBJECTS = 2000;
    private static final int NUM_FLUSHES = 5;
    static int _fetchGroupSerial = 0;

    public TestPMMemory() {
    }

    public TestPMMemory(String s) {
        super(s);
    }

    public boolean skipTest() {
        return true;
    }

    public static void main(String[] args) throws Exception {
        TestPMMemory testpm = new TestPMMemory("testPMMemory");
        testpm.setUp();
        testpm.testMemoryUse();
    }

    public void setUp() {
        System.out.println("About to delete all");
        this.deleteAllStaged(this.getPM(), RuntimeTest1.class);
        System.out.println("Done delete all");
    }

    public void deleteAllStaged(OpenJPAEntityManager pmArg, Class classType) {
        int delCount = 0;
        boolean needToDelete = true;
        while (needToDelete) {
            OpenJPAEntityManager pm = this.getPM();
            this.startTx((EntityManager)pm);
            pm.setTrackChangesByType(true);
            String cstrng = classType.getName();
            OpenJPAQuery kq = pm.createQuery("SELECT o FROM " + cstrng + " o");
            kq.getFetchPlan().setFetchBatchSize(100);
            List results = kq.getResultList();
            if (results.size() == 0) {
                needToDelete = false;
                break;
            }
            System.out.println("We need to delete " + results.size());
            Iterator iter = results.iterator();
            while (iter.hasNext()) {
                pm.remove(iter.next());
                if (++delCount % 800 != 0) continue;
                pm.flush();
                break;
            }
            System.out.print("deleted 200");
            this.endTx((EntityManager)pm);
            this.endEm((EntityManager)pm);
        }
        System.out.println("Done deleting");
    }

    private void reportMemory() {
        this.reportMemory("Memory used");
    }

    private void reportMemory(String msg) {
        System.gc();
        long memUsed = Runtime.getRuntime().totalMemory();
        long memFree = Runtime.getRuntime().freeMemory();
        System.out.println("" + msg + " : " + memUsed + ", " + memFree);
    }

    private void pause(double seconds) {
    }

    public void testMemoryUse() throws Exception {
        System.out.println("Baseline, starting memory for N objects of 2000");
        OpenJPAEntityManagerFactory kpmf = this.getEmf();
        OpenJPAEntityManager kpm = kpmf.createEntityManager();
        this.startTx((EntityManager)kpm);
        int runningId = this.performAddsModifiesDeletes(kpm, 2000, 0);
        this.endTx((EntityManager)kpm);
        System.out.println("Baseline, starting memory ");
        this.reportMemory();
        AbstractTransactionListener l = new AbstractTransactionListener(){

            public void afterCommit(TransactionEvent ev) {
                System.out.println("My Listener in afterCommit");
                System.out.println("Num objects in transaction " + ev.getTransactionalObjects().size());
            }
        };
        this.startTx((EntityManager)kpm);
        int objCount = 0;
        for (int i = 0; i < 5; ++i) {
            System.out.println();
            System.out.println("Iteration #" + i + " created " + objCount);
            this.reportMemory();
            kpm.setTrackChangesByType(true);
            runningId = this.performAddsModifiesDeletes(kpm, 2000, runningId);
            objCount += 2000;
            kpm.flush();
            this.grabAllMemory();
        }
        System.out.println("Created objects, about to commit ()");
        this.pause(90.0);
        this.endTx((EntityManager)kpm);
        this.pause(1.0);
        System.out.println("Now commit ()");
        this.reportMemory();
        this.pause(33.0);
    }

    protected void grabAllMemory() {
        int[] glob;
        int size = 4096;
        boolean grab = true;
        while (grab) {
            try {
                glob = new int[size];
                size *= 2;
            }
            catch (OutOfMemoryError e) {
                System.out.println("Mem grabbed " + size);
                grab = false;
                glob = null;
            }
        }
        glob = null;
    }

    protected int performAddsModifiesDeletes(OpenJPAEntityManager pm, int numObjects, int runningId) {
        RuntimeTest1[] persistables = new RuntimeTest1[numObjects];
        for (int i = 0; i < persistables.length; ++i) {
            persistables[i] = new RuntimeTest1("foo #" + i, runningId + i);
        }
        runningId += persistables.length;
        for (RuntimeTest1 persistable : persistables) {
            pm.persist((Object)persistable);
        }
        for (int i = 0; i < persistables.length; ++i) {
            persistables[i].setIntField1(i + 1);
        }
        return runningId + 1;
    }

    protected OpenJPAEntityManagerFactory createDistinctFactory(Class providerClass, String classProps1) {
        Map props = null;
        return this.getEmf(props);
    }
}

