/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import java.io.Serializable;
import javax.persistence.EntityManager;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.kernel.BaseKernelTest;
import org.apache.openjpa.persistence.kernel.common.apps.PCClassInterface;
import org.apache.openjpa.persistence.kernel.common.apps.PCClassPC;

public class TestPCClass
extends BaseKernelTest {
    public TestPCClass() {
    }

    public TestPCClass(String test) {
        super(test);
    }

    public void setUp() throws Exception {
        super.setUp(PCClassPC.class);
    }

    public void testMetaData() {
        MetaDataRepository repos = this.getConfiguration().getMetaDataRepositoryInstance();
        ClassMetaData meta = repos.getMetaData(PCClassPC.class, null, true);
        FieldMetaData fmd = meta.getField("specificPC");
        TestPCClass.assertNotNull((String)"fmd is nulll", (Object)fmd);
        TestPCClass.assertEquals((String)"JavaTypes.PC != fmd.getTypeCode()", (int)15, (int)fmd.getTypeCode());
        TestPCClass.assertEquals((String)"PCClassPC.class.getName() != fmd.getType().getName()", (String)PCClassPC.class.getName(), (String)fmd.getType().getName());
        TestPCClass.assertEquals((String)"Object.class.getName() != fmd.getDeclaredType().getName()", (String)Object.class.getName(), (String)fmd.getDeclaredType().getName());
        fmd = meta.getField("genericPC");
        TestPCClass.assertNotNull((String)"fmd is null", (Object)fmd);
        TestPCClass.assertEquals((String)"JavaTypes.PC_UNTYPE != fmd.getTypeCode()", (int)27, (int)fmd.getTypeCode());
        TestPCClass.assertEquals((String)"PersistenceCapable.class.getName() != fmd.getType().getName()", (String)PersistenceCapable.class.getName(), (String)fmd.getType().getName());
        TestPCClass.assertEquals((String)Object.class.getName(), (String)fmd.getDeclaredType().getName());
        fmd = meta.getField("genericObject");
        TestPCClass.assertNotNull((Object)fmd);
        TestPCClass.assertEquals((int)8, (int)fmd.getTypeCode());
        TestPCClass.assertEquals((String)Object.class.getName(), (String)fmd.getType().getName());
        TestPCClass.assertEquals((String)Object.class.getName(), (String)fmd.getDeclaredType().getName());
        fmd = meta.getField("specificInterface");
        TestPCClass.assertNotNull((Object)fmd);
        TestPCClass.assertEquals((int)15, (int)fmd.getTypeCode());
        TestPCClass.assertEquals((String)PCClassPC.class.getName(), (String)fmd.getType().getName());
        TestPCClass.assertEquals((String)PCClassInterface.class.getName(), (String)fmd.getDeclaredType().getName());
        fmd = meta.getField("defaultInterface");
        TestPCClass.assertNotNull((Object)fmd);
        TestPCClass.assertEquals((int)27, (int)fmd.getTypeCode());
        TestPCClass.assertEquals((String)PCClassInterface.class.getName(), (String)fmd.getType().getName());
        TestPCClass.assertEquals((String)PCClassInterface.class.getName(), (String)fmd.getDeclaredType().getName());
        fmd = meta.getField("serializableInterface");
        TestPCClass.assertNotNull((Object)fmd);
        TestPCClass.assertEquals((int)8, (int)fmd.getTypeCode());
        TestPCClass.assertEquals((String)Serializable.class.getName(), (String)fmd.getType().getName());
        TestPCClass.assertEquals((String)Serializable.class.getName(), (String)fmd.getDeclaredType().getName());
        fmd = meta.getField("genericInterface");
        TestPCClass.assertNotNull((Object)fmd);
        TestPCClass.assertEquals((int)8, (int)fmd.getTypeCode());
        TestPCClass.assertEquals((String)Object.class.getName(), (String)fmd.getType().getName());
        TestPCClass.assertEquals((String)PCClassInterface.class.getName(), (String)fmd.getDeclaredType().getName());
    }

    public void testPersist() {
        PCClassPC pc = new PCClassPC();
        pc.setSpecificPC(pc);
        pc.setGenericPC(pc);
        pc.setGenericObject(pc);
        pc.setSpecificInterface(pc);
        pc.setDefaultInterface(pc);
        pc.setGenericInterface(pc);
        pc.setSerializableInterface(pc);
        OpenJPAEntityManager pm = this.getPM();
        this.startTx((EntityManager)pm);
        pm.persist((Object)pc);
        Object oid = pm.getObjectId((Object)pc);
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.getPM();
        pc = (PCClassPC)pm.find(PCClassPC.class, oid);
        TestPCClass.assertTrue((pc == pc.getSpecificPC() ? 1 : 0) != 0);
        TestPCClass.assertTrue((pc == pc.getGenericPC() ? 1 : 0) != 0);
        TestPCClass.assertNotNull((Object)pc.getGenericObject());
        TestPCClass.assertTrue((pc == pc.getGenericObject() ? 1 : 0) != 0);
        TestPCClass.assertTrue((pc == pc.getSpecificInterface() ? 1 : 0) != 0);
        TestPCClass.assertTrue((pc == pc.getDefaultInterface() ? 1 : 0) != 0);
        TestPCClass.assertNotNull((Object)pc.getGenericInterface());
        TestPCClass.assertTrue((pc == pc.getGenericInterface() ? 1 : 0) != 0);
        TestPCClass.assertNotNull((Object)pc.getSerializableInterface());
        TestPCClass.assertTrue((pc == pc.getSerializableInterface() ? 1 : 0) != 0);
        this.endEm((EntityManager)pm);
    }
}

