/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.persistence.kernel.BaseKernelTest;
import org.apache.openjpa.persistence.kernel.common.apps.RuntimeTest1;

public class TestOpenResultsCommit
extends BaseKernelTest {
    public TestOpenResultsCommit() {
    }

    public TestOpenResultsCommit(String testName) {
        super(testName);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.deleteAll(RuntimeTest1.class);
        OpenJPAEntityManager pm = this.getPM();
        this.startTx((EntityManager)pm);
        for (int i = 0; i < 50; ++i) {
            pm.persist((Object)new RuntimeTest1("open results #" + i, i));
        }
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }

    public void testCommitWithModeTransaction() {
        try {
            this.testCommitWithOpenResults("transaction");
        }
        catch (Exception e) {
            this.bug(EnumSet.of(AbstractTestCase.Platform.POINTBASE, AbstractTestCase.Platform.INFORMIX, AbstractTestCase.Platform.EMPRESS), 718, (Throwable)e, "Cannot keep results open across commit");
        }
    }

    public void testCommitWithModeOpenJPAEntityManager() {
        try {
            this.testCommitWithOpenResults("persistence-manager");
        }
        catch (Exception e) {
            this.bug(EnumSet.of(AbstractTestCase.Platform.POINTBASE, AbstractTestCase.Platform.INFORMIX, AbstractTestCase.Platform.EMPRESS), 718, (Throwable)e, "Cannot keep results open across commit");
        }
    }

    public void testCommitWithModeOnDemand() {
        try {
            this.testCommitWithOpenResults("on-demand");
        }
        catch (Exception e) {
            this.bug(EnumSet.of(AbstractTestCase.Platform.POINTBASE, AbstractTestCase.Platform.INFORMIX, AbstractTestCase.Platform.EMPRESS), 718, (Throwable)e, "Cannot keep results open across commit");
        }
    }

    private void testCommitWithOpenResults(String crm) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("openjpa.DefaultFetchThreshold", "1");
        props.put("openjpa.ConnectionRetainMode", crm);
        OpenJPAEntityManagerFactory pmf = this.getEmf(props);
        OpenJPAEntityManager pm = pmf.createEntityManager();
        this.startTx((EntityManager)pm);
        Iterator results = pm.createExtent(RuntimeTest1.class, false).iterator();
        results.next();
        ((RuntimeTest1)results.next()).setStringField("changed name");
        this.endTx((EntityManager)pm);
        while (results.hasNext()) {
            results.next();
        }
        this.endEm((EntityManager)pm);
    }
}

