/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.kernel.BaseKernelTest;
import org.apache.openjpa.persistence.kernel.common.apps.RuntimeTest4;
import org.apache.openjpa.persistence.kernel.common.apps.RuntimeTest5;

public class TestGetObjectsById
extends BaseKernelTest {
    private Object[] oids;

    public TestGetObjectsById(String name) {
        super(name);
    }

    public void setUp() {
        this.deleteAll(RuntimeTest5.class);
        this.deleteAll(RuntimeTest4.class);
        RuntimeTest4 rt4 = new RuntimeTest4("foo");
        RuntimeTest5 related0 = new RuntimeTest5("bar");
        related0.setRuntimeTest4(rt4);
        rt4.getRuntimeTest5s().add(related0);
        RuntimeTest5 related1 = new RuntimeTest5("baz");
        related1.setRuntimeTest4(rt4);
        rt4.getRuntimeTest5s().add(related1);
        OpenJPAEntityManager pm = this.getPM();
        this.startTx((EntityManager)pm);
        pm.persist((Object)rt4);
        this.endTx((EntityManager)pm);
        this.oids = new Object[]{pm.getObjectId((Object)rt4), pm.getObjectId((Object)related0), pm.getObjectId((Object)related1)};
        this.endEm((EntityManager)pm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetObjectsByIdInvocation() {
        OpenJPAEntityManager pm = this.getPM();
        try {
            Object[] pcs = pm.findAll(Object.class, this.oids);
            TestGetObjectsById.assertEquals((int)this.oids.length, (int)pcs.length);
            for (int i = 0; i < this.oids.length; ++i) {
                TestGetObjectsById.assertEquals((Object)this.oids[i], (Object)pm.getObjectId(pcs[i]));
            }
        }
        catch (Exception e) {
            this.bug(1017, e, "getObjectsById() bug");
        }
        finally {
            this.endEm((EntityManager)pm);
        }
    }
}

