/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import javax.persistence.EntityManager;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.kernel.BaseKernelTest;
import org.apache.openjpa.persistence.kernel.common.apps.RuntimeTest1;
import org.apache.openjpa.persistence.kernel.common.apps.RuntimeTest2;
import org.apache.openjpa.persistence.kernel.common.apps.RuntimeTest3;

public class TestFieldState
extends BaseKernelTest {
    private Object oid;

    public TestFieldState() {
    }

    public TestFieldState(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp(RuntimeTest1.class, RuntimeTest2.class, RuntimeTest3.class);
        OpenJPAEntityManager pm = this.getPM();
        this.startTx((EntityManager)pm);
        RuntimeTest1 a = new RuntimeTest1("foo", 3);
        pm.persist((Object)a);
        this.endTx((EntityManager)pm);
        this.oid = pm.getObjectId((Object)a);
        this.endEm((EntityManager)pm);
    }

    public void testNotDirtyAfterSameChange() {
        OpenJPAEntityManager pm = this.getPM();
        this.startTx((EntityManager)pm);
        RuntimeTest1 a = (RuntimeTest1)pm.find(RuntimeTest1.class, this.oid);
        a.setStringField(a.getStringField());
        OpenJPAStateManager sm = this.getStateManager(a, (EntityManager)pm);
        FieldMetaData fmd = sm.getMetaData().getField("stringField");
        TestFieldState.assertTrue((!sm.getDirty().get(fmd.getIndex()) ? 1 : 0) != 0);
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }
}

