/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import javax.persistence.EntityManager;
import junit.framework.AssertionFailedError;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.persistence.kernel.BaseKernelTest;
import org.apache.openjpa.persistence.kernel.common.apps.AllFieldTypesTest;
import org.junit.Assert;

public class TestFieldRange
extends BaseKernelTest {
    protected static String RANDOM_STRING = "This is my test String with all kinds of wierd characters: !@@#$\\%^&\"*()-=\\|\"\"\"\"\"+_/?.>,<~`'''''''''''\\\\\\\\\\\\\\\\\\\\\\\\\\\\''''''''''''\\\\\\\\\\\\\\\\\\\\\\\\\\\\!@@#$\\%^&\"*()-=\\|+_/?.>,<~`";

    public TestFieldRange() {
    }

    public TestFieldRange(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.deleteAll(AllFieldTypesTest.class);
    }

    public void testSaveState() throws Exception {
        this.allFieldSaveState(259645, (short)-14687, 2349847982L, 4.3273424E7f, 34678.02384723, (byte)-120, true, '%', new Date(), new StringBuffer(5000), RANDOM_STRING, TestFieldRange.randomBigInteger(), TestFieldRange.randomBigDecimal());
    }

    public void testLargeNumbersNegative() throws Exception {
        this.allFieldSaveState(-2147483647, (short)-32767, -9223372036854775807L, 1.0f, 1.0, (byte)-127, true, 'q', new Date(), new StringBuffer(5000), RANDOM_STRING, TestFieldRange.randomBigInteger(), TestFieldRange.randomBigDecimal());
    }

    public void testDoubleAndFloatPrecision() throws Exception {
        this.allFieldSaveState(0, (short)0, 0L, 3.3333333f, 33.333333333333336, (byte)0, true, 'q', new Date(), new StringBuffer(5000), RANDOM_STRING, TestFieldRange.randomBigInteger(), TestFieldRange.randomBigDecimal());
    }

    public void testZeroNumbers() throws Exception {
        this.allFieldSaveState(0, (short)0, 0L, 0.0f, 0.0, (byte)0, true, 'q', new Date(), new StringBuffer(5000), RANDOM_STRING, new BigInteger("0"), new BigDecimal("0.0"));
    }

    public void testLowDate() throws Exception {
        this.dateTest(0L);
    }

    public void testCurDate() throws Exception {
        this.dateTest(System.currentTimeMillis());
    }

    public void testHighDate() throws Exception {
        try {
            if (this.getCurrentPlatform() == AbstractTestCase.Platform.POSTGRESQL) {
                TestFieldRange.fail((String)"Postgres can't even try to store a high date");
            }
            this.dateTest(System.currentTimeMillis() * 2L);
        }
        catch (AssertionFailedError e) {
            this.bug(6, e, "Some data stores cannot deal with very high dates");
        }
    }

    public void testProblematicDates() throws Exception {
        this.dateTest(1047744639L);
    }

    private void dateTest(long l) throws Exception {
        Date d = new Date(l);
        this.allFieldSaveState(10, (short)10, 10L, 0.0f, 0.0, (byte)10, true, 'x', d, new StringBuffer(10), RANDOM_STRING, new BigInteger("0"), new BigDecimal("0"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allFieldSaveState(int testint, short testshort, long testlong, float testfloat, double testdouble, byte testbyte, boolean testboolean, char testchar, Date testDate, Serializable testObject, String testString, BigInteger testBigInteger, BigDecimal testBigDecimal) throws Exception {
        try {
            this.allFieldSaveStateInternal(testint, testshort, testlong, testfloat, testdouble, testbyte, testboolean, testchar, testDate, testObject, testString, testBigInteger, testBigDecimal);
        }
        finally {
            try {
                this.rollbackTx((EntityManager)this.getPM(true, false));
            }
            catch (Throwable throwable) {}
        }
    }

    public void allFieldSaveStateInternal(int testint, short testshort, long testlong, float testfloat, double testdouble, byte testbyte, boolean testboolean, char testchar, Date testDate, Serializable testObject, String testString, BigInteger testBigInteger, BigDecimal testBigDecimal) throws Exception {
        OpenJPAEntityManager pm = this.getPM(true, false);
        this.startTx((EntityManager)pm);
        AllFieldTypesTest test = new AllFieldTypesTest();
        pm.persist((Object)test);
        Object testID = pm.getObjectId((Object)test);
        test.setTestint(testint);
        test.setTestlong(testlong);
        test.setTestdouble(testdouble);
        test.setTestshort(testshort);
        test.setTestfloat(testfloat);
        test.setTestbyte(testbyte);
        test.setTestboolean(testboolean);
        test.setTestchar(testchar);
        test.setTestString(testString);
        test.setTestDate(testDate);
        test.setTestObject(testObject);
        test.setTestBigInteger(testBigInteger);
        test.setTestBigDecimal(testBigDecimal);
        try {
            this.endTx((EntityManager)pm);
        }
        catch (Exception e) {
            if (e instanceof Exception && e.getMessage().indexOf("Maximum length is 8000") != -1) {
                this.bug(AbstractTestCase.Platform.SQLSERVER, 5, (Throwable)e, "SQLServer cannot deal with numbers with more than 8000 digits");
            }
            throw e;
        }
        this.endEm((EntityManager)pm);
        pm = this.getPM(true, false);
        this.startTx((EntityManager)pm);
        AllFieldTypesTest retrievedObject = (AllFieldTypesTest)pm.find(AllFieldTypesTest.class, testID);
        TestFieldRange.assertEquals((String)"Field type int", (int)testint, (int)retrievedObject.getTestint());
        TestFieldRange.assertEquals((String)"Field type short", (short)testshort, (short)retrievedObject.getTestshort());
        TestFieldRange.assertEquals((String)"Field type boolean", (boolean)testboolean, (boolean)retrievedObject.getTestboolean());
        TestFieldRange.assertEquals((String)"Field type char", (char)testchar, (char)retrievedObject.getTestchar());
        TestFieldRange.assertEquals((String)"Field type long", (long)testlong, (long)retrievedObject.getTestlong());
        TestFieldRange.assertEquals((String)"Field type byte", (byte)testbyte, (byte)retrievedObject.getTestbyte());
        TestFieldRange.assertEquals((String)"Field type String", (String)testString, (String)retrievedObject.getTestString());
        int i1 = (int)(testDate.getTime() / 1000L);
        int i2 = (int)(retrievedObject.getTestDate().getTime() / 1000L);
        int testDateDay = testDate.getDay();
        int testDateMonth = testDate.getMonth();
        int testDateYear = testDate.getYear();
        int retrievedObjectDay = retrievedObject.getTestDate().getDay();
        int retrievedObjectMonth = retrievedObject.getTestDate().getMonth();
        int retrievedObjectYear = retrievedObject.getTestDate().getYear();
        System.out.println("i1 : " + i1 + "\ni2 : " + i2);
        if (testDateDay != retrievedObjectDay || testDateMonth != retrievedObjectMonth || testDateYear != retrievedObjectYear) {
            Assert.fail((String)("Field type Date not stored properly. One or more of the components of the date (day, month or year) do not match. \n Value that should be stored : " + testDate.toGMTString() + ". \nValue that is actuallystored : " + retrievedObject.getTestDate().toGMTString()));
        }
        TestFieldRange.assertEquals((String)"Field type BigInteger", (Object)testBigInteger, (Object)retrievedObject.getTestBigInteger());
        try {
            TestFieldRange.assertEquals((String)"Field type BigDecimal (BigInteger part)", (Object)testBigDecimal.toBigInteger(), (Object)retrievedObject.getTestBigDecimal().toBigInteger());
            TestFieldRange.assertEquals((String)"Field type BigDecimal", (Object)testBigDecimal, (Object)retrievedObject.getTestBigDecimal());
            TestFieldRange.assertEquals((String)"Field type float", (float)testfloat, (float)retrievedObject.getTestfloat(), (float)0.01f);
            TestFieldRange.assertEquals((String)"Field type double", (double)testdouble, (double)retrievedObject.getTestdouble(), (double)0.01);
        }
        catch (AssertionFailedError afe) {
            this.bug(3, afe, "Doubles and Floats lose precision in some data stores");
        }
        this.rollbackTx((EntityManager)pm);
    }
}

