/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import javax.persistence.EntityManager;
import junit.framework.AssertionFailedError;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.persistence.FetchPlan;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.kernel.BaseKernelTest;
import org.apache.openjpa.persistence.kernel.common.apps.AttachA;
import org.apache.openjpa.persistence.kernel.common.apps.AttachB;
import org.apache.openjpa.persistence.kernel.common.apps.AttachC;
import org.apache.openjpa.persistence.kernel.common.apps.AttachD;
import org.apache.openjpa.persistence.kernel.common.apps.AttachE;
import org.apache.openjpa.persistence.kernel.common.apps.AttachF;
import org.apache.openjpa.persistence.kernel.common.apps.FetchGroupTestObject;
import org.apache.openjpa.persistence.kernel.common.apps.FetchGroupTestObjectChild;

public class TestFetchGroups
extends BaseKernelTest {
    private int oid1;
    private int oid2;
    private int oidc1;

    public TestFetchGroups(String s) {
        super(s);
    }

    public TestFetchGroups() {
    }

    public void setUp() throws Exception {
        super.setUp(FetchGroupTestObject.class, FetchGroupTestObjectChild.class, AttachA.class, AttachB.class, AttachC.class, AttachD.class, AttachE.class, AttachF.class);
        FetchGroupTestObject o1 = new FetchGroupTestObject();
        o1.setA(5);
        o1.setB("foo");
        o1.setD(new Date());
        o1.setE("e-foo");
        o1.setF("f-foo");
        FetchGroupTestObject o2 = new FetchGroupTestObject();
        o2.setA(3);
        o2.setB("bar");
        o2.setD(new Date());
        o2.setE("e-bar");
        o2.setF("f-bar");
        o2.setG(o1);
        o2.setH(o1);
        FetchGroupTestObjectChild c1 = new FetchGroupTestObjectChild();
        c1.setA(4);
        c1.setB("child");
        c1.setD(new Date());
        c1.setE("e-baz");
        c1.setF("f-baz");
        c1.setG(o1);
        c1.setH(o1);
        c1.setChildA(1);
        c1.setChildB(2);
        c1.setChildC(3);
        c1.setChildD(4);
        OpenJPAEntityManager pm = this.getPM();
        this.startTx((EntityManager)pm);
        pm.persist((Object)o1);
        pm.persist((Object)o2);
        pm.persist((Object)c1);
        this.endTx((EntityManager)pm);
        this.oid1 = o1.getId();
        this.oid2 = o2.getId();
        this.oidc1 = c1.getId();
        this.endEm((EntityManager)pm);
    }

    public void testFetchGroupsFromConfiguration() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("openjpa.FetchGroups", "default,fg1,fg2");
        OpenJPAEntityManagerFactory factory = this.getEmf(props);
        OpenJPAEntityManager pm = factory.createEntityManager();
        this.checkGroups(pm, new String[]{"fg1", "fg2"});
        factory.close();
    }

    public void testFetchGroupsNoConfiguration() {
        OpenJPAEntityManager pm = this.getPM();
        FetchGroupTestObject o1 = this.getO1(pm);
        FetchGroupTestObject o2 = this.getO2(pm);
        this.checkObject(pm, o1, true, false, false, false, false, false);
        o1.getB();
        this.checkObject(pm, o1, true, true, true, true, false, false);
        TestFetchGroups.assertEquals((Object)o1, (Object)o2.getH());
        this.checkObject(pm, o2, true, false, false, false, false, false);
        TestFetchGroups.assertEquals((Object)o1, (Object)o2.getG());
        this.checkObject(pm, o2, true, false, false, false, true, true);
    }

    public void testRetrieveAll() {
        OpenJPAEntityManager pm = this.getPM();
        FetchGroupTestObject o1 = this.getO1(pm);
        FetchGroupTestObject o2 = this.getO2(pm);
        this.checkObject(pm, o1, true, false, false, false, false, false);
        this.checkObject(pm, o2, true, false, false, false, false, false);
        pm.retrieve((Object)o1);
        this.checkObject(pm, o1, true, false, false, false, false, false);
        pm.getFetchPlan().addFetchGroup("g1");
        pm.getFetchPlan().addFetchGroup("g3");
        pm.retrieve((Object)o1);
        this.checkObject(pm, o1, true, true, true, true, false, false);
    }

    public void testFetchGroupConfiguration() {
        OpenJPAEntityManager pm = this.getPM();
        FetchPlan fetch = pm.getFetchPlan();
        this.checkGroups(pm, new String[0]);
        fetch.addFetchGroup("foo");
        this.checkGroups(pm, new String[]{"foo"});
        fetch.addFetchGroup("bar");
        fetch.addFetchGroup("baz");
        this.checkGroups(pm, new String[]{"foo", "bar", "baz"});
        fetch.addFetchGroup("a");
        fetch.addFetchGroup("b");
        fetch.addFetchGroup("c");
        fetch.addFetchGroup("d");
        this.checkGroups(pm, new String[]{"foo", "bar", "baz", "a", "b", "c", "d"});
        fetch.removeFetchGroup("bar");
        this.checkGroups(pm, new String[]{"foo", "baz", "a", "b", "c", "d"});
        fetch.removeFetchGroup("baz");
        fetch.removeFetchGroup("c");
        this.checkGroups(pm, new String[]{"foo", "a", "b", "d"});
        fetch.clearFetchGroups().addFetchGroup("default");
        this.checkGroups(pm, new String[0]);
    }

    private void checkGroups(OpenJPAEntityManager pm, String[] groups) {
        HashSet<String> groupSet = new HashSet<String>(Arrays.asList(groups));
        groupSet.add("default");
        TestFetchGroups.assertEquals((String)"groupSet dont match", groupSet, new HashSet(pm.getFetchPlan().getFetchGroups()));
    }

    public void testFetchGroupsChildWithConfiguration() {
        OpenJPAEntityManager pm = this.getPM();
        pm.getFetchPlan().addFetchGroup("g1");
        pm.getFetchPlan().addFetchGroup("g3");
        FetchGroupTestObject o1 = this.getO1(pm);
        FetchGroupTestObjectChild c1 = this.getC1(pm);
        this.checkChildObject(pm, c1, true, true, true, true, false, false, true, true, false, true);
        c1.getB();
        this.checkChildObject(pm, c1, true, true, true, true, false, false, true, true, false, true);
        c1.getH();
    }

    public void testFetchGroupsWithConfiguration() {
        OpenJPAEntityManager pm = this.getPM();
        pm.getFetchPlan().addFetchGroup("g1");
        pm.getFetchPlan().addFetchGroup("g3");
        FetchGroupTestObject o1 = this.getO1(pm);
        FetchGroupTestObject o2 = this.getO2(pm);
        this.checkObject(pm, o1, true, true, true, true, false, false);
        o1.getB();
        this.checkObject(pm, o1, true, true, true, true, false, false);
        TestFetchGroups.assertEquals((Object)o1, (Object)o2.getH());
        this.checkObject(pm, o2, true, true, true, true, false, false);
        TestFetchGroups.assertEquals((Object)o1, (Object)o2.getG());
        this.checkObject(pm, o2, true, true, true, true, true, true);
    }

    public void testRelationsLoaded() {
        OpenJPAEntityManager pm = this.getPM();
        pm.getFetchPlan().addFetchGroup("g2");
        OpenJPAStateManager sm = this.getStateManager(this.getO2(pm), (EntityManager)pm);
        TestFetchGroups.assertNotNull((String)"SM is NULL", (Object)sm);
        int field = sm.getMetaData().getField("g").getIndex();
        try {
            TestFetchGroups.assertTrue((boolean)sm.getLoaded().get(field));
            TestFetchGroups.assertEquals((int)this.oid1, (int)((FetchGroupTestObject)sm.fetchObjectField(field)).getId());
        }
        catch (AssertionFailedError afe) {
            this.bug(623, afe, "One to one mappings do not work with custom fetch groups");
        }
    }

    protected void checkObject(OpenJPAEntityManager pm, FetchGroupTestObject o, boolean a, boolean b, boolean c, boolean d, boolean e, boolean f) {
        OpenJPAStateManager sm = this.getStateManager(o, (EntityManager)pm);
        BitSet loaded = sm.getLoaded();
        FieldMetaData[] fmds = sm.getMetaData().getFields();
        for (int i = 0; i < fmds.length; ++i) {
            if (fmds[i].getName().equals("a")) {
                TestFetchGroups.assertEquals((boolean)a, (boolean)loaded.get(i));
                continue;
            }
            if (fmds[i].getName().equals("b")) {
                TestFetchGroups.assertEquals((boolean)b, (boolean)loaded.get(i));
                continue;
            }
            if (fmds[i].getName().equals("c")) {
                TestFetchGroups.assertEquals((boolean)c, (boolean)loaded.get(i));
                continue;
            }
            if (fmds[i].getName().equals("d")) {
                TestFetchGroups.assertEquals((boolean)d, (boolean)loaded.get(i));
                continue;
            }
            if (fmds[i].getName().equals("e")) {
                TestFetchGroups.assertEquals((boolean)e, (boolean)loaded.get(i));
                continue;
            }
            if (!fmds[i].getName().equals("f")) continue;
            TestFetchGroups.assertEquals((boolean)f, (boolean)loaded.get(i));
        }
    }

    protected void checkChildObject(OpenJPAEntityManager pm, FetchGroupTestObjectChild o, boolean a, boolean b, boolean c, boolean d, boolean e, boolean f, boolean childA, boolean childB, boolean childC, boolean childD) {
        this.checkObject(pm, o, a, b, c, d, e, f);
        OpenJPAStateManager sm = this.getStateManager(o, (EntityManager)pm);
        BitSet loaded = sm.getLoaded();
        FieldMetaData[] fmds = sm.getMetaData().getFields();
        for (int i = 0; i < fmds.length; ++i) {
            if (fmds[i].getName().equals("childA")) {
                TestFetchGroups.assertEquals((boolean)childA, (boolean)loaded.get(i));
                continue;
            }
            if (fmds[i].getName().equals("childB")) {
                TestFetchGroups.assertEquals((boolean)childB, (boolean)loaded.get(i));
                continue;
            }
            if (fmds[i].getName().equals("childC")) {
                TestFetchGroups.assertEquals((boolean)childC, (boolean)loaded.get(i));
                continue;
            }
            if (!fmds[i].getName().equals("childD")) continue;
            TestFetchGroups.assertEquals((boolean)childD, (boolean)loaded.get(i));
        }
    }

    protected FetchGroupTestObject getO1(OpenJPAEntityManager pm) {
        return (FetchGroupTestObject)pm.find(FetchGroupTestObject.class, (Object)this.oid1);
    }

    protected FetchGroupTestObject getO2(OpenJPAEntityManager pm) {
        return (FetchGroupTestObject)pm.find(FetchGroupTestObject.class, (Object)this.oid2);
    }

    protected FetchGroupTestObjectChild getC1(OpenJPAEntityManager pm) {
        return (FetchGroupTestObjectChild)pm.find(FetchGroupTestObjectChild.class, (Object)this.oidc1);
    }

    public void testFetchGroupInstantiated() {
        OpenJPAEntityManager pm = this.getPM();
        this.startTx((EntityManager)pm);
        AttachE e = new AttachE();
        AttachB b = new AttachB();
        e.setB(b);
        pm.persist((Object)e);
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.getPM();
        this.startTx((EntityManager)pm);
        this.assertSize(0, pm.getManagedObjects());
        pm.createExtent(AttachE.class, true).iterator().next();
        this.assertSize(1, pm.getManagedObjects());
        this.rollbackTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.getPM();
        this.startTx((EntityManager)pm);
        pm.getFetchPlan().addFetchGroup("all");
        this.assertSize(0, pm.getManagedObjects());
        pm.createExtent(AttachE.class, true).iterator().next();
        this.assertSize(2, pm.getManagedObjects());
        this.rollbackTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }
}

