/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.persistence.kernel.common.apps.RuntimeTest1;

public class TestEJBRetainValues
extends AbstractTestCase {
    public TestEJBRetainValues(String testName) {
        super(testName, "kernelcactusapp");
    }

    public void setUp() {
        this.deleteAll(RuntimeTest1.class);
    }

    public void testRetainValues() {
        RuntimeTest1 test = new RuntimeTest1();
        test.setStringField("x");
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pm.persist((Object)test);
        this.endTx((EntityManager)pm);
        OpenJPAEntityManager pm2 = this.currentEntityManager();
        List l = TestEJBRetainValues.buildSelectQuery((EntityManager)pm2, "x");
        TestEJBRetainValues.assertNotNull((String)"l is null in testRetainValues", (Object)l);
        RuntimeTest1 sameThing = (RuntimeTest1)l.iterator().next();
        TestEJBRetainValues.assertEquals((String)"x", (String)sameThing.getStringField());
        TestEJBRetainValues.assertEquals((String)"x", (String)test.getStringField());
        this.startTx((EntityManager)pm2);
        sameThing.setStringField("y");
        this.endTx((EntityManager)pm2);
        TestEJBRetainValues.assertEquals((String)"y", (String)sameThing.getStringField());
        TestEJBRetainValues.assertEquals((String)"x", (String)test.getStringField());
        List l2 = TestEJBRetainValues.buildSelectQuery((EntityManager)pm, "x");
        TestEJBRetainValues.assertEquals((int)0, (int)l2.size());
        List l3 = TestEJBRetainValues.buildSelectQuery((EntityManager)pm, "y");
        TestEJBRetainValues.assertEquals((int)1, (int)l3.size());
        TestEJBRetainValues.assertEquals((Object)test, l3.iterator().next());
        TestEJBRetainValues.assertEquals((String)"x", (String)test.getStringField());
        this.endEm((EntityManager)pm2);
        this.endEm((EntityManager)pm);
    }

    public static List buildSelectQuery(EntityManager em, String param) {
        return em.createQuery("SELECT c FROM RuntimeTest1 c where c.stringField = :username").setParameter("username", (Object)param).getResultList();
    }
}

