/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.persistence.EntityManager;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.conf.OpenJPAConfigurationImpl;
import org.apache.openjpa.enhance.PCEnhancer;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.kernel.DetachedStateManager;
import org.apache.openjpa.lib.util.Options;
import org.apache.openjpa.persistence.DetachStateType;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.kernel.BaseKernelTest;
import org.apache.openjpa.persistence.kernel.common.apps.AttachA;
import org.apache.openjpa.persistence.kernel.common.apps.AttachB;
import org.apache.openjpa.persistence.kernel.common.apps.AttachD;
import org.apache.openjpa.persistence.kernel.common.apps.AttachE;
import org.apache.openjpa.persistence.kernel.common.apps.DetachSMPC;

public class TestDetachedStateManager
extends BaseKernelTest {
    private static boolean enhanced = false;
    private int oid;
    private int doid;

    public TestDetachedStateManager(String name) {
        super(name);
    }

    private void deleteAll() {
        this.deleteAll(AttachA.class);
        this.deleteAll(AttachD.class);
    }

    @Override
    public OpenJPAEntityManager getPM() {
        OpenJPAEntityManager pm = super.getPM();
        return pm;
    }

    public void setUp() throws Exception {
        super.setUp();
        this.deleteAll();
        OpenJPAEntityManager pm = this.getPM();
        this.startTx((EntityManager)pm);
        AttachB b = new AttachB();
        pm.persist((Object)b);
        b.setAint(5);
        b.setBstr("5");
        b.getStringIntMap().put("5", 5);
        AttachE e = new AttachE();
        e.setEstr("E");
        e.setEint(5);
        AttachD d = new AttachD();
        d.setDint(5);
        d.setEmbeddedE(e);
        b.getDs().add(d);
        pm.persist((Object)d);
        this.oid = b.getId();
        this.doid = d.getId();
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }

    public void testDetach() {
        OpenJPAEntityManager pm = this.getPM();
        AttachB b = (AttachB)pm.find(AttachB.class, (Object)this.oid);
        TestDetachedStateManager.assertNotNull((String)"b is null in testDetach", (Object)b);
        b = (AttachB)pm.detachCopy((Object)b);
        this.endEm((EntityManager)pm);
        TestDetachedStateManager.assertTrue((boolean)pm.isDetached((Object)b));
        TestDetachedStateManager.assertEquals((int)5, (int)b.getAint());
        TestDetachedStateManager.assertEquals((String)"5", (String)b.getBstr());
        TestDetachedStateManager.assertNull((Object)b.getStringIntMap());
        b.setAint(12);
        b.setBstr("12");
        TreeMap<String, Integer> map = new TreeMap<String, Integer>();
        map.put("12", 12);
        b.setStringIntMap(map);
        pm = this.getPM();
        this.startTx((EntityManager)pm);
        AttachB attached = (AttachB)pm.merge((Object)b);
        TestDetachedStateManager.assertEquals((int)12, (int)attached.getAint());
        TestDetachedStateManager.assertEquals((String)"12", (String)attached.getBstr());
        TestDetachedStateManager.assertNull(attached.getStringIntMap().get("12"));
        TestDetachedStateManager.assertEquals((Object)5, attached.getStringIntMap().get("5"));
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.getPM();
        b = (AttachB)pm.find(AttachB.class, (Object)this.oid);
        TestDetachedStateManager.assertEquals((int)12, (int)b.getAint());
        TestDetachedStateManager.assertEquals((String)"12", (String)b.getBstr());
        TestDetachedStateManager.assertNull(b.getStringIntMap().get("12"));
        TestDetachedStateManager.assertEquals((Object)5, b.getStringIntMap().get("5"));
        this.endEm((EntityManager)pm);
    }

    public void testDetachWithGroups() {
        OpenJPAEntityManager pm = this.getPM();
        pm.setDetachState(DetachStateType.FETCH_GROUPS);
        pm.getFetchPlan().addFetchGroup("all");
        AttachB b = (AttachB)pm.find(AttachB.class, (Object)this.oid);
        TestDetachedStateManager.assertNotNull((String)"b is null in testDetachWithGroups", (Object)b);
        b = (AttachB)pm.detachCopy((Object)b);
        this.endEm((EntityManager)pm);
        TestDetachedStateManager.assertTrue((boolean)pm.isDetached((Object)b));
        TestDetachedStateManager.assertEquals((String)"b.getAint() not 5", (int)5, (int)b.getAint());
        TestDetachedStateManager.assertEquals((String)"b.getAint() not 5str", (String)"5", (String)b.getBstr());
        TestDetachedStateManager.assertEquals((String)"b.getStringIntMap().size() not equal to 1", (int)1, (int)b.getStringIntMap().size());
        b.setAint(12);
        b.setBstr("12");
        b.getStringIntMap().put("12", 12);
        pm = this.getPM();
        this.startTx((EntityManager)pm);
        AttachB attached = (AttachB)pm.merge((Object)b);
        TestDetachedStateManager.assertEquals((String)"not 12", (int)12, (int)attached.getAint());
        TestDetachedStateManager.assertEquals((String)"not 12str", (String)"12", (String)attached.getBstr());
        TestDetachedStateManager.assertEquals((String)"not newInteger(12)", (Object)12, attached.getStringIntMap().get("12"));
        TestDetachedStateManager.assertEquals((String)"not newInteger(5)", (Object)5, attached.getStringIntMap().get("5"));
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.getPM();
        b = (AttachB)pm.find(AttachB.class, (Object)this.oid);
        TestDetachedStateManager.assertEquals((String)"not equal 12", (int)12, (int)b.getAint());
        TestDetachedStateManager.assertEquals((String)"not equal 12str", (String)"12", (String)b.getBstr());
        TestDetachedStateManager.assertEquals((String)"not equal newinteger(12)", (Object)12, b.getStringIntMap().get("12"));
        TestDetachedStateManager.assertEquals((String)"not equal newInteger(5)", (Object)5, b.getStringIntMap().get("5"));
        this.endEm((EntityManager)pm);
    }

    public void testDetachNoOverwrite() {
        OpenJPAEntityManager pm = this.getPM();
        AttachB b = (AttachB)pm.find(AttachB.class, (Object)this.oid);
        b = (AttachB)pm.detachCopy((Object)b);
        this.endEm((EntityManager)pm);
        b.setBstr("12");
        pm = this.getPM();
        this.startTx((EntityManager)pm);
        AttachB orig = (AttachB)pm.find(AttachB.class, (Object)this.oid);
        orig.setAint(50);
        AttachB attached = (AttachB)pm.merge((Object)b);
        TestDetachedStateManager.assertEquals((Object)attached, (Object)orig);
        TestDetachedStateManager.assertEquals((int)50, (int)attached.getAint());
        TestDetachedStateManager.assertEquals((String)"12", (String)attached.getBstr());
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.getPM();
        b = (AttachB)pm.find(AttachB.class, (Object)this.oid);
        TestDetachedStateManager.assertEquals((int)50, (int)b.getAint());
        TestDetachedStateManager.assertEquals((String)"12", (String)b.getBstr());
        this.endEm((EntityManager)pm);
    }

    public void testOptimisticLock() {
        OpenJPAEntityManager pm = this.getPM();
        AttachB b = (AttachB)pm.find(AttachB.class, (Object)this.oid);
        TestDetachedStateManager.assertNotNull((String)"b is null in testOptimisticLock", (Object)b);
        b = (AttachB)pm.detachCopy((Object)b);
        this.endEm((EntityManager)pm);
        b.setAint(12);
        b.setBstr("12");
        TreeMap<String, Integer> map = new TreeMap<String, Integer>();
        map.put("12", 12);
        b.setStringIntMap(map);
        pm = this.getPM();
        this.startTx((EntityManager)pm);
        AttachB b2 = (AttachB)pm.find(AttachB.class, (Object)this.oid);
        b2.setAint(15);
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.getPM();
        this.startTx((EntityManager)pm);
        try {
            pm.merge((Object)b);
            this.endTx((EntityManager)pm);
            TestDetachedStateManager.fail((String)"OL expected.");
        }
        catch (Exception jove) {
            this.rollbackTx((EntityManager)pm);
        }
        this.endEm((EntityManager)pm);
    }

    public void testEmbedded() {
        OpenJPAEntityManager pm = this.getPM();
        AttachD d = (AttachD)pm.find(AttachD.class, (Object)this.doid);
        TestDetachedStateManager.assertNotNull((String)"d is null in testEmbedded", (Object)d);
        d.getEmbeddedE().getEstr();
        d = (AttachD)pm.detachCopy((Object)d);
        this.endEm((EntityManager)pm);
        d.getEmbeddedE().setEstr("E12");
        pm = this.getPM();
        this.startTx((EntityManager)pm);
        AttachD d2 = (AttachD)pm.merge((Object)d);
        TestDetachedStateManager.assertNotEquals(d.getEmbeddedE(), d2.getEmbeddedE());
        TestDetachedStateManager.assertEquals((String)"E12", (String)d2.getEmbeddedE().getEstr());
        TestDetachedStateManager.assertEquals((int)5, (int)d2.getEmbeddedE().getEint());
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.getPM();
        d2 = (AttachD)pm.find(AttachD.class, (Object)this.doid);
        TestDetachedStateManager.assertNotNull((String)"d2 is null in testEmbedded", (Object)d2);
        TestDetachedStateManager.assertEquals((String)"E12", (String)d2.getEmbeddedE().getEstr());
        TestDetachedStateManager.assertEquals((int)5, (int)d2.getEmbeddedE().getEint());
        this.endEm((EntityManager)pm);
    }

    public void testNullEmbedded() {
        OpenJPAEntityManager pm = this.getPM();
        AttachD d = (AttachD)pm.find(AttachD.class, (Object)this.doid);
        TestDetachedStateManager.assertNotNull((String)"d is null in testNullEmbedded", (Object)d);
        d.getEmbeddedE().getEstr();
        d = (AttachD)pm.detachCopy((Object)d);
        this.endEm((EntityManager)pm);
        d.setEmbeddedE(null);
        pm = this.getPM();
        this.startTx((EntityManager)pm);
        AttachD d2 = (AttachD)pm.merge((Object)d);
        TestDetachedStateManager.assertNull((Object)d2.getEmbeddedE());
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.getPM();
        d2 = (AttachD)pm.find(AttachD.class, (Object)this.doid);
        TestDetachedStateManager.assertNotNull((String)"d2 is null in testNullEmbedded", (Object)d2);
        if (d2.getEmbeddedE() != null) {
            TestDetachedStateManager.assertNull((Object)d2.getEmbeddedE().getEstr());
            TestDetachedStateManager.assertEquals((int)0, (int)d2.getEmbeddedE().getEint());
        }
        this.endEm((EntityManager)pm);
    }

    public void testNullEmbeddedRelated() {
        OpenJPAEntityManager pm = this.getPM();
        AttachD d = (AttachD)pm.find(AttachD.class, (Object)this.doid);
        TestDetachedStateManager.assertNotNull((String)"d is null in testNullEmbeddedRelated", (Object)d);
        d.getEmbeddedE().getEstr();
        d = (AttachD)pm.detachCopy((Object)d);
        this.endEm((EntityManager)pm);
        d.getEmbeddedE().setEstr(null);
        pm = this.getPM();
        this.startTx((EntityManager)pm);
        AttachD d2 = (AttachD)pm.merge((Object)d);
        TestDetachedStateManager.assertNull((String)"d2.getEmbeddedE().getEstr() is not null", (Object)d2.getEmbeddedE().getEstr());
        TestDetachedStateManager.assertEquals((String)"d2.getEmbeddedE().getEint() is not equal to 5", (int)5, (int)d2.getEmbeddedE().getEint());
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.getPM();
        d2 = (AttachD)pm.find(AttachD.class, (Object)this.doid);
        TestDetachedStateManager.assertNull((String)"d2.getEmbeddedE().getEstr() is not null", (Object)d2.getEmbeddedE().getEstr());
        TestDetachedStateManager.assertEquals((String)"d2.getEmbeddedE().getEint() is not 5", (int)5, (int)d2.getEmbeddedE().getEint());
        this.endEm((EntityManager)pm);
    }

    public void testNullCollection() {
        OpenJPAEntityManager pm = this.getPM();
        AttachB b = (AttachB)pm.find(AttachB.class, (Object)this.oid);
        b.getDs();
        b = (AttachB)pm.detachCopy((Object)b);
        this.endEm((EntityManager)pm);
        TestDetachedStateManager.assertEquals((int)1, (int)b.getDs().size());
        b.setDs(null);
        pm = this.getPM();
        this.startTx((EntityManager)pm);
        b = (AttachB)pm.merge((Object)b);
        TestDetachedStateManager.assertNull((Object)b.getDs());
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.getPM();
        b = (AttachB)pm.find(AttachB.class, (Object)this.oid);
        TestDetachedStateManager.assertTrue((b.getDs() == null || b.getDs().size() == 0 ? 1 : 0) != 0);
        this.endEm((EntityManager)pm);
    }

    public void testCollectionAdd() {
        this.doCollectionTest(false);
    }

    public void testCollectionChanges() {
        this.doCollectionTest(true);
    }

    private void doCollectionTest(boolean remove) {
        OpenJPAEntityManager pm = this.getPM();
        AttachB b = (AttachB)pm.find(AttachB.class, (Object)this.oid);
        TestDetachedStateManager.assertNotNull((String)"b is null in doCollectionTest", (Object)b);
        b.getDs();
        b = (AttachB)pm.detachCopy((Object)b);
        this.endEm((EntityManager)pm);
        TestDetachedStateManager.assertEquals((String)"b is null in doCollectionTest", (int)1, (int)b.getDs().size());
        if (remove) {
            Iterator it = b.getDs().iterator();
            while (it.hasNext()) {
                it.next();
                it.remove();
            }
        }
        AttachD d = new AttachD();
        d.setDint(12);
        b.getDs().add(d);
        pm = this.getPM();
        this.startTx((EntityManager)pm);
        b = (AttachB)pm.merge((Object)b);
        this.assertSize(remove ? 1 : 2, b.getDs());
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.getPM();
        b = (AttachB)pm.find(AttachB.class, (Object)this.oid);
        this.assertSize(remove ? 1 : 2, b.getDs());
        boolean found1 = false;
        boolean found2 = false;
        block5: for (Object o : b.getDs()) {
            d = (AttachD)o;
            switch (d.getDint()) {
                case 5: {
                    if (found1) {
                        TestDetachedStateManager.fail((String)"Refound.");
                    }
                    found1 = true;
                    continue block5;
                }
                case 12: {
                    if (found2) {
                        TestDetachedStateManager.fail((String)"Refound.");
                    }
                    found2 = true;
                    continue block5;
                }
            }
            TestDetachedStateManager.fail((String)("Unknown d:" + d.getDint()));
        }
        if (remove) {
            TestDetachedStateManager.assertFalse((boolean)found1);
        }
        this.endEm((EntityManager)pm);
    }

    private void doSerializationTest(boolean auto) throws Exception {
        this.enhance();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("openjpa.DetachState", "DetachedStateField=true");
        OpenJPAEntityManagerFactory factory = this.getEmf(props);
        OpenJPAEntityManager pm = factory.createEntityManager();
        this.startTx((EntityManager)pm);
        DetachSMPC pc = new DetachSMPC();
        pc.setIntField(1);
        DetachSMPC rel = new DetachSMPC();
        rel.setIntField(2);
        pc.getRelSet().add(rel);
        pc.getStringIntMap().put("a", 99);
        pm.persist((Object)pc);
        this.endTx((EntityManager)pm);
        Object pcoid = pm.getObjectId((Object)pc);
        this.endEm((EntityManager)pm);
        pm = factory.createEntityManager();
        pc = (DetachSMPC)pm.find(DetachSMPC.class, pcoid);
        pc.getRelSet();
        pc.getStringIntMap();
        if (!auto) {
            pc = (DetachSMPC)pm.detachCopy((Object)pc);
            this.assertDetachedSM(pc);
        }
        pc = (DetachSMPC)TestDetachedStateManager.roundtrip(pc, false);
        this.assertDetachedSM(pc);
        this.endEm((EntityManager)pm);
        this.assertDetachedSM(pc);
        this.assertSize(1, pc.getRelSet());
        TestDetachedStateManager.assertEquals((int)1, (int)pc.getStringIntMap().size());
        pc.setIntField(3);
        ((DetachSMPC)pc.getRelSet().iterator().next()).setIntField(4);
        pc.getStringIntMap().put("b", 100);
        pc = (DetachSMPC)TestDetachedStateManager.roundtrip(pc, false);
        this.assertDetachedSM(pc);
        TestDetachedStateManager.assertEquals((int)3, (int)pc.getIntField());
        this.assertSize(1, pc.getRelSet());
        TestDetachedStateManager.assertEquals((int)4, (int)((DetachSMPC)pc.getRelSet().iterator().next()).getIntField());
        TestDetachedStateManager.assertEquals((Object)100, pc.getStringIntMap().get("b"));
        pm = factory.createEntityManager();
        this.startTx((EntityManager)pm);
        pc = (DetachSMPC)pm.merge((Object)pc);
        TestDetachedStateManager.assertEquals((int)3, (int)pc.getIntField());
        this.assertSize(1, pc.getRelSet());
        TestDetachedStateManager.assertEquals((int)4, (int)((DetachSMPC)pc.getRelSet().iterator().next()).getIntField());
        TestDetachedStateManager.assertEquals((int)2, (int)pc.getStringIntMap().size());
        TestDetachedStateManager.assertEquals((Object)100, pc.getStringIntMap().get("b"));
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = factory.createEntityManager();
        pc = (DetachSMPC)pm.find(DetachSMPC.class, pcoid);
        TestDetachedStateManager.assertEquals((int)3, (int)pc.getIntField());
        this.assertSize(1, pc.getRelSet());
        TestDetachedStateManager.assertEquals((int)4, (int)((DetachSMPC)pc.getRelSet().iterator().next()).getIntField());
        TestDetachedStateManager.assertEquals((int)2, (int)pc.getStringIntMap().size());
        TestDetachedStateManager.assertEquals((Object)100, pc.getStringIntMap().get("b"));
        this.startTx((EntityManager)pm);
        this.deleteAll(DetachSMPC.class, (EntityManager)pm);
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        factory.close();
    }

    private void enhance() throws Exception {
        Properties props = this.getProperties(new String[]{"openjpa.DetachState", "DetachedStateField=true"});
        OpenJPAConfigurationImpl conf = new OpenJPAConfigurationImpl(true, false);
        conf.fromProperties((Map)props);
        Options opts = new Options();
        opts.put((Object)"jdo", (Object)"true");
        PCEnhancer.run((OpenJPAConfiguration)conf, (String[])new String[]{"org.apache.openjpa.persistence.kernel.noenhance.DetachSMPC"}, (Options)opts);
    }

    private void assertDetachedSM(Object obj) {
        OpenJPAEntityManager pm = this.getPM();
        TestDetachedStateManager.assertTrue((boolean)pm.isDetached(obj));
        PersistenceCapable pc = (PersistenceCapable)obj;
        TestDetachedStateManager.assertEquals(DetachedStateManager.class, pc.pcGetStateManager().getClass());
        this.endEm((EntityManager)pm);
    }
}

