/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.kernel.BaseKernelTest;
import org.apache.openjpa.persistence.kernel.common.apps.DependentFieldsPC;

public class TestDependentFields2
extends BaseKernelTest {
    private static final int COMMIT = 0;
    private static final int ROLLBACK = 1;
    private static final int PRESTORE = 2;
    private Object _root = null;
    private Object _rel = null;
    private Object _depRel = null;
    private Object _deep = null;
    private Object _coll = null;
    private Object _depColl = null;
    private Object _map = null;
    private Object _depMap = null;
    private Object _repeat = null;

    public TestDependentFields2(String casename) {
        super(casename);
    }

    public void setUp() throws Exception {
        this.deleteAll(DependentFieldsPC.class);
        DependentFieldsPC root = new DependentFieldsPC();
        root.setRelation(new DependentFieldsPC());
        root.getList().add(new DependentFieldsPC());
        root.getMap().put("key", new DependentFieldsPC());
        root.setDependentRelation(new DependentFieldsPC());
        root.getDependentRelation().setDependentRelation(new DependentFieldsPC());
        root.getDependentList().add(new DependentFieldsPC());
        root.getDependentMap().put("key", new DependentFieldsPC());
        DependentFieldsPC repeat = new DependentFieldsPC();
        root.getDependentList().add(repeat);
        root.getDependentMap().put("repeat", repeat);
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pm.persist((Object)root);
        this.endTx((EntityManager)pm);
        this._root = pm.getObjectId((Object)root);
        TestDependentFields2.assertNotNull((Object)this._root);
        this._rel = pm.getObjectId((Object)root.getRelation());
        this._depRel = pm.getObjectId((Object)root.getDependentRelation());
        this._deep = pm.getObjectId((Object)root.getDependentRelation().getDependentRelation());
        this._coll = pm.getObjectId(root.getList().iterator().next());
        Iterator itr = root.getDependentList().iterator();
        this._depColl = pm.getObjectId(itr.next());
        this._repeat = pm.getObjectId(itr.next());
        this._map = pm.getObjectId(root.getMap().get("key"));
        this._depMap = pm.getObjectId(root.getDependentMap().get("key"));
        this.endEm((EntityManager)pm);
    }

    public void testDependentFieldsLoaded() {
        this.delete(true, 0);
        this.checkFields();
    }

    public void testDependentFieldsLoadedWithRollback() {
        this.delete(true, 1);
        this.checkFields();
    }

    public void testDependentFieldsLoadedWithPreStore() {
        this.delete(true, 2);
        this.checkFields();
    }

    public void testDependentFieldsUnloaded() {
        this.delete(false, 0);
        this.checkFields();
    }

    public void testDependentFieldsUnloadedWithRollback() {
        this.delete(false, 1);
        this.checkFields();
    }

    public void testDependentFieldsUnloadedWithPreStore() {
        this.delete(false, 2);
        this.checkFields();
    }

    private void delete(boolean load, int action) {
        OpenJPAEntityManager pm = this.getPM(true, true);
        DependentFieldsPC rel = null;
        DependentFieldsPC depRel = null;
        Object coll = null;
        Object depColl = null;
        Object map = null;
        Object depMap = null;
        Object repeat = null;
        DependentFieldsPC deep = null;
        while (true) {
            this.startTx((EntityManager)pm);
            DependentFieldsPC root = (DependentFieldsPC)pm.find(DependentFieldsPC.class, this._root);
            if (load) {
                rel = root.getRelation();
                TestDependentFields2.assertNotNull((Object)rel);
                depRel = root.getDependentRelation();
                TestDependentFields2.assertNotNull((Object)depRel);
                deep = depRel.getDependentRelation();
                TestDependentFields2.assertNotNull((Object)deep);
                coll = root.getList().iterator().next();
                TestDependentFields2.assertNotNull(coll);
                Iterator itr = root.getDependentList().iterator();
                depColl = itr.next();
                repeat = itr.next();
                TestDependentFields2.assertNotNull(depColl);
                TestDependentFields2.assertNotNull(repeat);
                map = root.getMap().get("key");
                TestDependentFields2.assertNotNull(map);
                depMap = root.getDependentMap().get("key");
                TestDependentFields2.assertNotNull(depMap);
                Object o = root.getDependentMap().get("repeat");
                if (o != repeat) {
                    TestDependentFields2.fail((String)"dependent map does not contain 'repeat'");
                }
            }
            pm.remove((Object)root);
            if (action != 1) break;
            this.rollbackTx((EntityManager)pm);
            action = 0;
        }
        if (action == 0) {
            this.endTx((EntityManager)pm);
        } else {
            pm.preFlush();
        }
        if (load) {
            if (action == 2) {
                TestDependentFields2.assertFalse((boolean)pm.isRemoved((Object)rel));
                TestDependentFields2.assertFalse((boolean)pm.isRemoved(coll));
                TestDependentFields2.assertFalse((boolean)pm.isRemoved(map));
                TestDependentFields2.assertTrue((boolean)pm.isRemoved((Object)depRel));
                TestDependentFields2.assertTrue((boolean)pm.isRemoved((Object)deep));
                TestDependentFields2.assertTrue((boolean)pm.isRemoved(depColl));
                TestDependentFields2.assertTrue((boolean)pm.isRemoved(depMap));
                TestDependentFields2.assertTrue((boolean)pm.isRemoved(repeat));
            } else {
                TestDependentFields2.assertNotNull((Object)OpenJPAPersistence.getEntityManager((Object)rel));
                TestDependentFields2.assertNotNull((Object)OpenJPAPersistence.getEntityManager(coll));
                TestDependentFields2.assertNotNull((Object)OpenJPAPersistence.getEntityManager(map));
                TestDependentFields2.assertNull((Object)OpenJPAPersistence.getEntityManager((Object)depRel));
                TestDependentFields2.assertNull((Object)OpenJPAPersistence.getEntityManager((Object)deep));
                TestDependentFields2.assertNull((Object)OpenJPAPersistence.getEntityManager(depColl));
                TestDependentFields2.assertNull((Object)OpenJPAPersistence.getEntityManager(depMap));
                TestDependentFields2.assertNull((Object)OpenJPAPersistence.getEntityManager(repeat));
            }
        }
        if (action == 2) {
            this.endTx((EntityManager)pm);
        }
        this.endEm((EntityManager)pm);
    }

    private void checkFields() {
        OpenJPAEntityManager pm = this.getPM(true, true);
        TestDependentFields2.assertNotNull((Object)pm.find(DependentFieldsPC.class, this._rel));
        TestDependentFields2.assertNotNull((Object)pm.find(DependentFieldsPC.class, this._coll));
        TestDependentFields2.assertNotNull((Object)pm.find(DependentFieldsPC.class, this._map));
        TestDependentFields2.assertNull((Object)pm.find(DependentFieldsPC.class, this._depRel));
        TestDependentFields2.assertNull((Object)pm.find(DependentFieldsPC.class, this._deep));
        TestDependentFields2.assertNull((Object)pm.find(DependentFieldsPC.class, this._depColl));
        TestDependentFields2.assertNull((Object)pm.find(DependentFieldsPC.class, this._depMap));
        this.endEm((EntityManager)pm);
    }

    public void testNullDeletesDependent() {
        this.nullDeletesDependent(0);
    }

    public void testNullDeletesDependentWithRollback() {
        this.nullDeletesDependent(1);
    }

    public void testNullDeletesDependentWithPreStore() {
        this.nullDeletesDependent(2);
    }

    private void nullDeletesDependent(int action) {
        DependentFieldsPC depRel;
        OpenJPAEntityManager pm = this.currentEntityManager();
        while (true) {
            this.startTx((EntityManager)pm);
            DependentFieldsPC pc = (DependentFieldsPC)pm.find(DependentFieldsPC.class, this._root);
            depRel = pc.getDependentRelation();
            TestDependentFields2.assertEquals((Object)this._depRel, (Object)pm.getObjectId((Object)depRel));
            pc.setDependentRelation(null);
            if (action != 1) break;
            this.rollbackTx((EntityManager)pm);
            action = 0;
        }
        if (action == 0) {
            this.endTx((EntityManager)pm);
        } else {
            pm.preFlush();
        }
        if (action == 2) {
            TestDependentFields2.assertTrue((boolean)pm.isRemoved((Object)depRel));
            this.endTx((EntityManager)pm);
        }
        TestDependentFields2.assertTrue((!pm.isPersistent((Object)depRel) ? 1 : 0) != 0);
        TestDependentFields2.assertNull((Object)pm.find(DependentFieldsPC.class, this._depRel));
        this.endEm((EntityManager)pm);
    }

    public void testRemoveDeletesDependent() {
        this.removeDeletesDependent(0);
    }

    public void testRemoveDeletesDependentWithRollback() {
        this.removeDeletesDependent(1);
    }

    public void testRemoveDeletesDependentWithPreStore() {
        this.removeDeletesDependent(2);
    }

    private void removeDeletesDependent(int action) {
        DependentFieldsPC depMap;
        DependentFieldsPC depColl;
        OpenJPAEntityManager pm = this.currentEntityManager();
        while (true) {
            this.startTx((EntityManager)pm);
            DependentFieldsPC pc = (DependentFieldsPC)pm.find(DependentFieldsPC.class, this._root);
            List list = pc.getDependentList();
            TestDependentFields2.assertEquals((String)"list size =! 2", (int)2, (int)list.size());
            depColl = (DependentFieldsPC)list.remove(0);
            TestDependentFields2.assertEquals((String)"_depColl is not pm.getObjectId(depColl)", (Object)this._depColl, (Object)pm.getObjectId((Object)depColl));
            Map map = pc.getDependentMap();
            TestDependentFields2.assertEquals((String)"map size =! 2", (int)2, (int)map.size());
            depMap = (DependentFieldsPC)map.remove("key");
            TestDependentFields2.assertEquals((String)"_depMap is not pm.getObjectId(depMap)", (Object)this._depMap, (Object)pm.getObjectId((Object)depMap));
            if (action != 1) break;
            this.rollbackTx((EntityManager)pm);
            action = 0;
        }
        if (action == 0) {
            this.endTx((EntityManager)pm);
        } else {
            pm.preFlush();
        }
        if (action == 2) {
            TestDependentFields2.assertTrue((boolean)pm.isRemoved((Object)depColl));
            TestDependentFields2.assertTrue((boolean)pm.isRemoved((Object)depMap));
            this.endTx((EntityManager)pm);
        }
        TestDependentFields2.assertNull((Object)pm.find(DependentFieldsPC.class, this._depColl));
        TestDependentFields2.assertNull((Object)pm.find(DependentFieldsPC.class, this._depMap));
        TestDependentFields2.assertNotNull((String)"repeat is null", (Object)pm.find(DependentFieldsPC.class, this._repeat));
        this.endEm((EntityManager)pm);
    }

    public void testMoveDependentInContainer() {
        this.moveDependentInContainer(0);
    }

    public void testMoveDependentInContainerWithRollback() {
        this.moveDependentInContainer(1);
    }

    public void testMoveDependentInContainerWithPreStore() {
        this.moveDependentInContainer(2);
    }

    private void moveDependentInContainer(int action) {
        DependentFieldsPC depMap;
        DependentFieldsPC depColl;
        OpenJPAEntityManager pm = this.currentEntityManager();
        while (true) {
            this.startTx((EntityManager)pm);
            DependentFieldsPC pc = (DependentFieldsPC)pm.find(DependentFieldsPC.class, this._root);
            List list = pc.getDependentList();
            TestDependentFields2.assertEquals((int)2, (int)list.size());
            depColl = (DependentFieldsPC)list.get(0);
            TestDependentFields2.assertEquals((Object)this._depColl, (Object)pm.getObjectId((Object)depColl));
            list.remove(0);
            list.add(depColl);
            Map map = pc.getDependentMap();
            TestDependentFields2.assertEquals((int)2, (int)map.size());
            depMap = (DependentFieldsPC)map.get("key");
            TestDependentFields2.assertEquals((Object)this._depMap, (Object)pm.getObjectId((Object)depMap));
            map.remove("key");
            map.put("newkey", depMap);
            if (action != 1) break;
            this.rollbackTx((EntityManager)pm);
            action = 0;
        }
        if (action == 0) {
            this.endTx((EntityManager)pm);
        } else {
            pm.preFlush();
        }
        if (action == 2) {
            TestDependentFields2.assertFalse((boolean)pm.isRemoved((Object)depColl));
            TestDependentFields2.assertFalse((boolean)pm.isRemoved((Object)depMap));
            this.endTx((EntityManager)pm);
        }
        TestDependentFields2.assertTrue((boolean)pm.isPersistent((Object)depColl));
        TestDependentFields2.assertNotNull((Object)pm.find(DependentFieldsPC.class, this._depColl));
        TestDependentFields2.assertTrue((boolean)pm.isPersistent((Object)depMap));
        TestDependentFields2.assertNotNull((Object)pm.find(DependentFieldsPC.class, this._depMap));
        TestDependentFields2.assertNotNull((Object)pm.find(DependentFieldsPC.class, this._repeat));
        this.endEm((EntityManager)pm);
    }

    public void testRefedDependentNotDeleted() {
        this.refedDependentNotDeleted(0);
    }

    public void testRefedDependentNotDeletedWithRollback() {
        this.refedDependentNotDeleted(1);
    }

    public void testRefedDependentNotDeletedWithPreStore() {
        this.refedDependentNotDeleted(2);
    }

    private void refedDependentNotDeleted(int action) {
        DependentFieldsPC depRel;
        OpenJPAEntityManager pm = this.currentEntityManager();
        DependentFieldsPC newPC = null;
        while (true) {
            this.startTx((EntityManager)pm);
            DependentFieldsPC pc = (DependentFieldsPC)pm.find(DependentFieldsPC.class, this._root);
            if (newPC == null) {
                newPC = new DependentFieldsPC();
            }
            depRel = pc.getDependentRelation();
            newPC.setDependentRelation(depRel);
            pc.setDependentRelation(null);
            pm.persist((Object)newPC);
            if (action != 1) break;
            this.rollbackTx((EntityManager)pm);
            action = 0;
        }
        if (action == 0) {
            this.endTx((EntityManager)pm);
        } else {
            pm.preFlush();
        }
        if (action == 2) {
            TestDependentFields2.assertFalse((boolean)pm.isRemoved((Object)depRel));
            this.endTx((EntityManager)pm);
        }
        TestDependentFields2.assertTrue((boolean)pm.isPersistent((Object)depRel));
        TestDependentFields2.assertNotNull((Object)pm.find(DependentFieldsPC.class, this._depRel));
        this.endEm((EntityManager)pm);
    }

    public void testNullSharedDependent() {
        this.nullSharedDependent(0);
    }

    public void testNullSharedDependentWithRollback() {
        this.nullSharedDependent(1);
    }

    public void testNullSharedDependentWithPreStore() {
        this.nullSharedDependent(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nullSharedDependent(int action) {
        OpenJPAEntityManager pm = this.currentEntityManager();
        while (true) {
            this.startTx((EntityManager)pm);
            DependentFieldsPC pc = (DependentFieldsPC)pm.find(DependentFieldsPC.class, this._root);
            List list = pc.getDependentList();
            TestDependentFields2.assertEquals((int)2, (int)list.size());
            DependentFieldsPC repeat = (DependentFieldsPC)list.get(1);
            TestDependentFields2.assertEquals((Object)this._repeat, (Object)pm.getObjectId((Object)repeat));
            list.remove(1);
            Map map = pc.getDependentMap();
            TestDependentFields2.assertEquals((int)2, (int)map.size());
            TestDependentFields2.assertEquals((Object)repeat, (Object)((DependentFieldsPC)map.remove("repeat")));
            if (action == 2) {
                pm.preFlush();
            } else {
                pm.flush();
            }
            TestDependentFields2.assertTrue((boolean)pm.isRemoved((Object)repeat));
            pc.getList().add(repeat);
            if (action != 1) break;
            this.rollbackTx((EntityManager)pm);
            action = 0;
        }
        try {
            pm.getTransaction().commit();
            TestDependentFields2.fail((String)"Committed with ref to deleted dependent object");
        }
        catch (Exception je) {
            this.rollbackTx((EntityManager)pm);
        }
        this.endEm((EntityManager)pm);
    }

    public void testClearMappedDependentOfDetached() {
        this.clearDependentOfDetachedTest(true);
    }

    public void testClearInverseKeyDependentOfDetached() {
        this.clearDependentOfDetachedTest(false);
    }

    private void clearDependentOfDetachedTest(boolean mapped) {
        this.deleteAll(DependentFieldsPC.class);
        DependentFieldsPC owner = new DependentFieldsPC();
        for (int i = 0; i < 2; ++i) {
            DependentFieldsPC child = new DependentFieldsPC();
            if (mapped) {
                owner.getDependentMappedList().add(child);
                child.setOwner(owner);
                continue;
            }
            owner.getDependentInverseKeyList().add(child);
        }
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pm.persist((Object)owner);
        this.endTx((EntityManager)pm);
        Object oid = pm.getObjectId((Object)owner);
        TestDependentFields2.assertEquals((int)3, (int)pm.createExtent(DependentFieldsPC.class, true).list().size());
        this.endEm((EntityManager)pm);
        pm = this.currentEntityManager();
        owner = (DependentFieldsPC)pm.find(DependentFieldsPC.class, oid);
        if (mapped) {
            TestDependentFields2.assertEquals((int)2, (int)owner.getDependentMappedList().size());
        } else {
            TestDependentFields2.assertEquals((int)2, (int)owner.getDependentInverseKeyList().size());
        }
        DependentFieldsPC detached = (DependentFieldsPC)pm.detachCopy((Object)owner);
        this.endEm((EntityManager)pm);
        if (mapped) {
            TestDependentFields2.assertEquals((int)2, (int)detached.getDependentMappedList().size());
            detached.getDependentMappedList().clear();
        } else {
            TestDependentFields2.assertEquals((int)2, (int)detached.getDependentInverseKeyList().size());
            detached.getDependentInverseKeyList().clear();
        }
        pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        owner = (DependentFieldsPC)pm.merge((Object)detached);
        if (mapped) {
            TestDependentFields2.assertEquals((int)0, (int)owner.getDependentMappedList().size());
        } else {
            TestDependentFields2.assertEquals((int)0, (int)owner.getDependentInverseKeyList().size());
        }
        this.endTx((EntityManager)pm);
        TestDependentFields2.assertEquals((int)1, (int)pm.createExtent(DependentFieldsPC.class, true).list().size());
        this.endEm((EntityManager)pm);
        pm = this.currentEntityManager();
        owner = (DependentFieldsPC)pm.find(DependentFieldsPC.class, oid);
        if (mapped) {
            TestDependentFields2.assertEquals((int)0, (int)owner.getDependentMappedList().size());
        } else {
            TestDependentFields2.assertEquals((int)0, (int)owner.getDependentInverseKeyList().size());
        }
        this.endEm((EntityManager)pm);
    }
}

