/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.persistence.EntityManager;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.kernel.BaseKernelTest;
import org.apache.openjpa.persistence.kernel.common.apps.AllFieldTypesTest;

public class TestDateQueries
extends BaseKernelTest {
    private OpenJPAEntityManager _pm = null;
    private Date _date = null;
    private Date _before = null;
    private Date _after = null;
    private final Timestamp referenceTst = new Timestamp(10000000000L);

    public TestDateQueries() {
    }

    public TestDateQueries(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp(AllFieldTypesTest.class);
        SimpleDateFormat sdf = new SimpleDateFormat("MMMMM dd, yyyy", Locale.US);
        this._date = sdf.parse("April 26, 1978");
        this._before = sdf.parse("April 25, 1978");
        this._after = sdf.parse("April 27, 1978");
        this._pm = this.getPM();
        this.startTx((EntityManager)this._pm);
        AllFieldTypesTest test = new AllFieldTypesTest();
        test.setTestDate(this._date);
        Timestamp tst = new Timestamp(this.referenceTst.getTime());
        tst.setNanos(123412341);
        test.setTestTstMaxScale(tst);
        test.setTestTstScale0(tst);
        test.setTestTstScale3(tst);
        test.setTestTstScale6(tst);
        test.setTestDateMaxScale(new Date(tst.getTime()));
        test.setTestDateScale0(new Date(tst.getTime()));
        test.setTestDateScale3(new Date(tst.getTime()));
        this._pm.persist((Object)test);
        test = new AllFieldTypesTest();
        test.setTestDate(this._before);
        this._pm.persist((Object)test);
        test = new AllFieldTypesTest();
        test.setTestDate(this._after);
        this._pm.persist((Object)test);
        this.endTx((EntityManager)this._pm);
        this._pm.clear();
    }

    public void testEquals() {
        List vals = this.executeQuery("testDate = :date");
        TestDateQueries.assertEquals((int)1, (int)vals.size());
        TestDateQueries.assertEquals((Object)this._date, (Object)((AllFieldTypesTest)vals.iterator().next()).getTestDate());
    }

    public void testNotEquals() {
        List vals = this.executeQuery("testDate <> :date");
        TestDateQueries.assertEquals((int)2, (int)vals.size());
    }

    public void testDateScale() {
        DBDictionary dbDictionary = ((JDBCConfiguration)this._pm.getConfiguration()).getDBDictionaryInstance();
        if (!dbDictionary.fractionalTypeNameSet.contains(dbDictionary.timestampTypeName)) {
            this.getLog().info((Object)"skipping testDateScale because DB doesn't support different fractions in timestamps");
            return;
        }
        List vals = this.executeQuery("testDate = :date");
        AllFieldTypesTest aft = (AllFieldTypesTest)vals.iterator().next();
        TestDateQueries.assertNotNull((Object)aft);
        long time = aft.getTestTstMaxScale().getTime();
        long nanos = aft.getTestTstMaxScale().getNanos();
        TestDateQueries.assertEquals((long)this.referenceTst.getTime(), (long)(time - time % 1000L));
        int maxDigitsFromDb = this.getNonZeroDigits(nanos);
        if (maxDigitsFromDb >= 3) {
            time = aft.getTestTstScale0().getTime();
            nanos = aft.getTestTstScale0().getNanos();
            TestDateQueries.assertEquals((long)this.referenceTst.getTime(), (long)(time - time % 1000L));
            TestDateQueries.assertEquals((int)0, (int)this.getNonZeroDigits(nanos));
            time = aft.getTestDateScale0().getTime();
            TestDateQueries.assertEquals((long)this.referenceTst.getTime(), (long)(time - time % 1000L));
            time = aft.getTestTstScale3().getTime();
            nanos = aft.getTestTstScale3().getNanos();
            TestDateQueries.assertEquals((long)this.referenceTst.getTime(), (long)(time - time % 1000L));
            TestDateQueries.assertEquals((int)3, (int)this.getNonZeroDigits(nanos));
            time = aft.getTestDateMaxScale().getTime();
            TestDateQueries.assertEquals((long)(this.referenceTst.getTime() + 123L), (long)time);
            time = aft.getTestDateScale3().getTime();
            TestDateQueries.assertEquals((long)(this.referenceTst.getTime() + 123L), (long)time);
        }
        if (maxDigitsFromDb >= 6) {
            time = aft.getTestTstScale6().getTime();
            nanos = aft.getTestTstScale6().getNanos();
            TestDateQueries.assertEquals((long)this.referenceTst.getTime(), (long)(time - time % 1000L));
            TestDateQueries.assertEquals((int)6, (int)this.getNonZeroDigits(nanos));
        }
    }

    private int getNonZeroDigits(long val) {
        int digits;
        String sval = Long.toString(val);
        for (digits = 0; digits < sval.length() && sval.charAt(digits) != '0'; ++digits) {
        }
        return digits;
    }

    public void testBefore() {
        List vals = this.executeQuery("testDate < :date");
        TestDateQueries.assertEquals((int)1, (int)vals.size());
        TestDateQueries.assertEquals((Object)this._before, (Object)((AllFieldTypesTest)vals.iterator().next()).getTestDate());
    }

    public void testAfter() {
        List vals = this.executeQuery("testDate > :date");
        TestDateQueries.assertEquals((int)1, (int)vals.size());
        TestDateQueries.assertEquals((Object)this._after, (Object)((AllFieldTypesTest)vals.iterator().next()).getTestDate());
    }

    public void testOrderBy() {
        String query = "SELECT o FROM AllFieldTypesTest o ORDER BY o.testDate ASC";
        OpenJPAQuery q = this._pm.createQuery(query);
        List vals = q.getResultList();
        TestDateQueries.assertEquals((int)3, (int)vals.size());
        Iterator i = vals.iterator();
        TestDateQueries.assertEquals((Object)this._before, (Object)((AllFieldTypesTest)i.next()).getTestDate());
        TestDateQueries.assertEquals((Object)this._date, (Object)((AllFieldTypesTest)i.next()).getTestDate());
        TestDateQueries.assertEquals((Object)this._after, (Object)((AllFieldTypesTest)i.next()).getTestDate());
    }

    private List executeQuery(String filter) {
        String query = "SELECT o FROM AllFieldTypesTest o WHERE o." + filter;
        OpenJPAQuery q = this._pm.createQuery(query);
        q.setParameter("date", (Object)this._date);
        return q.getResultList();
    }
}

